ALTER TABLE account ADD type integer;
ALTER TABLE account ADD constraint ck_account_type check (type in (0,1,2));
UPDATE account set type = 0 WHERE read_only = 1;
UPDATE account set type = 2 WHERE read_only = 0;

# before dropping columns with default, drop the constraint first!
DECLARE @sql NVARCHAR(MAX)
SELECT TOP 1 @sql = N'alter table account drop constraint ['+dc.NAME+N']'
FROM sys.default_constraints dc
JOIN sys.columns c ON c.default_object_id = dc.object_id
WHERE dc.parent_object_id = OBJECT_ID('account') AND c.name = N'read_only'
EXEC (@sql);
# Now we can drop the column
ALTER TABLE account DROP COLUMN read_only;

UPDATE applicationinfo SET prop_value='69' WHERE prop_name='db_layout';
