create table pmt_props (
  id                        number(10) not null,
  bank_id                   number(10) not null,
  dtazv_separat             number(1),
  sepa_cdt_ver              number(10),
  sepa_dbt_ver              number(10),
  sepa_dbt_ldtime           number(10),
  sepa_cdt_ftype            varchar2(50),
  sepa_coredbt_ftype        varchar2(50),
  sepa_b2bdbt_ftype         varchar2(50),
  cfonb160_sender           varchar2(6),
  cfonb160_allowxpf         number(1),
  cfonb320_custid           varchar2(16),
  constraint uq_pmt_props_bank_id unique (bank_id),
  constraint pk_pmt_props primary key (id))
;

create table pmt_xchgrate (
  id                        number(10) not null,
  currency_code             varchar2(3) not null,
  exchange_rate             number(38,10) not null,
  rate_time                 timestamp,
  constraint uq_pmt_xchgrate_currency_code unique (currency_code),
  constraint pk_pmt_xchgrate primary key (id))
;

create sequence pmt_props_seq;
create sequence pmt_xchgrate_seq;

alter table pmt_props add constraint fk_pmt_props_bank_1 foreign key (bank_id) references bank (id);

UPDATE applicationinfo SET prop_value='60' WHERE prop_name='db_layout';
