create table pmt_props (
  id                        integer auto_increment not null,
  bank_id                   integer not null,
  dtazv_separat             tinyint(1) default 0,
  sepa_cdt_ver              integer,
  sepa_dbt_ver              integer,
  sepa_dbt_ldtime           integer,
  sepa_cdt_ftype            varchar(50),
  sepa_coredbt_ftype        varchar(50),
  sepa_b2bdbt_ftype         varchar(50),
  cfonb160_sender           varchar(6),
  cfonb160_allowxpf         tinyint(1) default 0,
  cfonb320_custid           varchar(16),
  constraint pk_pmt_props primary key (id))
;

create table pmt_xchgrate (
  id                        integer auto_increment not null,
  currency_code             varchar(3) not null,
  exchange_rate             decimal(38,10) not null,
  rate_time                 datetime,
  constraint uq_pmt_xchgrate_currency_code unique (currency_code),
  constraint pk_pmt_xchgrate primary key (id))
;

alter table pmt_props add constraint fk_pmt_props_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;
create index ix_pmt_props_bank_1 on pmt_props (bank_id);

UPDATE applicationinfo SET prop_value='60' WHERE prop_name='db_layout';
