alter table bankuser alter column bank_id integer not null;
alter table bankuser alter column user_id integer not null;

create table cm_balance (
  id                        integer not null,
  account_id                integer,
  account_type              integer,
  value_date                date,
  value_balance             decimal(38,3),
  booking_balance           decimal(38,3),
  value_balance_with_advice decimal(38,3),
  constraint ck_cm_balance_account_type check (account_type in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17)),
  constraint pk_cm_balance primary key (id))
;

DROP TABLE cm_value_balance;

create sequence cm_balance_seq;
DROP SEQUENCE cm_value_balance_seq;

alter table cm_balance add constraint fk_cm_balance_account_1 foreign key (account_id) references account (id) on delete restrict on update restrict;
create index ix_cm_balance_account_1 on cm_balance (account_id);

UPDATE applicationinfo SET prop_value='57' WHERE prop_name='db_layout';
