create table pmt_periodic (
  id                        number(10) not null,
  bank_id                   number(10) not null,
  account                   varchar2(50),
  order_type                varchar2(3),
  file_type                 varchar2(50),
  is_credit                 number(1),
  recipient                 varchar2(70),
  amount                    number(38,3),
  amount_currency           varchar2(3),
  purpose                   varchar2(128),
  exec_ival                 number(10) not null,
  first_execution_date      date,
  last_execution_date       date,
  previous_execution_date   date,
  next_execution_date       date,
  payment_data              blob,
  generic_purpose           varchar2(150),
  constraint ck_pmt_periodic_exec_ival check (exec_ival in (0,1,2,3,4,5,6,7)),
  constraint pk_pmt_periodic primary key (id))
;

create sequence pmt_periodic_seq;

alter table pmt_periodic add constraint fk_pmt_periodic_bank_1 foreign key (bank_id) references bank (id);
create index ix_pmt_periodic_bank_1 on pmt_periodic (bank_id);

UPDATE applicationinfo SET prop_value='47' WHERE prop_name='db_layout';
