create table pmt_periodic (
  id                        integer auto_increment not null,
  bank_id                   integer not null,
  account                   varchar(50),
  order_type                varchar(3),
  file_type                 varchar(50),
  is_credit                 tinyint(1) default 0,
  recipient                 varchar(70),
  amount                    decimal(38,3),
  amount_currency           varchar(3),
  purpose                   varchar(128),
  exec_ival                 integer not null,
  first_execution_date      date,
  last_execution_date       date,
  previous_execution_date   date,
  next_execution_date       date,
  payment_data              longblob,
  generic_purpose           varchar(150),
  constraint pk_pmt_periodic primary key (id))
;

alter table pmt_periodic add constraint fk_pmt_periodic_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;
create index ix_pmt_periodic_bank_1 on pmt_periodic (bank_id);

UPDATE applicationinfo SET prop_value='47' WHERE prop_name='db_layout';
