DROP TABLE cm_booking;
DROP TABLE cm_check;
DROP TABLE cm_page;
DROP TABLE cm_statement;

create table cm_booking (
  id                        number(10) not null,
  statement_id              number(10),
  page_id                   number(10),
  account_id                number(10),
  parent_booking_id         number(10),
  pos                       number(10),
  booking_date              date,
  value_date                date,
  local_party               varchar2(140),
  local_party_bank_code     varchar2(30),
  local_party_account_number varchar2(40),
  local_party_mandate_reference varchar2(35),
  counter_party             varchar2(140),
  counter_party_bank_code   varchar2(30),
  counter_party_account_number varchar2(40),
  counter_party_creditor_id varchar2(35),
  purpose                   varchar2(400),
  purpose_overview          varchar2(140),
  amount                    number(38,3),
  currency_code             varchar2(3),
  original_amount           number(38,3),
  original_currency         varchar2(3),
  charges_amount            number(38,3),
  charges_currency          varchar2(3),
  converted_amount          number(38,3),
  converted_currency        varchar2(3),
  exchange_rate             number(38,3),
  exchange_rate_date        date,
  booking_key               varchar2(3),
  booking_text              varchar2(27),
  gvc                       varchar2(3),
  primanota                 varchar2(10),
  text_key_appendix         varchar2(3),
  additional_information    varchar2(500),
  bank_reference            varchar2(35),
  customer_reference        varchar2(35),
  end_to_end_id             varchar2(35),
  balance                   number(38,3),
  collective                number(1),
  debit                     number(1),
  reversal                  number(1),
  constraint pk_cm_booking primary key (id))
;

create table cm_check (
  id                        number(10) not null,
  login_id                  number(10),
  statement_id              number(10),
  checked                   number(1),
  constraint pk_cm_check primary key (id))
;

create table cm_page (
  id                        number(10) not null,
  statement_id              number(10),
  file_name                 varchar2(255) not null,
  creation_date             timestamp,
  reference1                varchar2(255),
  reference2                varchar2(255),
  closing_date              date,
  closing_balance           number(38,3),
  closing_final             number(1),
  opening_date              date,
  opening_balance           number(38,3),
  opening_final             number(1),
  currency_code             varchar2(3),
  page_number               number(10),
  count_credit              number(10),
  count_debit               number(10),
  sum_credit                number(38,3),
  sum_debit                 number(38,3),
  max_credit                number(38,3),
  min_credit                number(38,3),
  max_debit                 number(38,3),
  min_debit                 number(38,3),
  constraint uq_cm_page_file_name unique (file_name),
  constraint pk_cm_page primary key (id))
;

create table cm_statement (
  id                        number(10) not null,
  account_id                number(10),
  file_name                 varchar2(255),
  creation_date             timestamp,
  reference1                varchar2(255),
  reference2                varchar2(255),
  opening_date              date,
  opening_balance           number(38,3),
  opening_final             number(1),
  closing_date              date,
  closing_balance           number(38,3),
  closing_final             number(1),
  currency_code             varchar2(3),
  statement_number          number(10),
  unique_id                 varchar2(255),
  count_credit              number(10),
  count_debit               number(10),
  sum_credit                number(38,3),
  sum_debit                 number(38,3),
  max_credit                number(38,3),
  min_credit                number(38,3),
  max_debit                 number(38,3),
  min_debit                 number(38,3),
  type                      number(10) not null,
  constraint ck_cm_statement_type check (type in (0,1,2)),
  constraint pk_cm_statement primary key (id))
;

alter table cm_booking add constraint fk_cm_booking_statement_1 foreign key (statement_id) references cm_statement (id);
create index ix_cm_booking_statement_1 on cm_booking (statement_id);
alter table cm_booking add constraint fk_cm_booking_page_1 foreign key (page_id) references cm_page (id);
create index ix_cm_booking_page_1 on cm_booking (page_id);
alter table cm_booking add constraint fk_cm_booking_account_1 foreign key (account_id) references account (id);
create index ix_cm_booking_account_1 on cm_booking (account_id);
alter table cm_booking add constraint fk_cm_booking_parentBooking_1 foreign key (parent_booking_id) references cm_booking (id);
create index ix_cm_booking_parentBooking_1 on cm_booking (parent_booking_id);
alter table cm_check add constraint fk_cm_check_login_1 foreign key (login_id) references loginuser (id);
create index ix_cm_check_login_1 on cm_check (login_id);
alter table cm_check add constraint fk_cm_check_statement_1 foreign key (statement_id) references cm_statement (id);
create index ix_cm_check_statement_1 on cm_check (statement_id);
alter table cm_page add constraint fk_cm_page_statement_1 foreign key (statement_id) references cm_statement (id);
create index ix_cm_page_statement_1 on cm_page (statement_id);
alter table cm_statement add constraint fk_cm_statement_account_1 foreign key (account_id) references account (id);
create index ix_cm_statement_account_1 on cm_statement (account_id);

UPDATE applicationinfo SET prop_value='45' WHERE prop_name='db_layout';
