DROP TABLE cm_booking;
DROP TABLE cm_check;
DROP TABLE cm_page;
DROP TABLE cm_statement;

create table cm_booking (
  id                        integer identity(1,1) not null,
  statement_id              integer,
  page_id                   integer,
  account_id                integer,
  parent_booking_id         integer,
  pos                       integer,
  booking_date              datetime,
  value_date                datetime,
  local_party               varchar(140),
  local_party_bank_code     varchar(30),
  local_party_account_number varchar(40),
  local_party_mandate_reference varchar(35),
  counter_party             varchar(140),
  counter_party_bank_code   varchar(30),
  counter_party_account_number varchar(40),
  counter_party_creditor_id varchar(35),
  purpose                   varchar(400),
  purpose_overview          varchar(140),
  amount                    numeric(28,3),
  currency_code             varchar(3),
  original_amount           numeric(28,3),
  original_currency         varchar(3),
  charges_amount            numeric(28,3),
  charges_currency          varchar(3),
  converted_amount          numeric(28,3),
  converted_currency        varchar(3),
  exchange_rate             numeric(28,3),
  exchange_rate_date        datetime,
  booking_key               varchar(3),
  booking_text              varchar(27),
  gvc                       varchar(3),
  primanota                 varchar(10),
  text_key_appendix         varchar(3),
  additional_information    varchar(500),
  bank_reference            varchar(35),
  customer_reference        varchar(35),
  end_to_end_id             varchar(35),
  balance                   numeric(28,3),
  collective                bit default 0,
  debit                     bit default 0,
  reversal                  bit default 0,
  constraint pk_cm_booking primary key (id))
;

create table cm_check (
  id                        integer identity(1,1) not null,
  login_id                  integer,
  statement_id              integer,
  checked                   bit default 0,
  constraint pk_cm_check primary key (id))
;

create table cm_page (
  id                        integer identity(1,1) not null,
  statement_id              integer,
  file_name                 varchar(255) not null,
  creation_date             datetime,
  reference1                varchar(255),
  reference2                varchar(255),
  closing_date              datetime,
  closing_balance           numeric(28,3),
  closing_final             bit default 0,
  opening_date              datetime,
  opening_balance           numeric(28,3),
  opening_final             bit default 0,
  currency_code             varchar(3),
  page_number               integer,
  count_credit              integer,
  count_debit               integer,
  sum_credit                numeric(28,3),
  sum_debit                 numeric(28,3),
  max_credit                numeric(28,3),
  min_credit                numeric(28,3),
  max_debit                 numeric(28,3),
  min_debit                 numeric(28,3),
  constraint uq_cm_page_file_name unique (file_name),
  constraint pk_cm_page primary key (id))
;

create table cm_statement (
  id                        integer identity(1,1) not null,
  account_id                integer,
  file_name                 varchar(255),
  creation_date             datetime,
  reference1                varchar(255),
  reference2                varchar(255),
  opening_date              datetime,
  opening_balance           numeric(28,3),
  opening_final             bit default 0,
  closing_date              datetime,
  closing_balance           numeric(28,3),
  closing_final             bit default 0,
  currency_code             varchar(3),
  statement_number          integer,
  unique_id                 varchar(255),
  count_credit              integer,
  count_debit               integer,
  sum_credit                numeric(28,3),
  sum_debit                 numeric(28,3),
  max_credit                numeric(28,3),
  min_credit                numeric(28,3),
  max_debit                 numeric(28,3),
  min_debit                 numeric(28,3),
  type                      integer not null,
  constraint ck_cm_statement_type check (type in (0,1,2)),
  constraint pk_cm_statement primary key (id))
;

alter table cm_booking add constraint fk_cm_booking_statement_1 foreign key (statement_id) references cm_statement (id);
create index ix_cm_booking_statement_1 on cm_booking (statement_id);
alter table cm_booking add constraint fk_cm_booking_page_1 foreign key (page_id) references cm_page (id);
create index ix_cm_booking_page_1 on cm_booking (page_id);
alter table cm_booking add constraint fk_cm_booking_account_1 foreign key (account_id) references account (id);
create index ix_cm_booking_account_1 on cm_booking (account_id);
alter table cm_booking add constraint fk_cm_booking_parentBooking_1 foreign key (parent_booking_id) references cm_booking (id);
create index ix_cm_booking_parentBooking_1 on cm_booking (parent_booking_id);
alter table cm_check add constraint fk_cm_check_login_1 foreign key (login_id) references loginuser (id);
create index ix_cm_check_login_1 on cm_check (login_id);
alter table cm_check add constraint fk_cm_check_statement_1 foreign key (statement_id) references cm_statement (id);
create index ix_cm_check_statement_1 on cm_check (statement_id);
alter table cm_page add constraint fk_cm_page_statement_1 foreign key (statement_id) references cm_statement (id);
create index ix_cm_page_statement_1 on cm_page (statement_id);
alter table cm_statement add constraint fk_cm_statement_account_1 foreign key (account_id) references account (id);
create index ix_cm_statement_account_1 on cm_statement (account_id);

UPDATE applicationinfo SET prop_value='45' WHERE prop_name='db_layout';
