create table pmt_open (
  id                        integer auto_increment not null,
  bank_id                   integer not null,
  account_id                integer,
  order_type                varchar(3),
  file_type                 varchar(50),
  recipient                 varchar(70),
  amount                    decimal(38,3),
  amount_currency           varchar(3),
  purpose                   varchar(128),
  execution_date            date,
  payment_data              longblob,
  constraint pk_pmt_open primary key (id))
;

alter table pmt_open add constraint fk_pmt_open_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;
create index ix_pmt_open_bank_1 on pmt_open (bank_id);
alter table pmt_open add constraint fk_pmt_open_account_1 foreign key (account_id) references account (id) on delete restrict on update restrict;
create index ix_pmt_open_account_1 on pmt_open (account_id);

UPDATE applicationinfo SET prop_value='43' WHERE prop_name='db_layout';
