create table pmt_originator (
  id                        number(10) not null,
  name                      varchar2(255),
  payment_type              number(10) not null,
  originator_info           clob,
  constraint ck_pmt_originator_payment_type check (payment_type in (0,1,2,3,4,5)),
  constraint pk_pmt_originator primary key (id))
;

create table pmt_recipient (
  id                        number(10) not null,
  payment_type              number(10) not null,
  display_name              varchar2(128),
  name                      varchar2(70),
  account_number            varchar2(34),
  bank_code                 varchar2(15),
  bank_name                 varchar2(128),
  purpose                   varchar2(255),
  recipient_info            clob,
  constraint ck_pmt_recipient_payment_type check (payment_type in (0,1,2,3,4,5)),
  constraint pk_pmt_recipient primary key (id))
;

create sequence pmt_originator_seq;

create sequence pmt_recipient_seq;

UPDATE applicationinfo SET prop_value='39' WHERE prop_name='db_layout';
