create table pmt_originator (
  id                        integer not null,
  name                      varchar(255),
  payment_type              integer not null,
  originator_info           clob,
  constraint ck_pmt_originator_payment_type check (payment_type in (0,1,2,3,4,5)),
  constraint pk_pmt_originator primary key (id))
;

create table pmt_recipient (
  id                        integer not null,
  payment_type              integer not null,
  display_name              varchar(128),
  name                      varchar(70),
  account_number            varchar(34),
  bank_code                 varchar(15),
  bank_name                 varchar(128),
  purpose                   varchar(255),
  recipient_info            clob,
  constraint ck_pmt_recipient_payment_type check (payment_type in (0,1,2,3,4,5)),
  constraint pk_pmt_recipient primary key (id))
;

create sequence pmt_originator_seq;

create sequence pmt_recipient_seq;

UPDATE applicationinfo SET prop_value='39' WHERE prop_name='db_layout';
