DROP TABLE cm_booking;
create table cm_booking (
  id                        number(10) not null,
  statement_id              number(10),
  page_id                   number(10),
  account_id                number(10),
  parent_booking_id         number(10),
  pos                       number(10),
  booking_date              date,
  value_date                date,
  local_party               varchar2(140),
  local_party_bank_code     varchar2(30),
  local_party_account_number varchar2(40),
  local_party_mandate_reference varchar2(35),
  counter_party             varchar2(140),
  counter_party_bank_code   varchar2(30),
  counter_party_account_number varchar2(40),
  counter_party_creditor_id varchar2(35),
  purpose                   varchar2(400),
  amount                    number(38,3),
  currency_code             varchar2(3),
  original_amount           number(38,3),
  original_currency         varchar2(3),
  charges_amount            number(38,3),
  charges_currency          varchar2(3),
  converted_amount          number(38,3),
  converted_currency        varchar2(3),
  exchange_rate             number(38,3),
  exchange_rate_date        date,
  booking_key               varchar2(3),
  booking_text              varchar2(27),
  gvc                       varchar2(3),
  primanota                 varchar2(10),
  text_key_appendix         varchar2(3),
  additional_information    varchar2(34),
  bank_reference            varchar2(16),
  customer_reference        varchar2(35),
  end_to_end_id             varchar2(35),
  balance                   number(38,3),
  collective                number(1),
  debit                     number(1),
  reversal                  number(1),
  constraint pk_cm_booking primary key (id))
;

alter table cm_booking add constraint fk_cm_booking_statement_1 foreign key (statement_id) references cm_statement (id);
create index ix_cm_booking_statement_1 on cm_booking (statement_id);
alter table cm_booking add constraint fk_cm_booking_page_1 foreign key (page_id) references cm_page (id);
create index ix_cm_booking_page_1 on cm_booking (page_id);
alter table cm_booking add constraint fk_cm_booking_account_1 foreign key (account_id) references account (id);
create index ix_cm_booking_account_1 on cm_booking (account_id);
alter table cm_booking add constraint fk_cm_booking_parentBooking_1 foreign key (parent_booking_id) references cm_booking (id);
create index ix_cm_booking_parentBooking_1 on cm_booking (parent_booking_id);

UPDATE applicationinfo SET prop_value='38' WHERE prop_name='db_layout';
