DROP TABLE cm_booking;

create table cm_booking (
  id                        integer auto_increment not null,
  statement_id              integer,
  page_id                   integer,
  account_id                integer,
  parent_booking_id         integer,
  pos                       integer,
  booking_date              date,
  value_date                date,
  local_party               varchar(140),
  local_party_bank_code     varchar(30),
  local_party_account_number varchar(40),
  local_party_mandate_reference varchar(35),
  counter_party             varchar(140),
  counter_party_bank_code   varchar(30),
  counter_party_account_number varchar(40),
  counter_party_creditor_id varchar(35),
  purpose                   varchar(400),
  amount                    decimal(38,3),
  currency_code             varchar(3),
  original_amount           decimal(38,3),
  original_currency         varchar(3),
  charges_amount            decimal(38,3),
  charges_currency          varchar(3),
  converted_amount          decimal(38,3),
  converted_currency        varchar(3),
  exchange_rate             decimal(38,3),
  exchange_rate_date        date,
  balance                   decimal(38,3),
  collective                tinyint(1) default 0,
  constraint pk_cm_booking primary key (id))
;

alter table cm_booking add constraint fk_cm_booking_statement_1 foreign key (statement_id) references cm_statement (id) on delete restrict on update restrict;
create index ix_cm_booking_statement_1 on cm_booking (statement_id);
alter table cm_booking add constraint fk_cm_booking_page_1 foreign key (page_id) references cm_page (id) on delete restrict on update restrict;
create index ix_cm_booking_page_1 on cm_booking (page_id);
alter table cm_booking add constraint fk_cm_booking_account_1 foreign key (account_id) references account (id) on delete restrict on update restrict;
create index ix_cm_booking_account_1 on cm_booking (account_id);
alter table cm_booking add constraint fk_cm_booking_parentBooking_1 foreign key (parent_booking_id) references cm_booking (id) on delete restrict on update restrict;
create index ix_cm_booking_parentBooking_1 on cm_booking (parent_booking_id);

UPDATE applicationinfo SET prop_value='34' WHERE prop_name='db_layout';
