DROP TABLE cm_booking;
DROP TABLE cm_page;
DROP TABLE cm_check;
DROP TABLE cm_statement;

create table cm_booking (
  id                        integer auto_increment not null,
  statement_id              integer,
  page_id                   integer,
  account_id                integer,
  parent_booking_id         integer,
  pos                       integer,
  booking_date              date,
  value_date                date,
  counter_party             varchar(255),
  purpose                   varchar(255),
  amount                    decimal(38,3),
  currency_code             varchar(255),
  balance                   decimal(38,3),
  collective                tinyint(1) default 0,
  constraint pk_cm_booking primary key (id))
;

create table cm_check (
  id                        integer auto_increment not null,
  login_id                  integer,
  statement_id              integer,
  checked                   tinyint(1) default 0,
  constraint pk_cm_check primary key (id))
;

create table cm_page (
  id                        integer auto_increment not null,
  statement_id              integer,
  file_name                 varchar(255) not null,
  reference1                varchar(255),
  reference2                varchar(255),
  closing_date              date,
  closing_balance           decimal(38,3),
  opening_date              date,
  opening_balance           decimal(38,3),
  currency_code             varchar(3),
  page_number               integer,
  count_credit              integer,
  count_debit               integer,
  sum_credit                decimal(38,3),
  sum_debit                 decimal(38,3),
  max_credit                decimal(38,3),
  min_credit                decimal(38,3),
  max_debit                 decimal(38,3),
  min_debit                 decimal(38,3),
  constraint uq_cm_page_file_name unique (file_name),
  constraint pk_cm_page primary key (id))
;

create table cm_statement (
  id                        integer auto_increment not null,
  account_id                integer,
  file_name                 varchar(255),
  creation_date             date,
  reference1                varchar(255),
  reference2                varchar(255),
  opening_date              date,
  opening_balance           decimal(38,3),
  closing_date              date not null,
  closing_balance           decimal(38,3) not null,
  currency_code             varchar(3),
  statement_number          integer,
  unique_id                 varchar(255),
  advice                    tinyint(1) default 0,
  count_credit              integer,
  count_debit               integer,
  sum_credit                decimal(38,3),
  sum_debit                 decimal(38,3),
  max_credit                decimal(38,3),
  min_credit                decimal(38,3),
  max_debit                 decimal(38,3),
  min_debit                 decimal(38,3),
  type                      integer not null,
  constraint ck_cm_statement_type check (type in (0,1,2)),
  constraint pk_cm_statement primary key (id))
;

alter table cm_booking add constraint fk_cm_booking_statement_1 foreign key (statement_id) references cm_statement (id) on delete restrict on update restrict;
create index ix_cm_booking_statement_1 on cm_booking (statement_id);
alter table cm_booking add constraint fk_cm_booking_page_1 foreign key (page_id) references cm_page (id) on delete restrict on update restrict;
create index ix_cm_booking_page_1 on cm_booking (page_id);
alter table cm_booking add constraint fk_cm_booking_account_1 foreign key (account_id) references account (id) on delete restrict on update restrict;
create index ix_cm_booking_account_1 on cm_booking (account_id);
alter table cm_booking add constraint fk_cm_booking_parentBooking_1 foreign key (parent_booking_id) references cm_booking (id) on delete restrict on update restrict;
create index ix_cm_booking_parentBooking_1 on cm_booking (parent_booking_id);
alter table cm_check add constraint fk_cm_check_login_1 foreign key (login_id) references loginuser (id) on delete restrict on update restrict;
create index ix_cm_check_login_1 on cm_check (login_id);
alter table cm_check add constraint fk_cm_check_statement_1 foreign key (statement_id) references cm_statement (id) on delete restrict on update restrict;
create index ix_cm_check_statement_1 on cm_check (statement_id);
alter table cm_page add constraint fk_cm_page_statement_1 foreign key (statement_id) references cm_statement (id) on delete restrict on update restrict;
create index ix_cm_page_statement_1 on cm_page (statement_id);
alter table cm_statement add constraint fk_cm_statement_account_1 foreign key (account_id) references account (id) on delete restrict on update restrict;
create index ix_cm_statement_account_1 on cm_statement (account_id);

UPDATE applicationinfo SET prop_value='30' WHERE prop_name='db_layout';
