create table account_permission (
  id                        number(10) not null,
  bank_user_id              number(10) not null,
  account_id                number(10) not null,
  constraint pk_account_permission primary key (id))
;
create table order_type (
  id                        number(10) not null,
  bank_id                   number(10),
  transfer_type             number(10) not null,
  order_type                varchar2(3),
  file_format               varchar2(50),
  order_format              varchar2(8),
  num_sig_required          number(10),
  description               varchar2(128),
  constraint ck_order_type_transfer_type check (transfer_type in (0,1)),
  constraint pk_order_type primary key (id))
;
create table user_permission (
  id                        number(10) not null,
  bank_user_id              number(10) not null,
  order_type_id             number(10),
  auth_level                number(10),
  max_amount                number(38),
  account_permission_id     number(10),
  constraint ck_user_permission_auth_level check (auth_level in (0,1,2,3)),
  constraint pk_user_permission primary key (id))
;

create sequence account_permission_seq;
create sequence order_type_seq;
create sequence user_permission_seq;

alter table account_permission add constraint fk_account_permission_bankUs_1 foreign key (bank_user_id) references bankuser (id);
create index ix_account_permission_bankUs_1 on account_permission (bank_user_id);
alter table account_permission add constraint fk_account_permission_accoun_1 foreign key (account_id) references account (id);
create index ix_account_permission_accoun_1 on account_permission (account_id);
alter table order_type add constraint fk_order_type_bank_1 foreign key (bank_id) references bank (id);
create index ix_order_type_bank_1 on order_type (bank_id);
alter table user_permission add constraint fk_user_permission_bankUser_1 foreign key (bank_user_id) references bankuser (id);
create index ix_user_permission_bankUser_1 on user_permission (bank_user_id);
alter table user_permission add constraint fk_user_permission_orderType_1 foreign key (order_type_id) references order_type (id);
create index ix_user_permission_orderType_1 on user_permission (order_type_id);
alter table user_permission add constraint fk_user_permission_accountPe_1 foreign key (account_permission_id) references account_permission (id);
create index ix_user_permission_accountPe_1 on user_permission (account_permission_id);

UPDATE applicationinfo SET prop_value='29' WHERE prop_name='db_layout';
