create table account_permission (
  id                        integer not null,
  bank_user_id              integer not null,
  account_id                integer not null,
  constraint pk_account_permission primary key (id))
;
create table order_type (
  id                        integer not null,
  bank_id                   integer,
  transfer_type             integer not null,
  order_type                varchar(3),
  file_format               varchar(50),
  order_format              varchar(8),
  num_sig_required          integer,
  description               varchar(128),
  constraint ck_order_type_transfer_type check (transfer_type in (0,1)),
  constraint pk_order_type primary key (id))
;
create table user_permission (
  id                        integer not null,
  bank_user_id              integer not null,
  order_type_id             integer,
  auth_level                integer,
  max_amount                decimal(38),
  account_permission_id     integer,
  constraint ck_user_permission_auth_level check (auth_level in (0,1,2,3)),
  constraint pk_user_permission primary key (id))
;

create sequence account_permission_seq;
create sequence order_type_seq;
create sequence user_permission_seq;

alter table account_permission add constraint fk_account_permission_bankUser_1 foreign key (bank_user_id) references bankuser (id) on delete restrict on update restrict;
create index ix_account_permission_bankUser_1 on account_permission (bank_user_id);
alter table account_permission add constraint fk_account_permission_account_1 foreign key (account_id) references account (id) on delete restrict on update restrict;
create index ix_account_permission_account_1 on account_permission (account_id);
alter table order_type add constraint fk_order_type_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;
create index ix_order_type_bank_1 on order_type (bank_id);
alter table user_permission add constraint fk_user_permission_bankUser_1 foreign key (bank_user_id) references bankuser (id) on delete restrict on update restrict;
create index ix_user_permission_bankUser_1 on user_permission (bank_user_id);
alter table user_permission add constraint fk_user_permission_orderType_1 foreign key (order_type_id) references order_type (id) on delete restrict on update restrict;
create index ix_user_permission_orderType_1 on user_permission (order_type_id);
alter table user_permission add constraint fk_user_permission_accountPerm_1 foreign key (account_permission_id) references account_permission (id) on delete restrict on update restrict;
create index ix_user_permission_accountPerm_1 on user_permission (account_permission_id);

UPDATE applicationinfo SET prop_value='29' WHERE prop_name='db_layout';
