create table cm_booking (
  id                        number(10) not null,
  statement_id              number(10),
  page_id                   number(10),
  account_id                number(10),
  parent_booking_id         number(10),
  pos                       number(10),
  booking_date              date,
  value_date                date,
  counter_party             varchar2(255),
  purpose                   varchar2(255),
  amount                    number(38,3),
  currency_code             varchar2(255),
  balance                   number(38,3),
  collective                number(1),
  constraint pk_cm_booking primary key (id))
;

create table cm_check (
  id                        number(10) not null,
  login_id                  number(10),
  statement_id              number(10),
  checked                   number(1),
  constraint pk_cm_check primary key (id))
;

create table cm_page (
  id                        number(10) not null,
  statement_id              number(10),
  file_name                 varchar2(255) not null,
  booking_date              date,
  balance                   number(38,3),
  opening_date              date,
  opening_balance           number(38,3),
  currency_code             varchar2(3),
  page_number               number(10),
  constraint uq_cm_page_file_name unique (file_name),
  constraint pk_cm_page primary key (id))
;

create table cm_statement (
  id                        number(10) not null,
  account_id                number(10),
  file_name                 varchar2(255),
  bank_reference            varchar2(255),
  opening_date              date,
  opening_balance           number(38,3),
  booking_date              date,
  balance                   number(38,3),
  currency_code             varchar2(3),
  statement_number          number(10),
  unique_id                 varchar2(255),
  advice                    number(1),
  type                      number(10) not null,
  constraint ck_cm_statement_type check (type in (0,1,2)),
  constraint pk_cm_statement primary key (id))
;

create sequence cm_booking_seq;

create sequence cm_check_seq;

create sequence cm_page_seq;

create sequence cm_statement_seq;

alter table cm_booking add constraint fk_cm_booking_statement_1 foreign key (statement_id) references cm_statement (id);
create index ix_cm_booking_statement_1 on cm_booking (statement_id);
alter table cm_booking add constraint fk_cm_booking_page_1 foreign key (page_id) references cm_page (id);
create index ix_cm_booking_page_1 on cm_booking (page_id);
alter table cm_booking add constraint fk_cm_booking_account_1 foreign key (account_id) references account (id);
create index ix_cm_booking_account_1 on cm_booking (account_id);
alter table cm_booking add constraint fk_cm_booking_parentBooking_1 foreign key (parent_booking_id) references cm_booking (id);
create index ix_cm_booking_parentBooking_1 on cm_booking (parent_booking_id);
alter table cm_check add constraint fk_cm_check_login_1 foreign key (login_id) references loginuser (id);
create index ix_cm_check_login_1 on cm_check (login_id);
alter table cm_check add constraint fk_cm_check_statement_1 foreign key (statement_id) references cm_statement (id);
create index ix_cm_check_statement_1 on cm_check (statement_id);
alter table cm_page add constraint fk_cm_page_statement_1 foreign key (statement_id) references cm_statement (id);
create index ix_cm_page_statement_1 on cm_page (statement_id);
alter table cm_statement add constraint fk_cm_statement_account_1 foreign key (account_id) references account (id);
create index ix_cm_statement_account_1 on cm_statement (account_id);

UPDATE applicationinfo SET prop_value='27' WHERE prop_name='db_layout';
