create table account (
  id                        number(10) not null,
  bank_id                   number(10) not null,
  name                      varchar2(50),
  description               varchar2(256),
  de_bank_code              varchar2(8),
  de_account_number         varchar2(10),
  fr_bank_code              varchar2(5),
  fr_branch_code            varchar2(5),
  fr_account_number         varchar2(11),
  fr_check_code             varchar2(2),
  iban                      varchar2(34),
  bic                       varchar2(11),
  national_bank_code        varchar2(30),
  national_account_number   varchar2(40),
  currency                  varchar2(3),
  cm_identification         varchar2(256),
  read_only                 number(1),
  active                    number(1),
  constraint pk_account primary key (id))
;

create sequence account_seq;

alter table account add constraint fk_account_bank_1 foreign key (bank_id) references bank (id);
create index ix_account_bank_1 on account (bank_id);

UPDATE applicationinfo SET prop_value='25' WHERE prop_name='db_layout';
