create table account (
  id                        integer auto_increment not null,
  bank_id                   integer not null,
  name                      varchar(50),
  description               varchar(256),
  de_bank_code              varchar(8),
  de_account_number         varchar(10),
  fr_bank_code              varchar(5),
  fr_branch_code            varchar(5),
  fr_account_number         varchar(11),
  fr_check_code             varchar(2),
  iban                      varchar(34),
  bic                       varchar(11),
  national_bank_code        varchar(30),
  national_account_number   varchar(40),
  currency                  varchar(3),
  cm_identification         varchar(256),
  read_only                 tinyint(1) default 0,
  active                    tinyint(1) default 0,
  constraint pk_account primary key (id))
;

alter table account add constraint fk_account_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;
create index ix_account_bank_1 on account (bank_id);

UPDATE applicationinfo SET prop_value='25' WHERE prop_name='db_layout';
