DROP TABLE awv_transit;
DROP TABLE awv_dirinv;
DROP TABLE awv_dika;
DROP TABLE awv_entry;

create table awv_dika (
  id                        number(10) not null,
  abstract_entry_id         number(10) not null,
  purpose                   varchar2(140),
  amount                    number(19),
  country                   varchar2(2),
  ref_amount                varchar2(30),
  stlmnt_key                varchar2(1),
  constraint pk_awv_dika primary key (id))
;

create table awv_dirinv (
  id                        number(10) not null,
  abstract_entry_id         number(10) not null,
  isin                      varchar2(12),
  label                     varchar2(35),
  st_number                 number(10),
  amount                    number(19),
  country                   varchar2(2),
  ref_amount                varchar2(30),
  stlmnt_key                varchar2(1),
  constraint pk_awv_dirinv primary key (id))
;

create table awv_entry (
  id                        number(10) not null,
  type                      number(10) not null,
  month                     varchar2(6) not null,
  reporter                  number(10),
  category                  number(10),
  svc_code                  varchar2(3),
  reference                 varchar2(35),
  cancel                    number(1) not null,
  cmnt                      varchar2(80),
  exported                  number(1) not null,
  constraint ck_awv_entry_type check (type in (0,1,2)),
  constraint pk_awv_entry primary key (id))
;

create table awv_transit (
  id                        number(10) not null,
  abstract_entry_id         number(10) not null,
  warecode                  varchar2(2),
  warename                  varchar2(140),
  amount                    number(19),
  country                   varchar2(2),
  ref_amount                varchar2(30),
  stlmnt_key                varchar2(1),
  constraint pk_awv_transit primary key (id))
;

create sequence awv_dika_seq;

alter table awv_dika add constraint fk_awv_dika_abstractEntry_1 foreign key (abstract_entry_id) references awv_entry (id);
create index ix_awv_dika_abstractEntry_1 on awv_dika (abstract_entry_id);
alter table awv_dirinv add constraint fk_awv_dirinv_abstractEntry_1 foreign key (abstract_entry_id) references awv_entry (id);
create index ix_awv_dirinv_abstractEntry_1 on awv_dirinv (abstract_entry_id);
alter table awv_entry add constraint fk_awv_entry_entryReporter_1 foreign key (reporter) references awv_contact (id);
create index ix_awv_entry_entryReporter_1 on awv_entry (reporter);
alter table awv_transit add constraint fk_awv_transit_abstractEntry_1 foreign key (abstract_entry_id) references awv_entry (id);
create index ix_awv_transit_abstractEntry_1 on awv_transit (abstract_entry_id);

UPDATE applicationinfo SET prop_value='24' WHERE prop_name='db_layout';
