DROP TABLE awv_transit;
DROP TABLE awv_dirinv;
DROP TABLE awv_dika;
DROP TABLE awv_entry;

create table awv_dika (
  id                        integer identity(1,1) not null,
  abstract_entry_id         integer not null,
  purpose                   varchar(140),
  amount                    numeric(19),
  country                   varchar(2),
  ref_amount                varchar(30),
  stlmnt_key                varchar(1),
  constraint pk_awv_dika primary key (id))
;

create table awv_dirinv (
  id                        integer identity(1,1) not null,
  abstract_entry_id         integer not null,
  isin                      varchar(12),
  label                     varchar(35),
  st_number                 integer,
  amount                    numeric(19),
  country                   varchar(2),
  ref_amount                varchar(30),
  stlmnt_key                varchar(1),
  constraint pk_awv_dirinv primary key (id))
;

create table awv_entry (
  id                        integer identity(1,1) not null,
  type                      integer not null,
  month                     varchar(6) not null,
  reporter                  integer,
  category                  integer,
  svc_code                  varchar(3),
  reference                 varchar(35),
  cancel                    bit default 0 not null,
  cmnt                      varchar(80),
  exported                  bit default 0 not null,
  constraint ck_awv_entry_type check (type in (0,1,2)),
  constraint pk_awv_entry primary key (id))
;

create table awv_transit (
  id                        integer identity(1,1) not null,
  abstract_entry_id         integer not null,
  warecode                  varchar(2),
  warename                  varchar(140),
  amount                    numeric(19),
  country                   varchar(2),
  ref_amount                varchar(30),
  stlmnt_key                varchar(1),
  constraint pk_awv_transit primary key (id))
;

alter table awv_dika add constraint fk_awv_dika_abstractEntry_1 foreign key (abstract_entry_id) references awv_entry (id);
create index ix_awv_dika_abstractEntry_1 on awv_dika (abstract_entry_id);
alter table awv_dirinv add constraint fk_awv_dirinv_abstractEntry_1 foreign key (abstract_entry_id) references awv_entry (id);
create index ix_awv_dirinv_abstractEntry_1 on awv_dirinv (abstract_entry_id);
alter table awv_entry add constraint fk_awv_entry_entryReporter_1 foreign key (reporter) references awv_contact (id);
create index ix_awv_entry_entryReporter_1 on awv_entry (reporter);
alter table awv_transit add constraint fk_awv_transit_abstractEntry_1 foreign key (abstract_entry_id) references awv_entry (id);
create index ix_awv_transit_abstractEntry_1 on awv_transit (abstract_entry_id);

UPDATE applicationinfo SET prop_value='24' WHERE prop_name='db_layout';
