create table hac_entry (
  id                        number(10) not null,
  bank_id                   number(10),
  hac_time                  timestamp not null,
  axn                       number(10),
  customer_id               varchar2(35),
  user_id                   varchar2(35),
  reason                    varchar2(4),
  order_number              varchar2(4),
  order_type                varchar2(3),
  file_type                 varchar2(255),
  constraint pk_hac_entry primary key (id))
;

create table ptk_entry (
  id                        number(10) not null,
  bank_id                   number(10),
  ptk_time                  timestamp not null,
  axn                       number(10),
  result                    number(10),
  data                      blob,
  order_number              varchar2(4),
  order_type                varchar2(3),
  file_type                 varchar2(255),
  constraint pk_ptk_entry primary key (id))
;

create table send_item (
  id                        number(10) not null,
  bank_id                   number(10),
  sent                      timestamp not null,
  file_name                 varchar2(250),
  orig_file_name            varchar2(250),
  state                     number(10),
  sender                    varchar2(71),
  file_size                 number(19) not null,
  file_type                 varchar2(255),
  order_type                varchar2(3) not null,
  order_number              varchar2(4) not null,
  amount                    number(38),
  md5hash                   varchar2(32),
  currency                  varchar2(3),
  with_selaries             number(1),
  constraint ck_send_item_state check (state in (0,1,2,3,4,5,6,7)),
  constraint pk_send_item primary key (id))
;

CREATE SEQUENCE hac_entry_seq;
CREATE SEQUENCE send_item_seq;
CREATE SEQUENCE ptk_entry_seq;

alter table hac_entry add constraint fk_hac_entry_bank_1 foreign key (bank_id) references bank (id);
create index ix_hac_entry_bank_1 on hac_entry (bank_id);
alter table ptk_entry add constraint fk_ptk_entry_bank_1 foreign key (bank_id) references bank (id);
create index ix_ptk_entry_bank_1 on ptk_entry (bank_id);
alter table send_item add constraint fk_send_item_bank_1 foreign key (bank_id) references bank (id);
create index ix_send_item_bank_1 on send_item (bank_id);

UPDATE applicationinfo SET prop_value='19' WHERE prop_name='db_layout';
