create table hac_entry (
  id                        integer auto_increment not null,
  bank_id                   integer,
  hac_time                  datetime not null,
  axn                       integer,
  customer_id               varchar(35),
  user_id                   varchar(35),
  reason                    varchar(4),
  order_number              varchar(4),
  order_type                varchar(3),
  file_type                 varchar(255),
  constraint pk_hac_entry primary key (id))
;

create table ptk_entry (
  id                        integer auto_increment not null,
  bank_id                   integer,
  ptk_time                  datetime not null,
  axn                       integer,
  result                    integer,
  data                      longblob,
  order_number              varchar(4),
  order_type                varchar(3),
  file_type                 varchar(255),
  constraint pk_ptk_entry primary key (id))
;

create table send_item (
  id                        integer auto_increment not null,
  bank_id                   integer,
  sent                      datetime not null,
  file_name                 varchar(250),
  orig_file_name            varchar(250),
  state                     integer,
  sender                    varchar(71),
  file_size                 bigint not null,
  file_type                 varchar(255),
  order_type                varchar(3) not null,
  order_number              varchar(4) not null,
  amount                    decimal(38),
  md5hash                   varchar(32),
  currency                  varchar(3),
  with_selaries             tinyint(1) default 0,
  constraint ck_send_item_state check (state in (0,1,2,3,4,5,6,7)),
  constraint pk_send_item primary key (id))
;

alter table hac_entry add constraint fk_hac_entry_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;
create index ix_hac_entry_bank_1 on hac_entry (bank_id);
alter table ptk_entry add constraint fk_ptk_entry_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;
create index ix_ptk_entry_bank_1 on ptk_entry (bank_id);
alter table send_item add constraint fk_send_item_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;
create index ix_send_item_bank_1 on send_item (bank_id);

UPDATE applicationinfo SET prop_value='19' WHERE prop_name='db_layout';
