create table ds_order_hac_entry (
  id                        number(10) not null,
  ds_order_details_id       number(10) not null,
  hac_time                  timestamp not null,
  axn                       number(10),
  customer_id               varchar2(35),
  user_id                   varchar2(35),
  reason                    varchar2(4),
  constraint pk_ds_order_hac_entry primary key (id))
;

create table ds_order_ptk_entry (
  id                        number(10) not null,
  ds_order_details_id       number(10) not null,
  ptk_time                  timestamp not null,
  axn                       number(10),
  result                    number(10),
  data                      blob,
  constraint pk_ds_order_ptk_entry primary key (id))
;

ALTER TABLE ds_order_details ADD user_id VARCHAR2(35);
ALTER TABLE ds_order_details ADD tp NUMBER(10,0);
ALTER TABLE ds_order_details DROP COLUMN ptk_file;
ALTER TABLE ds_order_details DROP COLUMN hac_file;

ALTER TABLE ds_order_details ADD CONSTRAINT ck_ds_order_details_tp check (tp in (0,1));
ALTER TABLE ds_order_ptk_entry ADD CONSTRAINT ds_order_ptk_entry_fk1 FOREIGN KEY (ds_order_details_id) REFERENCES ds_order_details (id);
ALTER TABLE ds_order_hac_entry ADD CONSTRAINT ds_order_hac_entry_fk1 FOREIGN KEY (ds_order_details_id) REFERENCES ds_order_details (id);

CREATE SEQUENCE ds_order_hac_entry_seq;
CREATE SEQUENCE ds_order_ptk_entry_seq;

UPDATE applicationinfo SET prop_value='13' WHERE prop_name='db_layout';
