drop table ds_signing_info;
drop table ds_order_details;

create table ds_order_details (
  id                        number(10) not null,
  bank_id                   number(10),
  file_type                 varchar2(50) not null,
  order_id                  varchar2(4) not null,
  filename                  varchar2(256),
  submission_date           timestamp not null,
  customer_id               varchar2(35) not null,
  user_name                 varchar2(40),
  num_sig_done              number(10),
  num_sig_required          number(10),
  amount                    number(38),
  amount_currency           varchar2(3),
  datasize                  number(19),
  ptk_file                  varchar2(256),
  hac_file                  varchar2(256),
  ticket                    blob,
  state                     number(10),
  constraint ck_ds_order_details_state check (state in (0,1,2,3,4,5)),
  constraint pk_ds_order_details primary key (id))
;

create table ds_signing_info (
  id                        number(10) not null,
  ds_order_details_id       number(10) not null,
  customer_id               varchar2(35) not null,
  user_id                   varchar2(35) not null,
  user_name                 varchar2(40),
  sign_date                 timestamp not null,
  permission                varchar2(1) not null,
  constraint pk_ds_signing_info primary key (id))
;

alter table ds_order_details add constraint fk_ds_order_details_bank_1 foreign key (bank_id) references bank (id);
create index ix_ds_order_details_bank_1 on ds_order_details (bank_id);
alter table ds_signing_info add constraint fk_ds_signing_info_ds_order__1 foreign key (ds_order_details_id) references ds_order_details (id);
create index ix_ds_signing_info_ds_order__1 on ds_signing_info (ds_order_details_id);

UPDATE applicationinfo SET prop_value='10' WHERE prop_name='db_layout';
