drop table ds_signing_info;
drop table ds_order_details;

create table ds_order_details (
  id                        integer identity(1,1) not null,
  bank_id                   integer,
  file_type                 varchar(50) not null,
  order_id                  varchar(4) not null,
  filename                  varchar(256),
  submission_date           datetime not null,
  customer_id               varchar(35) not null,
  user_name                 varchar(40),
  num_sig_done              integer,
  num_sig_required          integer,
  amount                    numeric(28),
  amount_currency           varchar(3),
  datasize                  numeric(19),
  ptk_file                  varchar(256),
  hac_file                  varchar(256),
  ticket                    image,
  state                     integer,
  constraint ck_ds_order_details_state check (state in (0,1,2,3,4,5)),
  constraint pk_ds_order_details primary key (id))
;

create table ds_signing_info (
  id                        integer identity(1,1) not null,
  ds_order_details_id       integer not null,
  customer_id               varchar(35) not null,
  user_id                   varchar(35) not null,
  user_name                 varchar(40),
  sign_date                 datetime not null,
  permission                varchar(1) not null,
  constraint pk_ds_signing_info primary key (id))
;

alter table ds_order_details add constraint fk_ds_order_details_bank_1 foreign key (bank_id) references bank (id);
create index ix_ds_order_details_bank_1 on ds_order_details (bank_id);
alter table ds_signing_info add constraint fk_ds_signing_info_ds_order_de_1 foreign key (ds_order_details_id) references ds_order_details (id);
create index ix_ds_signing_info_ds_order_de_1 on ds_signing_info (ds_order_details_id);

UPDATE applicationinfo SET prop_value='10' WHERE prop_name='db_layout';
