ALTER session SET nls_length_semantics=CHAR;
-- apply changes
create table account (
  id                            number(10) not null,
  bank_id                       number(10) not null,
  name                          varchar2(50) not null,
  description                   varchar2(256),
  account_holder                varchar2(256),
  account_holder_htd            varchar2(256),
  info_text                     clob,
  sepa_originator_id            number(10),
  dtazv_originator_id           number(10),
  mt101_originator_id           number(10),
  de_bank_code                  varchar2(8),
  de_account_number             varchar2(10),
  fr_bank_code                  varchar2(5),
  fr_branch_code                varchar2(5),
  fr_account_number             varchar2(11),
  fr_check_code                 varchar2(2),
  iban                          varchar2(34),
  bic                           varchar2(11),
  national_bank_code            varchar2(30),
  national_account_number       varchar2(40),
  currency                      varchar2(3),
  cm_identification             varchar2(256),
  credit_limit                  number(38,3),
  ip_limit                      number(38,3),
  ip_limit_type                 number(10),
  ip_limit_state                number(10),
  ip_limit_time                 timestamp,
  ip_limit_msg_id               varchar2(35),
  investment_amount             number(38,3),
  type                          number(10),
  folder_id                     number(10),
  use_virtual_balances          number(1),
  virtual_start_balance         number(38,3),
  virtual_start_date            date,
  ignore_account_information    number(1),
  constraint ck_account_ip_limit_type check ( ip_limit_type in (0,1,2)),
  constraint ck_account_ip_limit_state check ( ip_limit_state in (0,1,2)),
  constraint ck_account_type check ( type in (0,1,2)),
  constraint pk_account primary key (id)
);
create sequence account_seq increment by 1;

create table account_permission (
  id                            number(10) not null,
  bank_user_id                  number(10) not null,
  account_id                    number(10) not null,
  constraint uq_account_permission_1 unique (bank_user_id,account_id),
  constraint pk_account_permission primary key (id)
);
create sequence account_permission_seq increment by 1;

create table ap_overwrite (
  id                            number(10) not null,
  bank_user_id                  number(10) not null,
  account_id                    number(10) not null,
  previous_enabled              number(1) default 1 not null,
  amount_limit                  number(16,3),
  constraint uq_ap_overwrite_1 unique (bank_user_id,account_id),
  constraint pk_ap_overwrite primary key (id)
);
create sequence ap_overwrite_seq increment by 1;

create table applicationinfo (
  prop_name                     varchar2(50) not null,
  prop_value                    varchar2(500),
  constraint pk_applicationinfo primary key (prop_name)
);

create table automatic_export (
  id                            number(10) not null,
  name                          varchar2(255),
  conversion_id                 number(10),
  convert_to_pdf                number(1),
  directory                     varchar2(255),
  pattern                       varchar2(255),
  activated                     number(1),
  type                          number(10) not null,
  tenant_id                     number(10) not null,
  constraint ck_automatic_export_type check ( type in (0,1,2)),
  constraint pk_automatic_export primary key (id)
);
create sequence automatic_export_seq increment by 1;

create table automatic_export_account (
  automatic_export_id           number(10) not null,
  account_id                    number(10) not null,
  constraint pk_automatic_export_account primary key (automatic_export_id,account_id)
);

create table automatic_export_folder (
  automatic_export_id           number(10) not null,
  cm_folder_id                  number(10) not null,
  constraint pk_automatic_export_folder primary key (automatic_export_id,cm_folder_id)
);

create table awv_dika (
  id                            number(10) not null,
  abstract_entry_id             number(10) not null,
  purpose                       varchar2(140),
  amount                        number(19),
  country                       varchar2(2),
  ref_amount                    varchar2(30),
  stlmnt_key                    varchar2(1),
  constraint pk_awv_dika primary key (id)
);
create sequence awv_dika_seq increment by 1;

create table awv_dirinv (
  id                            number(10) not null,
  abstract_entry_id             number(10) not null,
  isin                          varchar2(12),
  label                         varchar2(35),
  st_number                     number(10),
  amount                        number(19),
  country                       varchar2(2),
  ref_amount                    varchar2(30),
  stlmnt_key                    varchar2(1),
  constraint pk_awv_dirinv primary key (id)
);
create sequence awv_dirinv_seq increment by 1;

create table awv_entry (
  id                            number(10) not null,
  type                          number(10) not null,
  month                         varchar2(6) not null,
  reporter                      number(10),
  category                      number(10),
  svc_code                      varchar2(3),
  reference                     varchar2(35),
  cancel                        number(1) not null,
  cmnt                          varchar2(80),
  exported                      number(1) not null,
  end_to_end_id                 varchar2(50),
  tenant_id                     number(10) not null,
  origin                        number(10) not null,
  signed_payment_id             number(10),
  cm_booking_id                 number(10),
  constraint ck_awv_entry_type check ( type in (0,1,2)),
  constraint ck_awv_entry_origin check ( origin in (0,1,2,3)),
  constraint pk_awv_entry primary key (id)
);
create sequence awv_entry_seq increment by 1;

create table awv_export (
  id                            number(10) not null,
  month                         varchar2(6) not null,
  export_time                   timestamp,
  export_user                   varchar2(256),
  export_file                   varchar2(1024),
  tenant_id                     number(10) not null,
  constraint uq_awv_export_month unique (month),
  constraint pk_awv_export primary key (id)
);
create sequence awv_export_seq increment by 1;

create table awv_company (
  id                            number(10) not null,
  institute                     varchar2(9) not null,
  name                          varchar2(80) not null,
  street                        varchar2(80),
  pob                           varchar2(80),
  zip                           varchar2(20),
  town                          varchar2(80),
  country                       varchar2(2),
  tenant_id                     number(10) not null,
  constraint pk_awv_company primary key (id)
);
create sequence awv_company_seq increment by 1;

create table awv_contact (
  id                            number(10) not null,
  company                       number(10) not null,
  title                         varchar2(80),
  firstname                     varchar2(80),
  surname                       varchar2(80) not null,
  dept                          varchar2(80),
  phone                         varchar2(80) not null,
  fax                           varchar2(80),
  email                         varchar2(255),
  extranet                      varchar2(8),
  constraint pk_awv_contact primary key (id)
);
create sequence awv_contact_seq increment by 1;

create table awv_transit (
  id                            number(10) not null,
  abstract_entry_id             number(10) not null,
  warecode                      varchar2(2),
  warename                      varchar2(140),
  amount                        number(19),
  country                       varchar2(2),
  ref_amount                    varchar2(30),
  stlmnt_key                    varchar2(1),
  constraint pk_awv_transit primary key (id)
);
create sequence awv_transit_seq increment by 1;

create table bank (
  id                            number(10) not null,
  display_name                  varchar2(64) not null,
  icon                          varchar2(128),
  country                       varchar2(2),
  url                           varchar2(256) not null,
  prot_version                  varchar2(4) not null,
  host_id                       varchar2(35) not null,
  customer_id                   varchar2(35) not null,
  hpd_time                      timestamp,
  hpd                           blob,
  e001key_id                    number(10),
  e002key_id                    number(10),
  x001key_id                    number(10),
  x002key_id                    number(10),
  expected_digest_e001          varchar2(40),
  expected_digest_x001          varchar2(40),
  expected_digest_e002          varchar2(64),
  expected_digest_x002          varchar2(64),
  dtazv_number                  number(10),
  transfer_system               number(1),
  transport_only                number(1),
  use_hca_pub                   number(1),
  wss_fetch_type                varchar2(255),
  vop_activated                 number(1) default 0 not null,
  vop_mandatory                 number(1) default 0 not null,
  tenant_id                     number(10) not null,
  constraint pk_bank primary key (id)
);
create sequence bank_seq increment by 1;

create table bankuser (
  id                            number(10) not null,
  bank_id                       number(10) not null,
  user_id                       number(10) not null,
  default_user                  varchar2(35),
  order_number                  varchar2(4),
  with_certs                    number(1) default 0 not null,
  state                         number(10) not null,
  deactivated                   number(1) default 0 not null,
  wss_activated                 number(1) default 0 not null,
  signature_version             varchar2(4),
  sig_key_length                number(10),
  auth_key_length               number(10),
  encr_key_length               number(10),
  dtaus_reference_number        number(10),
  bundesbank_file_number        number(10),
  sepa_message_id               number(10),
  mt101_sender_reference        number(10),
  encr_key                      blob,
  encr_cert                     blob,
  auth_key                      blob,
  auth_cert                     blob,
  sig_key                       blob,
  sig_cert                      blob,
  lock_user_signature           blob,
  ini_letter                    blob,
  constraint ck_bankuser_state check ( state in (0,1,2,3,4,5)),
  constraint uq_bankuser_1 unique (bank_id,user_id),
  constraint pk_bankuser primary key (id)
);
create sequence bankuser_seq increment by 1;

create table bank_user_htd_info (
  id                            number(10) not null,
  bank_user_id                  number(10),
  ebics_host_id                 varchar2(35),
  name                          varchar2(256),
  street                        varchar2(256),
  post_code                     varchar2(20),
  city                          varchar2(256),
  region                        varchar2(256),
  country                       varchar2(256),
  user_id                       varchar2(35),
  user_status                   number(10),
  user_name                     varchar2(256),
  htd_time                      timestamp,
  constraint uq_bank_user_htd_info_bank_use unique (bank_user_id),
  constraint pk_bank_user_htd_info primary key (id)
);
create sequence bank_user_htd_info_seq increment by 1;

create table cluster_node (
  id                            number(10) not null,
  base_url                      varchar2(255),
  secret                        varchar2(20),
  primary_node                  number(1) default 0 not null,
  constraint uq_cluster_node_base_url unique (base_url),
  constraint pk_cluster_node primary key (id)
);
create sequence cluster_node_seq increment by 1;

create table cm_balance (
  id                            number(10) not null,
  account_id                    number(10),
  value_date                    date,
  value_balance                 number(38,3),
  value_balance_with_advice     number(38,3),
  constraint pk_cm_balance primary key (id)
);
create sequence cm_balance_seq increment by 1;

create table cm_balance2 (
  id                            number(10) not null,
  account_id                    number(10),
  value_date                    date,
  value_balance                 number(38,3),
  value_balance_with_advice     number(38,3),
  constraint pk_cm_balance2 primary key (id)
);
create sequence cm_balance2_seq increment by 1;

create table cm_bank (
  id                            number(10) not null,
  bank_id                       number(10),
  statements_activated          number(1) default 0 not null,
  advice_activated              number(1) default 0 not null,
  credit_advice_activated       number(1) default 0 not null,
  bka_activated                 number(1) default 0 not null,
  bki_activated                 number(1) default 0 not null,
  c54_activated                 number(1) default 0 not null,
  cumulative_advice_provision   number(1) default 0 not null,
  multidays_advice_repeated     number(1) default 0 not null,
  statement_format              varchar2(255),
  advice_format                 varchar2(255),
  statement_fetch_type          varchar2(255),
  advice_fetch_type             varchar2(255),
  credit_advice_fetch_type      varchar2(255),
  bka_fetch_type                varchar2(255),
  bki_fetch_type                varchar2(255),
  c54_fetch_type                varchar2(255),
  last_sta_fetch                date,
  last_vmk_fetch                date,
  last_credit_advice_fetch      date,
  last_bka_fetch                date,
  last_bki_fetch                date,
  last_c54_fetch                date,
  sta_fetch_mode                number(10),
  vmk_fetch_mode                number(10),
  cav_fetch_mode                number(10),
  bka_fetch_mode                number(10),
  bki_fetch_mode                number(10),
  c54_fetch_mode                number(10),
  vb_calculation_with_cav       number(1) default 0 not null,
  vb_calculation_with_pav       number(1) default 0 not null,
  constraint ck_cm_bank_sta_fetch_mode check ( sta_fetch_mode in (0,1)),
  constraint ck_cm_bank_vmk_fetch_mode check ( vmk_fetch_mode in (0,1)),
  constraint ck_cm_bank_cav_fetch_mode check ( cav_fetch_mode in (0,1)),
  constraint ck_cm_bank_bka_fetch_mode check ( bka_fetch_mode in (0,1)),
  constraint ck_cm_bank_bki_fetch_mode check ( bki_fetch_mode in (0,1)),
  constraint ck_cm_bank_c54_fetch_mode check ( c54_fetch_mode in (0,1)),
  constraint uq_cm_bank_bank_id unique (bank_id),
  constraint pk_cm_bank primary key (id)
);
create sequence cm_bank_seq increment by 1;

create table cm_booking (
  id                            number(10) not null,
  statement_id                  number(10) not null,
  page_id                       number(10),
  account_id                    number(10) not null,
  parent_booking_id             number(10),
  pos                           number(10),
  booking_date                  date,
  value_date                    date,
  local_party                   varchar2(140),
  local_party_bank_code         varchar2(30),
  local_party_account_number    varchar2(40),
  local_party_creditor_id       varchar2(35),
  local_party_mandate_reference varchar2(35),
  ultimate_local_party          varchar2(140),
  counter_party                 varchar2(140),
  counter_party_bank_code       varchar2(30),
  counter_party_account_number  varchar2(40),
  counter_party_creditor_id     varchar2(35),
  counter_party_mandate_ref     varchar2(35),
  ultimate_counter_party        varchar2(140),
  purpose                       varchar2(400),
  purpose_code                  varchar2(35),
  purpose_overview              varchar2(140),
  sts                           varchar2(4),
  amount                        number(38,3),
  currency_code                 varchar2(3),
  original_amount               number(38,3),
  original_currency             varchar2(3),
  settlement_amount             number(38,3),
  settlement_currency           varchar2(3),
  charges_amount                number(38,3),
  charges_currency              varchar2(3),
  fee_type                      varchar2(3),
  converted_amount              number(38,3),
  converted_currency            varchar2(3),
  exchange_rate                 number(38,3),
  exchange_rate_date            date,
  booking_key                   varchar2(3),
  booking_text                  varchar2(27),
  gvc                           varchar2(3),
  primanota                     varchar2(10),
  text_key_appendix             varchar2(3),
  additional_information        varchar2(500),
  bank_reference                varchar2(35),
  customer_reference            varchar2(35),
  customer_reference_date       date,
  end_to_end_id                 varchar2(35),
  instr_id                      varchar2(35),
  pmt_inf_id                    varchar2(35),
  msg_id                        varchar2(35),
  transaction_code              varchar2(4),
  domain_code                   varchar2(4),
  family_code                   varchar2(4),
  sub_family_code               varchar2(4),
  interbank_transaction_code    varchar2(2),
  rejection_cause_code          varchar2(4),
  entry_number                  varchar2(7),
  exemption                     number(1),
  unavailabilty_rating          number(1),
  balance                       number(38,3),
  collective                    number(1),
  debit                         number(1),
  reversal                      number(1),
  signed_payments               number(1),
  transaction_id                varchar2(35),
  ntry_ref                      varchar2(35),
  count_transactions            number(10),
  constraint pk_cm_booking primary key (id)
);
create sequence cm_booking_seq increment by 1;

create table cm_b_filter (
  id                            number(10) not null,
  user_id                       number(10) not null,
  filter_active                 number(1),
  booking_date_from             date,
  booking_date_to               date,
  bd_comp                       number(10),
  value_date_from               date,
  value_date_to                 date,
  vd_comp                       number(10),
  text                          varchar2(255),
  text_comp                     number(10),
  amount_from                   number(38,3),
  amount_to                     number(38,3),
  amount_comp                   number(10),
  booking_dir                   number(10) not null,
  booking_type                  number(10),
  booking_type_text             varchar2(3),
  constraint ck_cm_b_filter_bd_comp check ( bd_comp in (0,1,2,3)),
  constraint ck_cm_b_filter_vd_comp check ( vd_comp in (0,1,2,3)),
  constraint ck_cm_b_filter_text_comp check ( text_comp in (0,1,2,3)),
  constraint ck_cm_b_filter_amount_comp check ( amount_comp in (0,1,2,3)),
  constraint ck_cm_b_filter_booking_dir check ( booking_dir in (0,1,2)),
  constraint ck_cm_b_filter_booking_type check ( booking_type in (0,1,2,3,4,5,6)),
  constraint uq_cm_b_filter_user_id unique (user_id),
  constraint pk_cm_b_filter primary key (id)
);
create sequence cm_b_filter_seq increment by 1;

create table cm_charge (
  id                            number(10) not null,
  booking_id                    number(10) not null,
  statement_id                  number(10),
  page_id                       number(10),
  amount                        number(38,3),
  currency_code                 varchar2(3),
  is_included                   number(1) default 0 not null,
  bank_identification           varchar2(140),
  type                          varchar2(35),
  rate                          number(11,10),
  charge_bearer_type            varchar2(4),
  tax_identification            varchar2(35),
  tax_amount                    number(38,3),
  tax_currency_code             varchar2(3),
  tax_rate                      number(11,10),
  constraint pk_cm_charge primary key (id)
);
create sequence cm_charge_seq increment by 1;

create table cm_check (
  id                            number(10) not null,
  login_id                      number(10),
  statement_id                  number(10),
  page_id                       number(10),
  checked                       number(1),
  constraint pk_cm_check primary key (id)
);
create sequence cm_check_seq increment by 1;

create table cm_folder (
  id                            number(10) not null,
  name                          varchar2(255),
  tenant_id                     number(10) not null,
  constraint uq_cm_folder_1 unique (name,tenant_id),
  constraint pk_cm_folder primary key (id)
);
create sequence cm_folder_seq increment by 1;

create table cm_page (
  id                            number(10) not null,
  statement_id                  number(10),
  creation_date                 timestamp,
  reference1                    varchar2(255),
  reference2                    varchar2(255),
  closing_date                  date,
  closing_balance               number(38,3),
  closing_final                 number(1) default 0 not null,
  opening_date                  date,
  opening_balance               number(38,3),
  opening_final                 number(1) default 0 not null,
  currency_code                 varchar2(3),
  page_number                   number(10),
  count_credit                  number(10),
  count_debit                   number(10),
  sum_credit                    number(38,3),
  sum_debit                     number(38,3),
  max_credit                    number(38,3),
  min_credit                    number(38,3),
  max_debit                     number(38,3),
  min_debit                     number(38,3),
  old                           number(1) default 0 not null,
  file_id                       number(10),
  constraint pk_cm_page primary key (id)
);
create sequence cm_page_seq increment by 1;

create table cm_pdf_statement (
  id                            number(10) not null,
  type                          number(10) not null,
  bank_id                       number(10),
  account_id                    number(10),
  statement_date                date,
  statement_number              number(10),
  zip_file_name                 varchar2(255),
  local_file_id                 number(10),
  constraint ck_cm_pdf_statement_type check ( type in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16)),
  constraint pk_cm_pdf_statement primary key (id)
);
create sequence cm_pdf_statement_seq increment by 1;

create table cm_statement (
  id                            number(10) not null,
  account_id                    number(10),
  creation_date                 timestamp,
  reference1                    varchar2(255),
  reference2                    varchar2(255),
  opening_date                  date,
  opening_balance               number(38,3),
  opening_final                 number(1) default 0 not null,
  closing_date                  date,
  closing_balance               number(38,3),
  closing_final                 number(1) default 0 not null,
  currency_code                 varchar2(3),
  statement_number              number(10),
  page_number                   number(10),
  legal_number                  number(10),
  unique_id                     varchar2(255),
  count_credit                  number(10),
  count_debit                   number(10),
  sum_credit                    number(38,3),
  sum_debit                     number(38,3),
  max_credit                    number(38,3),
  min_credit                    number(38,3),
  max_debit                     number(38,3),
  min_debit                     number(38,3),
  type                          number(10) not null,
  original_filename             varchar2(255),
  additional_information        varchar2(500),
  file_id                       number(10),
  constraint ck_cm_statement_type check ( type in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30)),
  constraint uq_cm_statement_1 unique (account_id,unique_id),
  constraint pk_cm_statement primary key (id)
);
create sequence cm_statement_seq increment by 1;

create table cm_value_group (
  id                            number(10) not null,
  name                          varchar2(255),
  tenant_id                     number(10) not null,
  constraint pk_cm_value_group primary key (id)
);
create sequence cm_value_group_seq increment by 1;

create table cm_value_group_account (
  cm_value_group_id             number(10) not null,
  account_id                    number(10) not null,
  constraint pk_cm_value_group_account primary key (cm_value_group_id,account_id)
);

create table cm_value_group_folder (
  cm_value_group_id             number(10) not null,
  cm_folder_id                  number(10) not null,
  constraint pk_cm_value_group_folder primary key (cm_value_group_id,cm_folder_id)
);

create table conversion (
  id                            number(10) not null,
  name                          varchar2(255),
  type                          number(10),
  include_header                number(1) default 0 not null,
  field_separator               varchar2(255),
  text_separator                varchar2(255),
  date_format                   varchar2(255),
  number_format                 varchar2(255),
  fields                        varchar2(500),
  tenant_id                     number(10) not null,
  constraint ck_conversion_type check ( type in (0,1,2,3)),
  constraint pk_conversion primary key (id)
);
create sequence conversion_seq increment by 1;

create table sepa_converter_format (
  id                            number(10) not null,
  tpe                           number(10),
  encoding                      varchar2(25),
  field_separator               varchar2(5),
  has_header                    number(1),
  country_code                  varchar2(2),
  format                        clob,
  tenant_id                     number(10) not null,
  constraint ck_sepa_converter_format_tpe check ( tpe in (0,1,2,3,4)),
  constraint pk_sepa_converter_format primary key (id)
);
create sequence sepa_converter_format_seq increment by 1;

create table directory_scanner (
  id                            number(10) not null,
  directory                     varchar2(255) not null,
  bank_id                       number(10),
  reg_ex                        varchar2(255),
  archive_directory             varchar2(255),
  error_directory               varchar2(255),
  order_or_file_type            varchar2(255),
  signature                     number(1),
  constraint pk_directory_scanner primary key (id)
);
create sequence directory_scanner_seq increment by 1;

create table ds_bank (
  id                            number(10) not null,
  bank_id                       number(10),
  activated                     number(1) default 0 not null,
  hvz                           number(1) default 0 not null,
  constraint uq_ds_bank_bank_id unique (bank_id),
  constraint pk_ds_bank primary key (id)
);
create sequence ds_bank_seq increment by 1;

create table ds_open_order (
  id                            number(10) not null,
  bank_user_id                  number(10),
  file_type                     varchar2(50) not null,
  pmt_type                      number(10),
  order_id                      varchar2(4) not null,
  submission_date               timestamp not null,
  customer_id                   varchar2(35) not null,
  user_id                       varchar2(35),
  user_name                     varchar2(80),
  amount                        number(38,3),
  amount_currency               varchar2(3),
  datasize                      number(19),
  originator                    varchar2(140),
  digest_hex                    varchar2(80),
  is_signable                   number(1) default 0 not null,
  is_order_data_available       number(1) default 0 not null,
  is_payment_data_available     number(1) default 0 not null,
  num_sig_done                  number(10) not null,
  num_sig_required              number(10) not null,
  ticket                        blob,
  order_data_id                 number(10),
  payment_data_id               number(10),
  additional_order_info         varchar2(255),
  constraint ck_ds_open_order_pmt_type check ( pmt_type in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49)),
  constraint pk_ds_open_order primary key (id)
);
create sequence ds_open_order_seq increment by 1;

create table ds_open_order_signer (
  id                            number(10) not null,
  ds_open_order_id              number(10),
  sign_date                     timestamp not null,
  customer_id                   varchar2(35) not null,
  user_id                       varchar2(35),
  user_name                     varchar2(80),
  permission                    varchar2(1) not null,
  constraint pk_ds_open_order_signer primary key (id)
);
create sequence ds_open_order_signer_seq increment by 1;

create table ds_order_details (
  id                            number(10) not null,
  bank_id                       number(10),
  pmt_type                      number(10),
  file_type                     varchar2(50) not null,
  order_id                      varchar2(4) not null,
  filename                      varchar2(256),
  submission_date               timestamp not null,
  customer_id                   varchar2(35) not null,
  user_id                       varchar2(35),
  user_name                     varchar2(40),
  num_sig_done                  number(10),
  num_sig_required              number(10),
  amount                        number(38,3),
  amount_currency               varchar2(3),
  datasize                      number(19),
  ticket                        blob,
  data_file_id                  number(10),
  state                         number(10),
  error_code                    varchar2(4),
  additional_order_info         varchar2(255),
  tp                            number(10),
  constraint ck_ds_order_details_pmt_type check ( pmt_type in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49)),
  constraint ck_ds_order_details_state check ( state in (0,1,2,3,4,5)),
  constraint ck_ds_order_details_tp check ( tp in (0,1)),
  constraint pk_ds_order_details primary key (id)
);
create sequence ds_order_details_seq increment by 1;

create table ds_order_details_account (
  ds_order_details_id           number(10) not null,
  account_id                    number(10) not null,
  constraint pk_ds_order_details_account primary key (ds_order_details_id,account_id)
);

create table ds_signing_info (
  id                            number(10) not null,
  ds_order_details_id           number(10) not null,
  customer_id                   varchar2(35) not null,
  user_id                       varchar2(35) not null,
  user_name                     varchar2(256),
  sign_date                     timestamp not null,
  ip_address                    varchar2(255),
  permission                    varchar2(1) not null,
  constraint pk_ds_signing_info primary key (id)
);
create sequence ds_signing_info_seq increment by 1;

create table export_file (
  id                            number(10) not null,
  workspace_file_id             number(10),
  last_update                   timestamp,
  constraint pk_export_file primary key (id)
);
create sequence export_file_seq increment by 1;

create table export_file_account (
  export_file_id                number(10) not null,
  account_id                    number(10) not null,
  constraint pk_export_file_account primary key (export_file_id,account_id)
);

create table export_file_aut_export (
  export_file_id                number(10) not null,
  automatic_export_id           number(10) not null,
  constraint pk_export_file_aut_export primary key (export_file_id,automatic_export_id)
);

create table exportfile_filter (
  id                            number(10) not null,
  user_id                       number(10) not null,
  from_date                     date,
  to_date                       date,
  date_comp                     number(10),
  export_file_active            number(1) default 0 not null,
  automatic_export_id           number(10),
  file_name                     varchar2(255),
  file_name_comp                number(10) not null,
  constraint ck_exportfile_filter_date_comp check ( date_comp in (0,1,2,3)),
  constraint ck_exprtfl_fltr_fl_nm_cmp check ( file_name_comp in (0,1,2,3)),
  constraint pk_exportfile_filter primary key (id)
);
create sequence exportfile_filter_seq increment by 1;

create table fetch_item (
  id                            number(10) not null,
  bank_id                       number(10),
  fetched                       timestamp not null,
  file_id                       number(10),
  file_type                     varchar2(255),
  order_type                    varchar2(3) not null,
  error                         clob,
  from_date                     date,
  to_date                       date,
  fetcher                       varchar2(255),
  constraint pk_fetch_item primary key (id)
);
create sequence fetch_item_seq increment by 1;

create table fe_filter (
  id                            number(10) not null,
  user_id                       number(10) not null,
  from_date                     date,
  to_date                       date,
  date_comp                     number(10),
  order_type                    varchar2(255),
  order_type_comp               number(10) not null,
  bank_id                       number(10),
  bank_comp                     number(10) not null,
  fetch_active                  number(1) default 0 not null,
  fetcher                       varchar2(255),
  fetcher_comp                  number(10),
  constraint ck_fe_filter_date_comp check ( date_comp in (0,1,2,3)),
  constraint ck_fe_filter_order_type_comp check ( order_type_comp in (0,1,2,3)),
  constraint ck_fe_filter_bank_comp check ( bank_comp in (0)),
  constraint ck_fe_filter_fetcher_comp check ( fetcher_comp in (0,1,2,3)),
  constraint pk_fe_filter primary key (id)
);
create sequence fe_filter_seq increment by 1;

create table hac_entry (
  id                            number(10) not null,
  bank_id                       number(10),
  hac_time                      timestamp not null,
  axn                           number(10),
  customer_id                   varchar2(35),
  user_id                       varchar2(35),
  reason                        varchar2(4),
  order_number                  varchar2(4),
  order_type                    varchar2(3),
  file_type                     varchar2(255),
  additional_information        clob,
  constraint pk_hac_entry primary key (id)
);
create sequence hac_entry_seq increment by 1;

create table hac_filter (
  id                            number(10) not null,
  user_id                       number(10) not null,
  from_date                     date,
  to_date                       date,
  date_comp                     number(10),
  order_type                    varchar2(255),
  order_type_comp               number(10) not null,
  order_nr                      varchar2(255),
  order_nr_comp                 number(10) not null,
  axn                           number(10),
  customer_id                   varchar2(35),
  bank_user_id                  varchar2(35),
  reason                        varchar2(4),
  constraint ck_hac_filter_date_comp check ( date_comp in (0,1,2,3)),
  constraint ck_hac_filter_order_type_comp check ( order_type_comp in (0,1,2,3)),
  constraint ck_hac_filter_order_nr_comp check ( order_nr_comp in (0,1,2,3)),
  constraint pk_hac_filter primary key (id)
);
create sequence hac_filter_seq increment by 1;

create table license (
  id                            varchar2(11) not null,
  content                       blob,
  constraint pk_license primary key (id)
);

create table log (
  id                            number(10) not null,
  log_time                      timestamp,
  tenant_id                     number(10),
  account_id                    number(10),
  actor_id                      number(10) not null,
  message_name                  varchar2(255),
  message_en                    varchar2(500),
  message_de                    varchar2(500),
  pmt_type                      number(10),
  parameter                     blob,
  constraint ck_log_pmt_type check ( pmt_type in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49)),
  constraint pk_log primary key (id)
);
create sequence log_seq increment by 1;

create table log_filter (
  id                            number(10) not null,
  user_id                       number(10) not null,
  active                        number(1),
  type                          varchar2(255),
  account_id                    number(10),
  filter_user_id                number(10),
  from_date                     date,
  to_date                       date,
  date_comp                     number(10),
  constraint ck_log_filter_date_comp check ( date_comp in (0,1,2,3)),
  constraint uq_log_filter_user_id unique (user_id),
  constraint pk_log_filter primary key (id)
);
create sequence log_filter_seq increment by 1;

create table login_session (
  id                            number(10) not null,
  user_id                       number(10) not null,
  active                        number(1) default 0 not null,
  session_activity              timestamp not null,
  constraint pk_login_session primary key (id)
);
create sequence login_session_seq increment by 1;

create table notification (
  id                            number(10) not null,
  bank_id                       number(10),
  fetched                       timestamp not null,
  type                          number(10) not null,
  file_id                       number(10),
  file_type                     varchar2(255),
  order_type                    varchar2(3),
  send_id                       number(10),
  order_info                    varchar2(255),
  orgnl_msg_id                  varchar2(35),
  orgnl_msg_nm_id               varchar2(255),
  orgnl_nb_of_txs               number(10),
  orgnl_ctrl_sum                number(38,3),
  grp_sts                       varchar2(4),
  nb_of_rjct                    number(10),
  constraint ck_notification_type check ( type in (0,1,2,3,4,5,6,7,8,9,10,11,12,13)),
  constraint pk_notification primary key (id)
);
create sequence notification_seq increment by 1;

create table nf_filter (
  id                            number(10) not null,
  user_id                       number(10) not null,
  from_date                     date,
  to_date                       date,
  date_comp                     number(10),
  order_type                    varchar2(255),
  order_type_comp               number(10) not null,
  bank_id                       number(10),
  bank_comp                     number(10) not null,
  notification_active           number(1) default 0 not null,
  constraint ck_nf_filter_date_comp check ( date_comp in (0,1,2,3)),
  constraint ck_nf_filter_order_type_comp check ( order_type_comp in (0,1,2,3)),
  constraint ck_nf_filter_bank_comp check ( bank_comp in (0)),
  constraint pk_nf_filter primary key (id)
);
create sequence nf_filter_seq increment by 1;

create table notification_pmt_inf (
  id                            number(10) not null,
  notification_id               number(10),
  orgnl_pmt_inf_id              varchar2(35),
  orgnl_nb_of_txs               number(10),
  orgnl_ctrl_sum                number(38,3),
  pmt_inf_sts                   varchar2(4),
  constraint pk_notification_pmt_inf primary key (id)
);
create sequence notification_pmt_inf_seq increment by 1;

create table nf_setting (
  id                            number(10) not null,
  bank_id                       number(10),
  active                        number(1) default 0 not null,
  credit_notifications          number(1) default 0 not null,
  debit_notifications           number(1) default 0 not null,
  instant_notifications         number(1) default 0 not null,
  foreign_notifications         number(1) default 0 not null,
  vop_notifications             number(1) default 0 not null,
  callback_notifications        number(1) default 0 not null,
  bundesbank                    number(1) default 0 not null,
  credit_fetch_type             varchar2(255),
  debit_fetch_type              varchar2(255),
  instant_fetch_type            varchar2(255),
  foreign_fetch_type            varchar2(255),
  vop_fetch_type                varchar2(255),
  callback_fetch_type           varchar2(255),
  fetch_mode                    number(10),
  last_fetch                    date,
  constraint ck_nf_setting_fetch_mode check ( fetch_mode in (0,1)),
  constraint uq_nf_setting_bank_id unique (bank_id),
  constraint pk_nf_setting primary key (id)
);
create sequence nf_setting_seq increment by 1;

create table notification_trx (
  id                            number(10) not null,
  notification_id               number(10),
  pmt_inf_id                    number(10),
  send_id                       number(10),
  signed_payment_id             number(10),
  orgnl_instr_id                varchar2(255),
  orgnl_end_to_end_id           varchar2(255),
  tx_sts                        varchar2(4),
  originator                    varchar2(70),
  originator_account_number     varchar2(40),
  originator_bank_code          varchar2(34),
  recipient                     varchar2(70),
  recipient_account_number      varchar2(40),
  recipient_bank_code           varchar2(34),
  amount                        number(38,3),
  amount_currency               varchar2(3),
  purpose                       varchar2(140),
  execution_date                timestamp,
  status_reason_info            clob,
  creditor_id                   varchar2(35),
  mandate_id                    varchar2(35),
  mandate_sign_date             date,
  constraint pk_notification_trx primary key (id)
);
create sequence notification_trx_seq increment by 1;

create table open_id_token (
  id                            number(10) not null,
  user_id                       number(10),
  id_token                      blob,
  access_token                  blob,
  refresh_token                 blob,
  constraint pk_open_id_token primary key (id)
);
create sequence open_id_token_seq increment by 1;

create table pmt_open (
  id                            number(10) not null,
  business_id                   number(10),
  created_user_id               number(10) not null,
  created                       timestamp not null,
  confirmed_user_id             number(10),
  confirmed                     timestamp,
  version                       number(10) not null,
  locking_user_id               number(10),
  deleted                       number(1) default 0 not null,
  bank_id                       number(10) not null,
  account_id                    number(10),
  pmt_type                      number(10),
  order_type                    varchar2(3),
  file_type                     varchar2(50),
  is_credit                     number(1),
  is_urgent                     number(1),
  originator                    varchar2(70),
  recipient                     varchar2(70),
  amount                        number(38,3),
  amount_currency               varchar2(3),
  purpose                       varchar2(140),
  execution_date                timestamp,
  payment_data                  blob,
  folder_id                     number(10),
  salary_payment                number(1),
  constraint ck_pmt_open_version check ( version in (0,1,2)),
  constraint ck_pmt_open_pmt_type check ( pmt_type in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49)),
  constraint pk_pmt_open primary key (id)
);
create sequence pmt_open_seq increment by 1;

create table order_type (
  id                            number(10) not null,
  bank_id                       number(10),
  transfer_type                 number(10) not null,
  order_type                    varchar2(3),
  file_format                   varchar2(50),
  order_format                  varchar2(8),
  num_sig_required              number(10),
  description                   varchar2(255),
  constraint ck_order_type_transfer_type check ( transfer_type in (0,1)),
  constraint pk_order_type primary key (id)
);
create sequence order_type_seq increment by 1;

create table password_history (
  id                            number(10) not null,
  user_id                       number(10) not null,
  change_date                   timestamp,
  hash_value                    varchar2(64),
  constraint pk_password_history primary key (id)
);
create sequence password_history_seq increment by 1;

create table pmt_xchgrate (
  id                            number(10) not null,
  currency_code                 varchar2(3) not null,
  exchange_rate                 number(38,10) not null,
  rate_time                     timestamp,
  constraint uq_pmt_xchgrate_currency_code unique (currency_code),
  constraint pk_pmt_xchgrate primary key (id)
);
create sequence pmt_xchgrate_seq increment by 1;

create table pmt_filter (
  id                            number(10) not null,
  user_id                       number(10) not null,
  pmt_open_active               number(1),
  pmt_signed_active             number(1),
  pmt_template_active           number(1),
  pmt_periodic_active           number(1),
  pmt_type                      number(10),
  pmt_type_comp                 number(10),
  account_id                    number(10),
  filter_user_id                number(10),
  text                          varchar2(255),
  text_comp                     number(10),
  amount_from                   number(38,3),
  amount_to                     number(38,3),
  amount_comp                   number(10),
  from_exec_date                date,
  to_exec_date                  date,
  exec_date_comp                number(10),
  state                         number(10),
  constraint ck_pmt_filter_pmt_type check ( pmt_type in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49)),
  constraint ck_pmt_filter_pmt_type_comp check ( pmt_type_comp in (0,1)),
  constraint ck_pmt_filter_text_comp check ( text_comp in (0,1,2,3)),
  constraint ck_pmt_filter_amount_comp check ( amount_comp in (0,1,2,3)),
  constraint ck_pmt_filter_exec_date_comp check ( exec_date_comp in (0,1,2,3)),
  constraint ck_pmt_filter_state check ( state in (0,1,2,3,4,5,6,7,8)),
  constraint uq_pmt_filter_user_id unique (user_id),
  constraint pk_pmt_filter primary key (id)
);
create sequence pmt_filter_seq increment by 1;

create table pmt_folder (
  id                            number(10) not null,
  name                          varchar2(255),
  tenant_id                     number(10) not null,
  constraint pk_pmt_folder primary key (id)
);
create sequence pmt_folder_seq increment by 1;

create table pmt_originator (
  id                            number(10) not null,
  name                          varchar2(255),
  tenant_id                     number(10) not null,
  default_account_id            number(10),
  payment_type                  number(10) not null,
  originator_info               clob,
  constraint ck_pmt_originator_payment_type check ( payment_type in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15)),
  constraint pk_pmt_originator primary key (id)
);
create sequence pmt_originator_seq increment by 1;

create table pmt_props (
  id                            number(10) not null,
  bank_id                       number(10) not null,
  dtazv_separat                 number(1),
  mt101_separat                 number(1),
  mt101_save_acc_currency       number(1),
  sepa_dbt_ldtime               number(10),
  sepa_cdt_ftype                varchar2(50),
  sepa_coredbt_ftype            varchar2(50),
  sepa_b2bdbt_ftype             varchar2(50),
  sepa_max_exec_date            number(10) default 15 not null,
  sepa_max_urgt_pmnts           number(10),
  cfonb160_sender               varchar2(6),
  cfonb160_allowxpf             number(1),
  cfonb320_custid               varchar2(16),
  mt101swift_header             number(1),
  constraint uq_pmt_props_bank_id unique (bank_id),
  constraint pk_pmt_props primary key (id)
);
create sequence pmt_props_seq increment by 1;

create table pmt_recipient (
  id                            number(10) not null,
  business_id                   number(10),
  created_user_id               number(10) not null,
  created                       timestamp not null,
  confirmed_user_id             number(10),
  confirmed                     timestamp,
  version                       number(10) not null,
  locking_user_id               number(10),
  deleted                       number(1) default 0 not null,
  payment_type                  number(10) not null,
  tenant_id                     number(10) not null,
  display_name                  varchar2(128),
  name                          varchar2(70),
  account_number                varchar2(40),
  bank_code                     varchar2(34),
  bank_name                     varchar2(128),
  purpose                       varchar2(400),
  reference                     varchar2(35),
  sepa_mandate_id               varchar2(35),
  recipient_info                clob,
  vop_name                      varchar2(70),
  vop_result                    varchar2(4),
  vop_reason                    varchar2(4),
  vop_additional_info           varchar2(210),
  vop_date                      timestamp,
  last_usage                    timestamp,
  constraint ck_pmt_recipient_version check ( version in (0,1,2)),
  constraint ck_pmt_recipient_payment_type check ( payment_type in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15)),
  constraint pk_pmt_recipient primary key (id)
);
create sequence pmt_recipient_seq increment by 1;

create table recip_filter (
  id                            number(10) not null,
  user_id                       number(10) not null,
  payment_type                  number(10),
  payment_type_comp             number(10),
  vop_result                    varchar2(4),
  vop_result_comp               number(10),
  text                          varchar2(255),
  text_comp                     number(10),
  from_last_usage               date,
  to_last_usage                 date,
  last_usage_comp               number(10),
  constraint ck_recip_filter_payment_type check ( payment_type in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15)),
  constraint ck_rcp_fltr_pymnt_typ_cmp check ( payment_type_comp in (0,1)),
  constraint ck_rcp_fltr_vp_rslt_cmp check ( vop_result_comp in (0,1)),
  constraint ck_recip_filter_text_comp check ( text_comp in (0,1,2,3)),
  constraint ck_rcp_fltr_lst_sg_cmp check ( last_usage_comp in (0,1,2,3)),
  constraint uq_recip_filter_user_id unique (user_id),
  constraint pk_recip_filter primary key (id)
);
create sequence recip_filter_seq increment by 1;

create table pmt_template (
  id                            number(10) not null,
  bank_id                       number(10) not null,
  name                          varchar2(80),
  account_id                    number(10),
  pmt_type                      number(10),
  order_type                    varchar2(3),
  file_type                     varchar2(50),
  is_credit                     number(1),
  is_urgent                     number(1),
  originator                    varchar2(70),
  recipient                     varchar2(70),
  amount                        number(38,3),
  amount_currency               varchar2(3),
  payment_data                  blob,
  folder_id                     number(10),
  generic_purpose               varchar2(150),
  salary_payment                number(1),
  constraint ck_pmt_template_pmt_type check ( pmt_type in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49)),
  constraint pk_pmt_template primary key (id)
);
create sequence pmt_template_seq increment by 1;

create table pmt_transfer_type (
  id                            number(10) not null,
  bank_id                       number(10) not null,
  pmt_type                      number(10),
  order_type                    varchar2(50),
  btf                           varchar2(50),
  order_type_vop                varchar2(50),
  btf_vop                       varchar2(50),
  format                        varchar2(50),
  constraint ck_pmt_transfer_type_pmt_type check ( pmt_type in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49)),
  constraint pk_pmt_transfer_type primary key (id)
);
create sequence pmt_transfer_type_seq increment by 1;

create table pdfstatements_filter (
  id                            number(10) not null,
  user_id                       number(10) not null,
  from_date                     date,
  to_date                       date,
  date_comp                     number(10),
  order_type                    varchar2(255),
  order_type_comp               number(10) not null,
  bank_id                       number(10),
  bank_comp                     number(10) not null,
  statement_active              number(1) default 0 not null,
  account_id                    number(10),
  type                          number(10),
  constraint ck_pdfsttmnts_fltr_dt_cmp check ( date_comp in (0,1,2,3)),
  constraint ck_pdfsttmnts_fltr_rdr_typ_cmp check ( order_type_comp in (0,1,2,3)),
  constraint ck_pdfsttmnts_fltr_bnk_cmp check ( bank_comp in (0)),
  constraint ck_pdfstatements_filter_type check ( type in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16)),
  constraint pk_pdfstatements_filter primary key (id)
);
create sequence pdfstatements_filter_seq increment by 1;

create table pmt_periodic (
  id                            number(10) not null,
  business_id                   number(10),
  created_user_id               number(10) not null,
  created                       timestamp not null,
  confirmed_user_id             number(10),
  confirmed                     timestamp,
  version                       number(10) not null,
  locking_user_id               number(10),
  deleted                       number(1) default 0 not null,
  bank_id                       number(10) not null,
  account_id                    number(10),
  pmt_type                      number(10),
  order_type                    varchar2(3),
  file_type                     varchar2(50),
  is_credit                     number(1),
  is_urgent                     number(1),
  originator                    varchar2(70),
  recipient                     varchar2(70),
  amount                        number(38,3),
  amount_currency               varchar2(3),
  purpose                       varchar2(140),
  exec_ival                     number(10) not null,
  first_execution_date          date,
  last_execution_date           date,
  previous_execution_date       date,
  next_execution_date           date,
  payment_data                  blob,
  generic_purpose               varchar2(150),
  folder_id                     number(10),
  salary_payment                number(1),
  constraint ck_pmt_periodic_version check ( version in (0,1,2)),
  constraint ck_pmt_periodic_pmt_type check ( pmt_type in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49)),
  constraint ck_pmt_periodic_exec_ival check ( exec_ival in (0,1,2,3,4,5,6,7,8,9)),
  constraint pk_pmt_periodic primary key (id)
);
create sequence pmt_periodic_seq increment by 1;

create table preference (
  id                            number(10) not null,
  application_id                number(10) not null,
  pref_key                      varchar2(80) not null,
  pref_value                    varchar2(255),
  user_id                       number(10),
  tenant_id                     number(10),
  constraint ck_preference_application_id check ( application_id in (0,1,2,3,4,5,6,7,8,9)),
  constraint uq_preference_1 unique (application_id,pref_key,user_id),
  constraint pk_preference primary key (id)
);
create sequence preference_seq increment by 1;

create table protocol_setting (
  id                            number(10) not null,
  bank_id                       number(10),
  active                        number(1) default 0 not null,
  protocol_type                 number(3),
  last_protocol_fetch           date,
  constraint ck_prtcl_sttng_prtcl_typ check ( protocol_type in (0,1,2)),
  constraint uq_protocol_setting_bank_id unique (bank_id),
  constraint pk_protocol_setting primary key (id)
);
create sequence protocol_setting_seq increment by 1;

create table ptk_entry (
  id                            number(10) not null,
  bank_id                       number(10),
  ptk_time                      timestamp not null,
  axn                           number(10) not null,
  result                        number(10),
  order_number                  varchar2(4),
  order_type                    varchar2(3),
  data                          clob not null,
  constraint pk_ptk_entry primary key (id)
);
create sequence ptk_entry_seq increment by 1;

create table ptk_filter (
  id                            number(10) not null,
  user_id                       number(10) not null,
  from_date                     date,
  to_date                       date,
  date_comp                     number(10),
  order_type                    varchar2(255),
  order_type_comp               number(10) not null,
  order_nr                      varchar2(255),
  order_nr_comp                 number(10) not null,
  axn                           number(10),
  result                        number(10),
  constraint ck_ptk_filter_date_comp check ( date_comp in (0,1,2,3)),
  constraint ck_ptk_filter_order_type_comp check ( order_type_comp in (0,1,2,3)),
  constraint ck_ptk_filter_order_nr_comp check ( order_nr_comp in (0,1,2,3)),
  constraint pk_ptk_filter primary key (id)
);
create sequence ptk_filter_seq increment by 1;

create table rsapubkey (
  id                            number(10) not null,
  exponent                      blob,
  modulo                        blob,
  cert                          blob,
  constraint pk_rsapubkey primary key (id)
);
create sequence rsapubkey_seq increment by 1;

create table scheduler (
  id                            number(10) not null,
  bank_id                       number(10) not null,
  login_user_id                 number(10),
  order_or_file_type            varchar2(255),
  days                          varchar2(255),
  month                         varchar2(255),
  hour                          varchar2(255),
  minute                        varchar2(255),
  year                          varchar2(255),
  last_fetch                    timestamp,
  parameter                     varchar2(255),
  s_interval                    number(10),
  error                         clob,
  constraint ck_scheduler_s_interval check ( s_interval in (0,1,2,3,4)),
  constraint pk_scheduler primary key (id)
);
create sequence scheduler_seq increment by 1;

create table scl_directory (
  bic                           varchar2(11) not null,
  name                          varchar2(140),
  sct                           number(1),
  sdd                           number(1),
  cor1                          number(1),
  b2b                           number(1),
  scc                           number(1),
  valid_date                    date,
  constraint pk_scl_directory primary key (bic)
);

create table send_item (
  id                            number(10) not null,
  bank_id                       number(10),
  sent                          timestamp not null,
  file_id                       number(10),
  orig_file_name                varchar2(250),
  state                         number(10),
  sts                           varchar2(4),
  cncl_sts                      varchar2(4),
  vop_sts                       varchar2(4),
  error_code                    varchar2(4),
  sender                        varchar2(255),
  pmt_type                      number(10),
  file_type                     varchar2(255),
  order_type                    varchar2(3) not null,
  order_number                  varchar2(4) not null,
  amount                        number(38,3),
  nb_of_txs                     number(10),
  signature_hash                varchar2(64),
  msg_id                        varchar2(35),
  scheme                        varchar2(255),
  additional_order_info         varchar2(255),
  currency                      varchar2(3),
  with_selaries                 number(1),
  manual_approval               number(1),
  callback_id                   number(10),
  ip_address                    varchar2(255),
  signed_payments               number(10),
  constraint ck_send_item_state check ( state in (0,1,2,3,4,5,6,7)),
  constraint ck_send_item_pmt_type check ( pmt_type in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49)),
  constraint ck_send_item_signed_payments check ( signed_payments in (0,1,2)),
  constraint pk_send_item primary key (id)
);
create sequence send_item_seq increment by 1;

create table send_item_account (
  send_item_id                  number(10) not null,
  account_id                    number(10) not null,
  constraint pk_send_item_account primary key (send_item_id,account_id)
);

create table send_filter (
  id                            number(10) not null,
  user_id                       number(10) not null,
  bank_id                       number(10),
  account_id                    number(10),
  send_active                   number(1) default 0 not null,
  ds_signed_active              number(1) default 0 not null,
  ds_cncl_active                number(1) default 0 not null,
  ds_active                     number(1) default 0 not null,
  bank_comp                     number(10) not null,
  ds_overview_signed            number(1),
  pmt_type                      number(10),
  pmt_type_comp                 number(10),
  order_type                    varchar2(255),
  order_type_comp               number(10) not null,
  order_nr                      varchar2(255),
  order_nr_comp                 number(10) not null,
  sender                        varchar2(255),
  sender_comp                   number(10),
  send_state                    number(10),
  ds_state                      number(10),
  state_comp                    number(10) not null,
  from_date                     date,
  to_date                       date,
  date_comp                     number(10),
  from_amount                   number(38,3),
  to_amount                     number(38,3),
  amount_comp                   number(10),
  constraint ck_send_filter_bank_comp check ( bank_comp in (0)),
  constraint ck_send_filter_pmt_type check ( pmt_type in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49)),
  constraint ck_send_filter_pmt_type_comp check ( pmt_type_comp in (0,1)),
  constraint ck_send_filter_order_type_comp check ( order_type_comp in (0,1,2,3)),
  constraint ck_send_filter_order_nr_comp check ( order_nr_comp in (0,1,2,3)),
  constraint ck_send_filter_sender_comp check ( sender_comp in (0,1,2,3)),
  constraint ck_send_filter_send_state check ( send_state in (0,1,2,3,4,5,6,7,8,9)),
  constraint ck_send_filter_ds_state check ( ds_state in (0,1,2,3,4,5)),
  constraint ck_send_filter_state_comp check ( state_comp in (0)),
  constraint ck_send_filter_date_comp check ( date_comp in (0,1,2,3)),
  constraint ck_send_filter_amount_comp check ( amount_comp in (0,1,2,3)),
  constraint pk_send_filter primary key (id)
);
create sequence send_filter_seq increment by 1;

create table pmt_signed (
  id                            number(10) not null,
  account_id                    number(10),
  folder_id                     number(10),
  send_id                       number(10) not null,
  booking_id                    number(10),
  logical_file                  number(10),
  payment_number                number(10),
  callback_id                   number(10),
  pmt_type                      number(10),
  is_credit                     number(1),
  is_urgent                     number(1),
  originator                    varchar2(70),
  recipient                     varchar2(70),
  amount                        number(38,3),
  salary_amount                 number(38,3),
  amount_currency               varchar2(3),
  purpose                       varchar2(140),
  execution_date                timestamp,
  reference                     varchar2(50),
  manual_payment                number(1),
  salary_payment                number(1),
  pmt_inf_id                    varchar2(35),
  state                         number(10),
  sts                           varchar2(4),
  status_reason_info            clob,
  cncl_sts                      varchar2(4),
  vop_sts                       varchar2(4),
  payment_data                  blob,
  constraint ck_pmt_signed_pmt_type check ( pmt_type in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49)),
  constraint ck_pmt_signed_state check ( state in (0,1,2,3,4,5,6,7)),
  constraint pk_pmt_signed primary key (id)
);
create sequence pmt_signed_seq increment by 1;

create table simple_text_filter (
  id                            number(10) not null,
  user_id                       number(10) not null,
  filter_view                   varchar2(255) not null,
  filter_text                   varchar2(255),
  filter_active                 number(1) default 0 not null,
  constraint pk_simple_text_filter primary key (id)
);
create sequence simple_text_filter_seq increment by 1;

create table sorting (
  id                            number(10) not null,
  user_id                       number(10),
  table_id                      varchar2(255),
  sorting_column                number(10),
  sort_ascending                number(1),
  column_order                  varchar2(255),
  column_sizes                  varchar2(255),
  page_size                     number(10),
  additional_information        clob,
  constraint pk_sorting primary key (id)
);
create sequence sorting_seq increment by 1;

create table tenant (
  id                            number(10) not null,
  name                          varchar2(256) not null,
  user_count                    number(10),
  uuid                          varchar2(40),
  admins_uuid                   varchar2(40),
  deleted                       number(1) default 0 not null,
  constraint uq_tenant_name unique (name),
  constraint pk_tenant primary key (id)
);
create sequence tenant_seq increment by 1;

create table pmt_urgnt_rcpnt (
  id                            number(10) not null,
  bank_id                       number(10) not null,
  orgntr_acct_number            varchar2(34),
  orgntr_bank_code              varchar2(11),
  rcpnt_acct_number             varchar2(34),
  rcpnt_bank_code               varchar2(11),
  rcpnt_name                    varchar2(35),
  rcpnt_tp                      number(10),
  constraint ck_pmt_urgnt_rcpnt_rcpnt_tp check ( rcpnt_tp in (0,1)),
  constraint pk_pmt_urgnt_rcpnt primary key (id)
);
create sequence pmt_urgnt_rcpnt_seq increment by 1;

create table loginuser (
  id                            number(10) not null,
  name                          varchar2(256) not null,
  is_admin                      number(1) default 0 not null,
  security_medium               number(10) not null,
  enc_key                       blob not null,
  key_dir                       varchar2(256),
  iccsn                         varchar2(50),
  driver                        varchar2(2048),
  alias                         varchar2(256),
  serial_number                 varchar2(50),
  proxy_password                blob,
  proxy_user                    varchar2(256),
  system_name                   varchar2(255),
  license_id                    varchar2(11),
  web_license_id                varchar2(11),
  error_counter                 number(10),
  error_sign_counter            number(10),
  last_login                    timestamp,
  last_login_error              timestamp,
  last_password_change          date,
  random_id                     varchar2(128),
  challenge                     varchar2(300),
  last_des_fetch                timestamp,
  given_name                    varchar2(256),
  family_name                   varchar2(256),
  email                         varchar2(256),
  uuid                          varchar2(40),
  deleted                       number(1) default 0 not null,
  constraint ck_loginuser_security_medium check ( security_medium in (0,1,2,3,4)),
  constraint pk_loginuser primary key (id)
);
create sequence loginuser_seq increment by 1;

create table loginuser_tenant (
  loginuser_id                  number(10) not null,
  tenant_id                     number(10) not null,
  constraint pk_loginuser_tenant primary key (loginuser_id,tenant_id)
);

create table loginuser_managed_tenant (
  loginuser_id                  number(10) not null,
  tenant_id                     number(10) not null,
  constraint pk_loginuser_managed_tenant primary key (loginuser_id,tenant_id)
);

create table user_effective_permission (
  id                            number(10) not null,
  bank_user_id                  number(10) not null,
  account_id                    number(10) not null,
  pmt_type                      number(10) not null,
  constraint ck_usr_ffctv_prmssn_pmt_typ check ( pmt_type in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49)),
  constraint pk_user_effective_permission primary key (id)
);
create sequence user_effective_permission_seq increment by 1;

create table user_notification (
  id                            number(10) not null,
  user_id                       number(10),
  t                             number(10),
  info                          blob,
  constraint ck_user_notification_t check ( t in (0,1)),
  constraint pk_user_notification primary key (id)
);
create sequence user_notification_seq increment by 1;

create table user_permission (
  id                            number(10) not null,
  bank_user_id                  number(10) not null,
  order_type_id                 number(10),
  auth_level                    number(10),
  max_amount                    number(38,4),
  max_amount_currency           varchar2(3),
  account_permission_id         number(10),
  constraint ck_user_permission_auth_level check ( auth_level in (0,1,2,3)),
  constraint pk_user_permission primary key (id)
);
create sequence user_permission_seq increment by 1;

create table web_authn (
  id                            number(10) not null,
  yubikey_id                    number(10),
  counter                       number(19),
  rp_id                         varchar2(255),
  serialized_data               blob,
  constraint uq_web_authn_yubikey_id unique (yubikey_id),
  constraint pk_web_authn primary key (id)
);
create sequence web_authn_seq increment by 1;

create table workspace_file (
  id                            number(10) not null,
  prefix_id                     number(10) not null,
  deleted                       number(1) default 0 not null,
  path                          varchar2(256) not null,
  file_size                     number(19),
  md5hash                       varchar2(32),
  sha256hash                    varchar2(64),
  constraint pk_workspace_file primary key (id)
);
create sequence workspace_file_seq increment by 1;

create table workspace_file_cluster_node (
  workspace_file_id             number(10) not null,
  cluster_node_id               number(10) not null,
  constraint pk_workspace_file_cluster_node primary key (workspace_file_id,cluster_node_id)
);

create table yubikey (
  id                            number(10) not null,
  user_id                       number(10),
  public_id                     varchar2(2048),
  description                   varchar2(255),
  used_since                    date,
  security_type                 number(10),
  constraint ck_yubikey_security_type check ( security_type in (0,1,2)),
  constraint pk_yubikey primary key (id)
);
create sequence yubikey_seq increment by 1;

create table yubikey_history (
  id                            number(10) not null,
  user_id                       number(10),
  public_id                     varchar2(2048),
  opt                           varchar2(2048),
  error_message                 varchar2(255),
  time_stamp                    timestamp,
  constraint pk_yubikey_history primary key (id)
);
create sequence yubikey_history_seq increment by 1;

create table zip_filter (
  id                            number(10) not null,
  position                      number(10) default 0 not null,
  scheduler_id                  number(10) not null,
  reg_ex_pattern                varchar2(255),
  folder                        varchar2(255),
  constraint pk_zip_filter primary key (id)
);
create sequence zip_filter_seq increment by 1;

create index ix_account_cm_identification on account (bank_id,cm_identification);
create index ix_account_iban on account (bank_id,iban,currency);
create index ix_account_iban_bic on account (bank_id,iban,bic,currency);
create index ix_account_german on account (bank_id,de_bank_code,de_account_number,currency);
create index ix_account_french on account (bank_id,fr_bank_code,fr_branch_code,fr_account_number,currency);
create index ix_awv_entry_report_month on awv_entry (month);
create index ix_cm_booking_statement_pos on cm_booking (statement_id,pos);
create index ix_cm_booking_account_msg_id on cm_booking (account_id,msg_id);
create index ix_ntfctn_trx_stts_rcpnt_ccnt on notification_trx (tx_sts,recipient,recipient_account_number);
create index ix_pmt_open_order_type on pmt_open (order_type);
create index ix_pmt_open_file_type on pmt_open (file_type);
create index ix_pmt_recipient_display_name on pmt_recipient (payment_type,display_name);
create index ix_pmt_recipient_name on pmt_recipient (payment_type,name);
create index ix_pmt_template_order_type on pmt_template (order_type);
create index ix_pmt_template_file_type on pmt_template (file_type);
create index ix_pmt_periodic_order_type on pmt_periodic (order_type);
create index ix_pmt_periodic_file_type on pmt_periodic (file_type);
create index ix_send_item_bank_msg_id on send_item (bank_id,msg_id);
create index ix_pmt_signed_execution_date on pmt_signed (execution_date,account_id);
create index ix_wrkspc_fl_prfx_d_pth on workspace_file (prefix_id,path);
create index ix_account_bank_1 on account (bank_id);
alter table account add constraint fk_account_bank_1 foreign key (bank_id) references bank (id);

create index ix_account_sepa_originator_id on account (sepa_originator_id);
alter table account add constraint fk_account_sepa_originator_id foreign key (sepa_originator_id) references pmt_originator (id);

create index ix_account_dtazv_originator_id on account (dtazv_originator_id);
alter table account add constraint fk_account_dtazv_originator_id foreign key (dtazv_originator_id) references pmt_originator (id);

create index ix_account_mt101_originator_id on account (mt101_originator_id);
alter table account add constraint fk_account_mt101_originator_id foreign key (mt101_originator_id) references pmt_originator (id);

create index ix_account_folder_1 on account (folder_id);
alter table account add constraint fk_account_folder_1 foreign key (folder_id) references cm_folder (id);

create index ix_account_permission_bankUs_1 on account_permission (bank_user_id);
alter table account_permission add constraint fk_account_permission_bankUs_1 foreign key (bank_user_id) references bankuser (id);

create index ix_account_permission_accoun_1 on account_permission (account_id);
alter table account_permission add constraint fk_account_permission_accoun_1 foreign key (account_id) references account (id);

create index ix_ap_overwrite_bankUser_1 on ap_overwrite (bank_user_id);
alter table ap_overwrite add constraint fk_ap_overwrite_bankUser_1 foreign key (bank_user_id) references bankuser (id);

create index ix_ap_overwrite_account_1 on ap_overwrite (account_id);
alter table ap_overwrite add constraint fk_ap_overwrite_account_1 foreign key (account_id) references account (id);

create index ix_automatic_export_conversi_1 on automatic_export (conversion_id);
alter table automatic_export add constraint fk_automatic_export_conversi_1 foreign key (conversion_id) references conversion (id);

create index ix_automatic_export_tenant_1 on automatic_export (tenant_id);
alter table automatic_export add constraint fk_automatic_export_tenant_1 foreign key (tenant_id) references tenant (id);

create index ix_automatic_export_account_01 on automatic_export_account (automatic_export_id);
alter table automatic_export_account add constraint fk_automatic_export_account_01 foreign key (automatic_export_id) references automatic_export (id);

create index ix_automatic_export_account_02 on automatic_export_account (account_id);
alter table automatic_export_account add constraint fk_automatic_export_account_02 foreign key (account_id) references account (id);

create index ix_atmtc_xprt_fldr_tmtc_xprt on automatic_export_folder (automatic_export_id);
alter table automatic_export_folder add constraint fk_atmtc_xprt_fldr_tmtc_xprt foreign key (automatic_export_id) references automatic_export (id);

create index ix_atmtc_xprt_fldr_cm_fldr on automatic_export_folder (cm_folder_id);
alter table automatic_export_folder add constraint fk_atmtc_xprt_fldr_cm_fldr foreign key (cm_folder_id) references cm_folder (id);

create index ix_awv_dika_abstractEntry_1 on awv_dika (abstract_entry_id);
alter table awv_dika add constraint fk_awv_dika_abstractEntry_1 foreign key (abstract_entry_id) references awv_entry (id);

create index ix_awv_dirinv_abstractEntry_1 on awv_dirinv (abstract_entry_id);
alter table awv_dirinv add constraint fk_awv_dirinv_abstractEntry_1 foreign key (abstract_entry_id) references awv_entry (id);

create index ix_awv_entry_entryReporter_1 on awv_entry (reporter);
alter table awv_entry add constraint fk_awv_entry_entryReporter_1 foreign key (reporter) references awv_contact (id);

create index ix_awv_entry_tenant_1 on awv_entry (tenant_id);
alter table awv_entry add constraint fk_awv_entry_tenant_1 foreign key (tenant_id) references tenant (id);

create index ix_awv_entry_signedPayment_1 on awv_entry (signed_payment_id);
alter table awv_entry add constraint fk_awv_entry_signedPayment_1 foreign key (signed_payment_id) references pmt_signed (id);

create index ix_awv_entry_cmBooking_1 on awv_entry (cm_booking_id);
alter table awv_entry add constraint fk_awv_entry_cmBooking_1 foreign key (cm_booking_id) references cm_booking (id);

create index ix_awv_export_tenant_1 on awv_export (tenant_id);
alter table awv_export add constraint fk_awv_export_tenant_1 foreign key (tenant_id) references tenant (id);

create index ix_awv_company_tenant_1 on awv_company (tenant_id);
alter table awv_company add constraint fk_awv_company_tenant_1 foreign key (tenant_id) references tenant (id);

create index ix_awv_contact_company_1 on awv_contact (company);
alter table awv_contact add constraint fk_awv_contact_company_1 foreign key (company) references awv_company (id);

create index ix_awv_transit_abstractEntry_1 on awv_transit (abstract_entry_id);
alter table awv_transit add constraint fk_awv_transit_abstractEntry_1 foreign key (abstract_entry_id) references awv_entry (id);

create index ix_bank_e001Key_1 on bank (e001key_id);
alter table bank add constraint fk_bank_e001Key_1 foreign key (e001key_id) references rsapubkey (id);

create index ix_bank_e002Key_1 on bank (e002key_id);
alter table bank add constraint fk_bank_e002Key_1 foreign key (e002key_id) references rsapubkey (id);

create index ix_bank_x001Key_1 on bank (x001key_id);
alter table bank add constraint fk_bank_x001Key_1 foreign key (x001key_id) references rsapubkey (id);

create index ix_bank_x002Key_1 on bank (x002key_id);
alter table bank add constraint fk_bank_x002Key_1 foreign key (x002key_id) references rsapubkey (id);

create index ix_bank_tenant_1 on bank (tenant_id);
alter table bank add constraint fk_bank_tenant_1 foreign key (tenant_id) references tenant (id);

create index ix_bankuser_bank_1 on bankuser (bank_id);
alter table bankuser add constraint fk_bankuser_bank_1 foreign key (bank_id) references bank (id);

create index ix_bankuser_user_1 on bankuser (user_id);
alter table bankuser add constraint fk_bankuser_user_1 foreign key (user_id) references loginuser (id);

alter table bank_user_htd_info add constraint fk_bank_user_htd_info_bankUs_1 foreign key (bank_user_id) references bankuser (id);

create index ix_cm_balance_account_1 on cm_balance (account_id);
alter table cm_balance add constraint fk_cm_balance_account_1 foreign key (account_id) references account (id);

create index ix_cm_balance2_account_1 on cm_balance2 (account_id);
alter table cm_balance2 add constraint fk_cm_balance2_account_1 foreign key (account_id) references account (id);

alter table cm_bank add constraint fk_cm_bank_bank_1 foreign key (bank_id) references bank (id);

create index ix_cm_booking_statement_1 on cm_booking (statement_id);
alter table cm_booking add constraint fk_cm_booking_statement_1 foreign key (statement_id) references cm_statement (id);

create index ix_cm_booking_page_1 on cm_booking (page_id);
alter table cm_booking add constraint fk_cm_booking_page_1 foreign key (page_id) references cm_page (id);

create index ix_cm_booking_account_1 on cm_booking (account_id);
alter table cm_booking add constraint fk_cm_booking_account_1 foreign key (account_id) references account (id);

create index ix_cm_booking_parentBooking_1 on cm_booking (parent_booking_id);
alter table cm_booking add constraint fk_cm_booking_parentBooking_1 foreign key (parent_booking_id) references cm_booking (id);

alter table cm_b_filter add constraint fk_cm_b_filter_user_1 foreign key (user_id) references loginuser (id);

create index ix_cm_charge_booking_id on cm_charge (booking_id);
alter table cm_charge add constraint fk_cm_charge_booking_id foreign key (booking_id) references cm_booking (id);

create index ix_cm_charge_statement_id on cm_charge (statement_id);
alter table cm_charge add constraint fk_cm_charge_statement_id foreign key (statement_id) references cm_statement (id);

create index ix_cm_charge_page_id on cm_charge (page_id);
alter table cm_charge add constraint fk_cm_charge_page_id foreign key (page_id) references cm_page (id);

create index ix_cm_check_login_1 on cm_check (login_id);
alter table cm_check add constraint fk_cm_check_login_1 foreign key (login_id) references loginuser (id);

create index ix_cm_check_statement_1 on cm_check (statement_id);
alter table cm_check add constraint fk_cm_check_statement_1 foreign key (statement_id) references cm_statement (id);

create index ix_cm_check_page_1 on cm_check (page_id);
alter table cm_check add constraint fk_cm_check_page_1 foreign key (page_id) references cm_page (id);

create index ix_cm_folder_tenant_1 on cm_folder (tenant_id);
alter table cm_folder add constraint fk_cm_folder_tenant_1 foreign key (tenant_id) references tenant (id);

create index ix_cm_page_statement_1 on cm_page (statement_id);
alter table cm_page add constraint fk_cm_page_statement_1 foreign key (statement_id) references cm_statement (id);

create index ix_cm_page_file_id on cm_page (file_id);
alter table cm_page add constraint fk_cm_page_file_id foreign key (file_id) references workspace_file (id);

create index ix_cm_pdf_statement_bank_1 on cm_pdf_statement (bank_id);
alter table cm_pdf_statement add constraint fk_cm_pdf_statement_bank_1 foreign key (bank_id) references bank (id);

create index ix_cm_pdf_statement_account_1 on cm_pdf_statement (account_id);
alter table cm_pdf_statement add constraint fk_cm_pdf_statement_account_1 foreign key (account_id) references account (id);

create index ix_cm_pdf_sttmnt_lcl_fl_d on cm_pdf_statement (local_file_id);
alter table cm_pdf_statement add constraint fk_cm_pdf_sttmnt_lcl_fl_d foreign key (local_file_id) references workspace_file (id);

create index ix_cm_statement_account_1 on cm_statement (account_id);
alter table cm_statement add constraint fk_cm_statement_account_1 foreign key (account_id) references account (id);

create index ix_cm_statement_file_id on cm_statement (file_id);
alter table cm_statement add constraint fk_cm_statement_file_id foreign key (file_id) references workspace_file (id);

create index ix_cm_value_group_tenant_1 on cm_value_group (tenant_id);
alter table cm_value_group add constraint fk_cm_value_group_tenant_1 foreign key (tenant_id) references tenant (id);

create index ix_cm_value_group_account_c_01 on cm_value_group_account (cm_value_group_id);
alter table cm_value_group_account add constraint fk_cm_value_group_account_c_01 foreign key (cm_value_group_id) references cm_value_group (id);

create index ix_cm_value_group_account_a_02 on cm_value_group_account (account_id);
alter table cm_value_group_account add constraint fk_cm_value_group_account_a_02 foreign key (account_id) references account (id);

create index ix_cm_value_group_folder_cm_01 on cm_value_group_folder (cm_value_group_id);
alter table cm_value_group_folder add constraint fk_cm_value_group_folder_cm_01 foreign key (cm_value_group_id) references cm_value_group (id);

create index ix_cm_value_group_folder_cm_02 on cm_value_group_folder (cm_folder_id);
alter table cm_value_group_folder add constraint fk_cm_value_group_folder_cm_02 foreign key (cm_folder_id) references cm_folder (id);

create index ix_conversion_tenant_1 on conversion (tenant_id);
alter table conversion add constraint fk_conversion_tenant_1 foreign key (tenant_id) references tenant (id);

create index ix_sepa_converter_format_ten_1 on sepa_converter_format (tenant_id);
alter table sepa_converter_format add constraint fk_sepa_converter_format_ten_1 foreign key (tenant_id) references tenant (id);

create index ix_directory_scanner_bank_1 on directory_scanner (bank_id);
alter table directory_scanner add constraint fk_directory_scanner_bank_1 foreign key (bank_id) references bank (id);

alter table ds_bank add constraint fk_ds_bank_bank_1 foreign key (bank_id) references bank (id);

create index ix_ds_open_order_bankUser_1 on ds_open_order (bank_user_id);
alter table ds_open_order add constraint fk_ds_open_order_bankUser_1 foreign key (bank_user_id) references bankuser (id);

create index ix_ds_open_order_order_data_id on ds_open_order (order_data_id);
alter table ds_open_order add constraint fk_ds_open_order_order_data_id foreign key (order_data_id) references workspace_file (id);

create index ix_ds_pn_rdr_pymnt_dt_d on ds_open_order (payment_data_id);
alter table ds_open_order add constraint fk_ds_pn_rdr_pymnt_dt_d foreign key (payment_data_id) references workspace_file (id);

create index ix_ds_open_order_signer_dsOp_1 on ds_open_order_signer (ds_open_order_id);
alter table ds_open_order_signer add constraint fk_ds_open_order_signer_dsOp_1 foreign key (ds_open_order_id) references ds_open_order (id);

create index ix_ds_order_details_bank_1 on ds_order_details (bank_id);
alter table ds_order_details add constraint fk_ds_order_details_bank_1 foreign key (bank_id) references bank (id);

create index ix_ds_rdr_dtls_dt_fl_d on ds_order_details (data_file_id);
alter table ds_order_details add constraint fk_ds_rdr_dtls_dt_fl_d foreign key (data_file_id) references workspace_file (id);

create index ix_ds_order_details_account_01 on ds_order_details_account (ds_order_details_id);
alter table ds_order_details_account add constraint fk_ds_order_details_account_01 foreign key (ds_order_details_id) references ds_order_details (id);

create index ix_ds_order_details_account_02 on ds_order_details_account (account_id);
alter table ds_order_details_account add constraint fk_ds_order_details_account_02 foreign key (account_id) references account (id);

create index ix_ds_signing_info_dsOrderDe_1 on ds_signing_info (ds_order_details_id);
alter table ds_signing_info add constraint fk_ds_signing_info_dsOrderDe_1 foreign key (ds_order_details_id) references ds_order_details (id);

create index ix_exprt_fl_wrkspc_fl_d on export_file (workspace_file_id);
alter table export_file add constraint fk_exprt_fl_wrkspc_fl_d foreign key (workspace_file_id) references workspace_file (id);

create index ix_export_file_account_expo_01 on export_file_account (export_file_id);
alter table export_file_account add constraint fk_export_file_account_expo_01 foreign key (export_file_id) references export_file (id);

create index ix_export_file_account_acco_02 on export_file_account (account_id);
alter table export_file_account add constraint fk_export_file_account_acco_02 foreign key (account_id) references account (id);

create index ix_export_file_aut_export_e_01 on export_file_aut_export (export_file_id);
alter table export_file_aut_export add constraint fk_export_file_aut_export_e_01 foreign key (export_file_id) references export_file (id);

create index ix_export_file_aut_export_a_02 on export_file_aut_export (automatic_export_id);
alter table export_file_aut_export add constraint fk_export_file_aut_export_a_02 foreign key (automatic_export_id) references automatic_export (id);

create index ix_exportfile_filter_user_id on exportfile_filter (user_id);
alter table exportfile_filter add constraint fk_exportfile_filter_user_id foreign key (user_id) references loginuser (id);

create index ix_fetch_item_bank_1 on fetch_item (bank_id);
alter table fetch_item add constraint fk_fetch_item_bank_1 foreign key (bank_id) references bank (id);

create index ix_fetch_item_file_id on fetch_item (file_id);
alter table fetch_item add constraint fk_fetch_item_file_id foreign key (file_id) references workspace_file (id);

create index ix_fe_filter_user_1 on fe_filter (user_id);
alter table fe_filter add constraint fk_fe_filter_user_1 foreign key (user_id) references loginuser (id);

create index ix_fe_filter_bank_1 on fe_filter (bank_id);
alter table fe_filter add constraint fk_fe_filter_bank_1 foreign key (bank_id) references bank (id);

create index ix_hac_entry_bank_1 on hac_entry (bank_id);
alter table hac_entry add constraint fk_hac_entry_bank_1 foreign key (bank_id) references bank (id);

create index ix_hac_filter_user_1 on hac_filter (user_id);
alter table hac_filter add constraint fk_hac_filter_user_1 foreign key (user_id) references loginuser (id);

create index ix_log_tenant_id on log (tenant_id);
alter table log add constraint fk_log_tenant_id foreign key (tenant_id) references tenant (id);

create index ix_log_account_id on log (account_id);
alter table log add constraint fk_log_account_id foreign key (account_id) references account (id);

create index ix_log_actor_id on log (actor_id);
alter table log add constraint fk_log_actor_id foreign key (actor_id) references loginuser (id);

alter table log_filter add constraint fk_log_filter_user_id foreign key (user_id) references loginuser (id);

create index ix_login_session_user_id on login_session (user_id);
alter table login_session add constraint fk_login_session_user_id foreign key (user_id) references loginuser (id);

create index ix_notification_bank_1 on notification (bank_id);
alter table notification add constraint fk_notification_bank_1 foreign key (bank_id) references bank (id);

create index ix_notification_file_id on notification (file_id);
alter table notification add constraint fk_notification_file_id foreign key (file_id) references workspace_file (id);

create index ix_notification_send_1 on notification (send_id);
alter table notification add constraint fk_notification_send_1 foreign key (send_id) references send_item (id);

create index ix_nf_filter_user_1 on nf_filter (user_id);
alter table nf_filter add constraint fk_nf_filter_user_1 foreign key (user_id) references loginuser (id);

create index ix_nf_filter_bank_1 on nf_filter (bank_id);
alter table nf_filter add constraint fk_nf_filter_bank_1 foreign key (bank_id) references bank (id);

create index ix_notification_pmt_inf_noti_1 on notification_pmt_inf (notification_id);
alter table notification_pmt_inf add constraint fk_notification_pmt_inf_noti_1 foreign key (notification_id) references notification (id);

alter table nf_setting add constraint fk_nf_setting_bank_1 foreign key (bank_id) references bank (id);

create index ix_notification_trx_notifica_1 on notification_trx (notification_id);
alter table notification_trx add constraint fk_notification_trx_notifica_1 foreign key (notification_id) references notification (id);

create index ix_notification_trx_pmtInf_1 on notification_trx (pmt_inf_id);
alter table notification_trx add constraint fk_notification_trx_pmtInf_1 foreign key (pmt_inf_id) references notification_pmt_inf (id);

create index ix_notification_trx_send_1 on notification_trx (send_id);
alter table notification_trx add constraint fk_notification_trx_send_1 foreign key (send_id) references send_item (id);

create index ix_notification_trx_signedPa_1 on notification_trx (signed_payment_id);
alter table notification_trx add constraint fk_notification_trx_signedPa_1 foreign key (signed_payment_id) references pmt_signed (id);

create index ix_open_id_token_user_id on open_id_token (user_id);
alter table open_id_token add constraint fk_open_id_token_user_id foreign key (user_id) references loginuser (id);

create index ix_pmt_open_createdUser_1 on pmt_open (created_user_id);
alter table pmt_open add constraint fk_pmt_open_createdUser_1 foreign key (created_user_id) references loginuser (id);

create index ix_pmt_open_confirmedUser_1 on pmt_open (confirmed_user_id);
alter table pmt_open add constraint fk_pmt_open_confirmedUser_1 foreign key (confirmed_user_id) references loginuser (id);

create index ix_pmt_open_lockingUser_1 on pmt_open (locking_user_id);
alter table pmt_open add constraint fk_pmt_open_lockingUser_1 foreign key (locking_user_id) references loginuser (id);

create index ix_pmt_open_bank_1 on pmt_open (bank_id);
alter table pmt_open add constraint fk_pmt_open_bank_1 foreign key (bank_id) references bank (id);

create index ix_pmt_open_account_1 on pmt_open (account_id);
alter table pmt_open add constraint fk_pmt_open_account_1 foreign key (account_id) references account (id);

create index ix_pmt_open_folder_1 on pmt_open (folder_id);
alter table pmt_open add constraint fk_pmt_open_folder_1 foreign key (folder_id) references pmt_folder (id);

create index ix_order_type_bank_1 on order_type (bank_id);
alter table order_type add constraint fk_order_type_bank_1 foreign key (bank_id) references bank (id);

create index ix_password_history_user_1 on password_history (user_id);
alter table password_history add constraint fk_password_history_user_1 foreign key (user_id) references loginuser (id);

alter table pmt_filter add constraint fk_pmt_filter_user_1 foreign key (user_id) references loginuser (id);

create index ix_pmt_folder_tenant_1 on pmt_folder (tenant_id);
alter table pmt_folder add constraint fk_pmt_folder_tenant_1 foreign key (tenant_id) references tenant (id);

create index ix_pmt_originator_tenant_1 on pmt_originator (tenant_id);
alter table pmt_originator add constraint fk_pmt_originator_tenant_1 foreign key (tenant_id) references tenant (id);

create index ix_pmt_rgntr_dflt_ccnt_d on pmt_originator (default_account_id);
alter table pmt_originator add constraint fk_pmt_rgntr_dflt_ccnt_d foreign key (default_account_id) references account (id);

alter table pmt_props add constraint fk_pmt_props_bank_1 foreign key (bank_id) references bank (id);

create index ix_pmt_recipient_createdUser_1 on pmt_recipient (created_user_id);
alter table pmt_recipient add constraint fk_pmt_recipient_createdUser_1 foreign key (created_user_id) references loginuser (id);

create index ix_pmt_recipient_confirmedUs_1 on pmt_recipient (confirmed_user_id);
alter table pmt_recipient add constraint fk_pmt_recipient_confirmedUs_1 foreign key (confirmed_user_id) references loginuser (id);

create index ix_pmt_recipient_lockingUser_1 on pmt_recipient (locking_user_id);
alter table pmt_recipient add constraint fk_pmt_recipient_lockingUser_1 foreign key (locking_user_id) references loginuser (id);

create index ix_pmt_recipient_tenant_1 on pmt_recipient (tenant_id);
alter table pmt_recipient add constraint fk_pmt_recipient_tenant_1 foreign key (tenant_id) references tenant (id);

alter table recip_filter add constraint fk_recip_filter_user_id foreign key (user_id) references loginuser (id);

create index ix_pmt_template_bank_1 on pmt_template (bank_id);
alter table pmt_template add constraint fk_pmt_template_bank_1 foreign key (bank_id) references bank (id);

create index ix_pmt_template_account_1 on pmt_template (account_id);
alter table pmt_template add constraint fk_pmt_template_account_1 foreign key (account_id) references account (id);

create index ix_pmt_template_folder_1 on pmt_template (folder_id);
alter table pmt_template add constraint fk_pmt_template_folder_1 foreign key (folder_id) references pmt_folder (id);

create index ix_pmt_transfer_type_bank_1 on pmt_transfer_type (bank_id);
alter table pmt_transfer_type add constraint fk_pmt_transfer_type_bank_1 foreign key (bank_id) references bank (id);

create index ix_pdfsttmnts_fltr_sr_d on pdfstatements_filter (user_id);
alter table pdfstatements_filter add constraint fk_pdfsttmnts_fltr_sr_d foreign key (user_id) references loginuser (id);

create index ix_pdfsttmnts_fltr_bnk_d on pdfstatements_filter (bank_id);
alter table pdfstatements_filter add constraint fk_pdfsttmnts_fltr_bnk_d foreign key (bank_id) references bank (id);

create index ix_pmt_periodic_createdUser_1 on pmt_periodic (created_user_id);
alter table pmt_periodic add constraint fk_pmt_periodic_createdUser_1 foreign key (created_user_id) references loginuser (id);

create index ix_pmt_periodic_confirmedUse_1 on pmt_periodic (confirmed_user_id);
alter table pmt_periodic add constraint fk_pmt_periodic_confirmedUse_1 foreign key (confirmed_user_id) references loginuser (id);

create index ix_pmt_periodic_lockingUser_1 on pmt_periodic (locking_user_id);
alter table pmt_periodic add constraint fk_pmt_periodic_lockingUser_1 foreign key (locking_user_id) references loginuser (id);

create index ix_pmt_periodic_bank_1 on pmt_periodic (bank_id);
alter table pmt_periodic add constraint fk_pmt_periodic_bank_1 foreign key (bank_id) references bank (id);

create index ix_pmt_periodic_account_1 on pmt_periodic (account_id);
alter table pmt_periodic add constraint fk_pmt_periodic_account_1 foreign key (account_id) references account (id);

create index ix_pmt_periodic_folder_1 on pmt_periodic (folder_id);
alter table pmt_periodic add constraint fk_pmt_periodic_folder_1 foreign key (folder_id) references pmt_folder (id);

create index ix_preference_user_1 on preference (user_id);
alter table preference add constraint fk_preference_user_1 foreign key (user_id) references loginuser (id);

create index ix_preference_tenant_1 on preference (tenant_id);
alter table preference add constraint fk_preference_tenant_1 foreign key (tenant_id) references tenant (id);

alter table protocol_setting add constraint fk_protocol_setting_bank_1 foreign key (bank_id) references bank (id);

create index ix_ptk_entry_bank_1 on ptk_entry (bank_id);
alter table ptk_entry add constraint fk_ptk_entry_bank_1 foreign key (bank_id) references bank (id);

create index ix_ptk_filter_user_1 on ptk_filter (user_id);
alter table ptk_filter add constraint fk_ptk_filter_user_1 foreign key (user_id) references loginuser (id);

create index ix_scheduler_bank_id on scheduler (bank_id);
alter table scheduler add constraint fk_scheduler_bank_id foreign key (bank_id) references bank (id);

create index ix_scheduler_login_user_id on scheduler (login_user_id);
alter table scheduler add constraint fk_scheduler_login_user_id foreign key (login_user_id) references loginuser (id);

create index ix_send_item_bank_1 on send_item (bank_id);
alter table send_item add constraint fk_send_item_bank_1 foreign key (bank_id) references bank (id);

create index ix_send_item_file_id on send_item (file_id);
alter table send_item add constraint fk_send_item_file_id foreign key (file_id) references workspace_file (id);

create index ix_send_item_callback_1 on send_item (callback_id);
alter table send_item add constraint fk_send_item_callback_1 foreign key (callback_id) references send_item (id);

create index ix_send_item_account_send_i_01 on send_item_account (send_item_id);
alter table send_item_account add constraint fk_send_item_account_send_i_01 foreign key (send_item_id) references send_item (id);

create index ix_send_item_account_accoun_02 on send_item_account (account_id);
alter table send_item_account add constraint fk_send_item_account_accoun_02 foreign key (account_id) references account (id);

create index ix_send_filter_user_1 on send_filter (user_id);
alter table send_filter add constraint fk_send_filter_user_1 foreign key (user_id) references loginuser (id);

create index ix_send_filter_bank_1 on send_filter (bank_id);
alter table send_filter add constraint fk_send_filter_bank_1 foreign key (bank_id) references bank (id);

create index ix_send_filter_account_1 on send_filter (account_id);
alter table send_filter add constraint fk_send_filter_account_1 foreign key (account_id) references account (id);

create index ix_pmt_signed_account_1 on pmt_signed (account_id);
alter table pmt_signed add constraint fk_pmt_signed_account_1 foreign key (account_id) references account (id);

create index ix_pmt_signed_folder_1 on pmt_signed (folder_id);
alter table pmt_signed add constraint fk_pmt_signed_folder_1 foreign key (folder_id) references pmt_folder (id);

create index ix_pmt_signed_send_1 on pmt_signed (send_id);
alter table pmt_signed add constraint fk_pmt_signed_send_1 foreign key (send_id) references send_item (id);

create index ix_pmt_signed_booking_id on pmt_signed (booking_id);
alter table pmt_signed add constraint fk_pmt_signed_booking_id foreign key (booking_id) references cm_booking (id);

create index ix_pmt_signed_callback_1 on pmt_signed (callback_id);
alter table pmt_signed add constraint fk_pmt_signed_callback_1 foreign key (callback_id) references send_item (id);

create index ix_simple_text_filter_user_1 on simple_text_filter (user_id);
alter table simple_text_filter add constraint fk_simple_text_filter_user_1 foreign key (user_id) references loginuser (id);

create index ix_sorting_user_1 on sorting (user_id);
alter table sorting add constraint fk_sorting_user_1 foreign key (user_id) references loginuser (id);

create index ix_pmt_urgnt_rcpnt_bank_1 on pmt_urgnt_rcpnt (bank_id);
alter table pmt_urgnt_rcpnt add constraint fk_pmt_urgnt_rcpnt_bank_1 foreign key (bank_id) references bank (id);

create index ix_loginuser_license_1 on loginuser (license_id);
alter table loginuser add constraint fk_loginuser_license_1 foreign key (license_id) references license (id);

create index ix_loginuser_webLicense_1 on loginuser (web_license_id);
alter table loginuser add constraint fk_loginuser_webLicense_1 foreign key (web_license_id) references license (id);

create index ix_loginuser_tenant_loginus_01 on loginuser_tenant (loginuser_id);
alter table loginuser_tenant add constraint fk_loginuser_tenant_loginus_01 foreign key (loginuser_id) references loginuser (id);

create index ix_loginuser_tenant_tenant_02 on loginuser_tenant (tenant_id);
alter table loginuser_tenant add constraint fk_loginuser_tenant_tenant_02 foreign key (tenant_id) references tenant (id);

create index ix_loginuser_managed_tenant_01 on loginuser_managed_tenant (loginuser_id);
alter table loginuser_managed_tenant add constraint fk_loginuser_managed_tenant_01 foreign key (loginuser_id) references loginuser (id);

create index ix_loginuser_managed_tenant_02 on loginuser_managed_tenant (tenant_id);
alter table loginuser_managed_tenant add constraint fk_loginuser_managed_tenant_02 foreign key (tenant_id) references tenant (id);

create index ix_usr_ffctv_prmssn_bnk_sr_d on user_effective_permission (bank_user_id);
alter table user_effective_permission add constraint fk_usr_ffctv_prmssn_bnk_sr_d foreign key (bank_user_id) references bankuser (id);

create index ix_usr_ffctv_prmssn_ccnt_d on user_effective_permission (account_id);
alter table user_effective_permission add constraint fk_usr_ffctv_prmssn_ccnt_d foreign key (account_id) references account (id);

create index ix_user_notification_user_id on user_notification (user_id);
alter table user_notification add constraint fk_user_notification_user_id foreign key (user_id) references loginuser (id);

create index ix_user_permission_bankUser_1 on user_permission (bank_user_id);
alter table user_permission add constraint fk_user_permission_bankUser_1 foreign key (bank_user_id) references bankuser (id);

create index ix_user_permission_orderType_1 on user_permission (order_type_id);
alter table user_permission add constraint fk_user_permission_orderType_1 foreign key (order_type_id) references order_type (id);

create index ix_user_permission_accountPe_1 on user_permission (account_permission_id);
alter table user_permission add constraint fk_user_permission_accountPe_1 foreign key (account_permission_id) references account_permission (id);

alter table web_authn add constraint fk_web_authn_yubikey_1 foreign key (yubikey_id) references yubikey (id);

create index ix_wrkspc_fl_clstr_nd_w_kntx6d on workspace_file_cluster_node (workspace_file_id);
alter table workspace_file_cluster_node add constraint fk_wrkspc_fl_clstr_nd_w_5pjp3z foreign key (workspace_file_id) references workspace_file (id);

create index ix_wrkspc_fl_clstr_nd_clstr_nd on workspace_file_cluster_node (cluster_node_id);
alter table workspace_file_cluster_node add constraint fk_wrkspc_fl_clstr_nd_clstr_nd foreign key (cluster_node_id) references cluster_node (id);

create index ix_yubikey_user_1 on yubikey (user_id);
alter table yubikey add constraint fk_yubikey_user_1 foreign key (user_id) references loginuser (id);

create index ix_yubikey_history_user_1 on yubikey_history (user_id);
alter table yubikey_history add constraint fk_yubikey_history_user_1 foreign key (user_id) references loginuser (id);

create index ix_zip_filter_scheduler_1 on zip_filter (scheduler_id);
alter table zip_filter add constraint fk_zip_filter_scheduler_1 foreign key (scheduler_id) references scheduler (id);


INSERT INTO applicationinfo (prop_name, prop_value) VALUES ('db_layout', '379');
