-- apply changes
create table account (
  id                            integer auto_increment not null,
  bank_id                       integer not null,
  name                          varchar(50) not null,
  description                   varchar(256),
  account_holder                varchar(256),
  account_holder_htd            varchar(256),
  info_text                     longtext,
  sepa_originator_id            integer,
  dtazv_originator_id           integer,
  mt101_originator_id           integer,
  de_bank_code                  varchar(8),
  de_account_number             varchar(10),
  fr_bank_code                  varchar(5),
  fr_branch_code                varchar(5),
  fr_account_number             varchar(11),
  fr_check_code                 varchar(2),
  iban                          varchar(34),
  bic                           varchar(11),
  national_bank_code            varchar(30),
  national_account_number       varchar(40),
  currency                      varchar(3),
  cm_identification             varchar(256),
  credit_limit                  decimal(38,3),
  ip_limit                      decimal(38,3),
  ip_limit_type                 integer,
  ip_limit_state                integer,
  ip_limit_time                 datetime(6),
  ip_limit_msg_id               varchar(35),
  investment_amount             decimal(38,3),
  type                          integer,
  folder_id                     integer,
  use_virtual_balances          tinyint(1),
  virtual_start_balance         decimal(38,3),
  virtual_start_date            date,
  ignore_account_information    tinyint(1),
  constraint pk_account primary key (id)
);

create table account_permission (
  id                            integer auto_increment not null,
  bank_user_id                  integer not null,
  account_id                    integer not null,
  constraint uq_account_permission_1 unique (bank_user_id,account_id),
  constraint pk_account_permission primary key (id)
);

create table ap_overwrite (
  id                            integer auto_increment not null,
  bank_user_id                  integer not null,
  account_id                    integer not null,
  previous_enabled              tinyint(1) default 1 not null,
  amount_limit                  decimal(16,3),
  constraint uq_ap_overwrite_1 unique (bank_user_id,account_id),
  constraint pk_ap_overwrite primary key (id)
);

create table applicationinfo (
  prop_name                     varchar(50) not null,
  prop_value                    varchar(500),
  constraint pk_applicationinfo primary key (prop_name)
);

create table automatic_export (
  id                            integer auto_increment not null,
  name                          varchar(255),
  conversion_id                 integer,
  convert_to_pdf                tinyint(1),
  directory                     varchar(255),
  pattern                       varchar(255),
  activated                     tinyint(1),
  type                          integer not null,
  tenant_id                     integer not null,
  constraint pk_automatic_export primary key (id)
);

create table automatic_export_account (
  automatic_export_id           integer not null,
  account_id                    integer not null,
  constraint pk_automatic_export_account primary key (automatic_export_id,account_id)
);

create table automatic_export_folder (
  automatic_export_id           integer not null,
  cm_folder_id                  integer not null,
  constraint pk_automatic_export_folder primary key (automatic_export_id,cm_folder_id)
);

create table awv_dika (
  id                            integer auto_increment not null,
  abstract_entry_id             integer not null,
  purpose                       varchar(140),
  amount                        bigint,
  country                       varchar(2),
  ref_amount                    varchar(30),
  stlmnt_key                    varchar(1),
  constraint pk_awv_dika primary key (id)
);

create table awv_dirinv (
  id                            integer auto_increment not null,
  abstract_entry_id             integer not null,
  isin                          varchar(12),
  label                         varchar(35),
  st_number                     integer,
  amount                        bigint,
  country                       varchar(2),
  ref_amount                    varchar(30),
  stlmnt_key                    varchar(1),
  constraint pk_awv_dirinv primary key (id)
);

create table awv_entry (
  id                            integer auto_increment not null,
  type                          integer not null,
  month                         varchar(6) not null,
  reporter                      integer,
  category                      integer,
  svc_code                      varchar(3),
  reference                     varchar(35),
  cancel                        tinyint(1) not null,
  cmnt                          varchar(80),
  exported                      tinyint(1) not null,
  end_to_end_id                 varchar(50),
  tenant_id                     integer not null,
  origin                        integer not null,
  signed_payment_id             integer,
  cm_booking_id                 integer,
  constraint pk_awv_entry primary key (id)
);

create table awv_export (
  id                            integer auto_increment not null,
  month                         varchar(6) not null,
  export_time                   datetime(6),
  export_user                   varchar(256),
  export_file                   varchar(1024),
  tenant_id                     integer not null,
  constraint uq_awv_export_month unique (month),
  constraint pk_awv_export primary key (id)
);

create table awv_company (
  id                            integer auto_increment not null,
  institute                     varchar(9) not null,
  name                          varchar(80) not null,
  street                        varchar(80),
  pob                           varchar(80),
  zip                           varchar(20),
  town                          varchar(80),
  country                       varchar(2),
  tenant_id                     integer not null,
  constraint pk_awv_company primary key (id)
);

create table awv_contact (
  id                            integer auto_increment not null,
  company                       integer not null,
  title                         varchar(80),
  firstname                     varchar(80),
  surname                       varchar(80) not null,
  dept                          varchar(80),
  phone                         varchar(80) not null,
  fax                           varchar(80),
  email                         varchar(255),
  extranet                      varchar(8),
  constraint pk_awv_contact primary key (id)
);

create table awv_transit (
  id                            integer auto_increment not null,
  abstract_entry_id             integer not null,
  warecode                      varchar(2),
  warename                      varchar(140),
  amount                        bigint,
  country                       varchar(2),
  ref_amount                    varchar(30),
  stlmnt_key                    varchar(1),
  constraint pk_awv_transit primary key (id)
);

create table bank (
  id                            integer auto_increment not null,
  display_name                  varchar(64) not null,
  icon                          varchar(128),
  country                       varchar(2),
  url                           varchar(256) not null,
  prot_version                  varchar(4) not null,
  host_id                       varchar(35) not null,
  customer_id                   varchar(35) not null,
  hpd_time                      datetime(6),
  hpd                           longblob,
  e001key_id                    integer,
  e002key_id                    integer,
  x001key_id                    integer,
  x002key_id                    integer,
  expected_digest_e001          varchar(40),
  expected_digest_x001          varchar(40),
  expected_digest_e002          varchar(64),
  expected_digest_x002          varchar(64),
  dtazv_number                  integer,
  transfer_system               tinyint(1),
  transport_only                tinyint(1),
  use_hca_pub                   tinyint(1),
  wss_fetch_type                varchar(255),
  vop_activated                 tinyint(1) default 0 not null,
  vop_mandatory                 tinyint(1) default 0 not null,
  tenant_id                     integer not null,
  constraint pk_bank primary key (id)
);

create table bankuser (
  id                            integer auto_increment not null,
  bank_id                       integer not null,
  user_id                       integer not null,
  default_user                  varchar(35),
  order_number                  varchar(4),
  with_certs                    tinyint(1) default 0 not null,
  state                         integer not null,
  deactivated                   tinyint(1) default 0 not null,
  wss_activated                 tinyint(1) default 0 not null,
  signature_version             varchar(4),
  sig_key_length                integer,
  auth_key_length               integer,
  encr_key_length               integer,
  dtaus_reference_number        integer,
  bundesbank_file_number        integer,
  sepa_message_id               integer,
  mt101_sender_reference        integer,
  encr_key                      longblob,
  encr_cert                     longblob,
  auth_key                      longblob,
  auth_cert                     longblob,
  sig_key                       longblob,
  sig_cert                      longblob,
  lock_user_signature           longblob,
  ini_letter                    longblob,
  constraint uq_bankuser_1 unique (bank_id,user_id),
  constraint pk_bankuser primary key (id)
);

create table bank_user_htd_info (
  id                            integer auto_increment not null,
  bank_user_id                  integer,
  ebics_host_id                 varchar(35),
  name                          varchar(256),
  street                        varchar(256),
  post_code                     varchar(20),
  city                          varchar(256),
  region                        varchar(256),
  country                       varchar(256),
  user_id                       varchar(35),
  user_status                   integer,
  user_name                     varchar(256),
  htd_time                      datetime(6),
  constraint uq_bank_user_htd_info_bank_user_ unique (bank_user_id),
  constraint pk_bank_user_htd_info primary key (id)
);

create table cluster_node (
  id                            integer auto_increment not null,
  base_url                      varchar(255),
  secret                        varchar(20),
  primary_node                  tinyint(1) default 0 not null,
  constraint uq_cluster_node_base_url unique (base_url),
  constraint pk_cluster_node primary key (id)
);

create table cm_balance (
  id                            integer auto_increment not null,
  account_id                    integer,
  value_date                    date,
  value_balance                 decimal(38,3),
  value_balance_with_advice     decimal(38,3),
  constraint pk_cm_balance primary key (id)
);

create table cm_balance2 (
  id                            integer auto_increment not null,
  account_id                    integer,
  value_date                    date,
  value_balance                 decimal(38,3),
  value_balance_with_advice     decimal(38,3),
  constraint pk_cm_balance2 primary key (id)
);

create table cm_bank (
  id                            integer auto_increment not null,
  bank_id                       integer,
  statements_activated          tinyint(1) default 0 not null,
  advice_activated              tinyint(1) default 0 not null,
  credit_advice_activated       tinyint(1) default 0 not null,
  bka_activated                 tinyint(1) default 0 not null,
  bki_activated                 tinyint(1) default 0 not null,
  c54_activated                 tinyint(1) default 0 not null,
  cumulative_advice_provision   tinyint(1) default 0 not null,
  multidays_advice_repeated     tinyint(1) default 0 not null,
  statement_format              varchar(255),
  advice_format                 varchar(255),
  statement_fetch_type          varchar(255),
  advice_fetch_type             varchar(255),
  credit_advice_fetch_type      varchar(255),
  bka_fetch_type                varchar(255),
  bki_fetch_type                varchar(255),
  c54_fetch_type                varchar(255),
  last_sta_fetch                date,
  last_vmk_fetch                date,
  last_credit_advice_fetch      date,
  last_bka_fetch                date,
  last_bki_fetch                date,
  last_c54_fetch                date,
  sta_fetch_mode                integer,
  vmk_fetch_mode                integer,
  cav_fetch_mode                integer,
  bka_fetch_mode                integer,
  bki_fetch_mode                integer,
  c54_fetch_mode                integer,
  vb_calculation_with_cav       tinyint(1) default 0 not null,
  vb_calculation_with_pav       tinyint(1) default 0 not null,
  constraint uq_cm_bank_bank_id unique (bank_id),
  constraint pk_cm_bank primary key (id)
);

create table cm_booking (
  id                            integer auto_increment not null,
  statement_id                  integer not null,
  page_id                       integer,
  account_id                    integer not null,
  parent_booking_id             integer,
  pos                           integer,
  booking_date                  date,
  value_date                    date,
  local_party                   varchar(140),
  local_party_bank_code         varchar(30),
  local_party_account_number    varchar(40),
  local_party_creditor_id       varchar(35),
  local_party_mandate_reference varchar(35),
  ultimate_local_party          varchar(140),
  counter_party                 varchar(140),
  counter_party_bank_code       varchar(30),
  counter_party_account_number  varchar(40),
  counter_party_creditor_id     varchar(35),
  counter_party_mandate_ref     varchar(35),
  ultimate_counter_party        varchar(140),
  purpose                       varchar(400),
  purpose_code                  varchar(35),
  purpose_overview              varchar(140),
  sts                           varchar(4),
  amount                        decimal(38,3),
  currency_code                 varchar(3),
  original_amount               decimal(38,3),
  original_currency             varchar(3),
  settlement_amount             decimal(38,3),
  settlement_currency           varchar(3),
  charges_amount                decimal(38,3),
  charges_currency              varchar(3),
  fee_type                      varchar(3),
  converted_amount              decimal(38,3),
  converted_currency            varchar(3),
  exchange_rate                 decimal(38,3),
  exchange_rate_date            date,
  booking_key                   varchar(3),
  booking_text                  varchar(27),
  gvc                           varchar(3),
  primanota                     varchar(10),
  text_key_appendix             varchar(3),
  additional_information        varchar(500),
  bank_reference                varchar(35),
  customer_reference            varchar(35),
  customer_reference_date       date,
  end_to_end_id                 varchar(35),
  instr_id                      varchar(35),
  pmt_inf_id                    varchar(35),
  msg_id                        varchar(35),
  transaction_code              varchar(4),
  domain_code                   varchar(4),
  family_code                   varchar(4),
  sub_family_code               varchar(4),
  interbank_transaction_code    varchar(2),
  rejection_cause_code          varchar(4),
  entry_number                  varchar(7),
  exemption                     tinyint(1),
  unavailabilty_rating          tinyint(1),
  balance                       decimal(38,3),
  collective                    tinyint(1),
  debit                         tinyint(1),
  reversal                      tinyint(1),
  signed_payments               tinyint(1),
  transaction_id                varchar(35),
  ntry_ref                      varchar(35),
  count_transactions            integer,
  constraint pk_cm_booking primary key (id)
);

create table cm_b_filter (
  id                            integer auto_increment not null,
  user_id                       integer not null,
  filter_active                 tinyint(1),
  booking_date_from             date,
  booking_date_to               date,
  bd_comp                       integer,
  value_date_from               date,
  value_date_to                 date,
  vd_comp                       integer,
  text                          varchar(255),
  text_comp                     integer,
  amount_from                   decimal(38,3),
  amount_to                     decimal(38,3),
  amount_comp                   integer,
  booking_dir                   integer not null,
  booking_type                  integer,
  booking_type_text             varchar(3),
  constraint uq_cm_b_filter_user_id unique (user_id),
  constraint pk_cm_b_filter primary key (id)
);

create table cm_charge (
  id                            integer auto_increment not null,
  booking_id                    integer not null,
  statement_id                  integer,
  page_id                       integer,
  amount                        decimal(38,3),
  currency_code                 varchar(3),
  is_included                   tinyint(1) default 0 not null,
  bank_identification           varchar(140),
  type                          varchar(35),
  rate                          decimal(11,10),
  charge_bearer_type            varchar(4),
  tax_identification            varchar(35),
  tax_amount                    decimal(38,3),
  tax_currency_code             varchar(3),
  tax_rate                      decimal(11,10),
  constraint pk_cm_charge primary key (id)
);

create table cm_check (
  id                            integer auto_increment not null,
  login_id                      integer,
  statement_id                  integer,
  page_id                       integer,
  checked                       tinyint(1),
  constraint pk_cm_check primary key (id)
);

create table cm_folder (
  id                            integer auto_increment not null,
  name                          varchar(255),
  tenant_id                     integer not null,
  constraint uq_cm_folder_1 unique (name,tenant_id),
  constraint pk_cm_folder primary key (id)
);

create table cm_page (
  id                            integer auto_increment not null,
  statement_id                  integer,
  creation_date                 datetime(6),
  reference1                    varchar(255),
  reference2                    varchar(255),
  closing_date                  date,
  closing_balance               decimal(38,3),
  closing_final                 tinyint(1) default 0 not null,
  opening_date                  date,
  opening_balance               decimal(38,3),
  opening_final                 tinyint(1) default 0 not null,
  currency_code                 varchar(3),
  page_number                   integer,
  count_credit                  integer,
  count_debit                   integer,
  sum_credit                    decimal(38,3),
  sum_debit                     decimal(38,3),
  max_credit                    decimal(38,3),
  min_credit                    decimal(38,3),
  max_debit                     decimal(38,3),
  min_debit                     decimal(38,3),
  old                           tinyint(1) default 0 not null,
  file_id                       integer,
  constraint pk_cm_page primary key (id)
);

create table cm_pdf_statement (
  id                            integer auto_increment not null,
  type                          integer not null,
  bank_id                       integer,
  account_id                    integer,
  statement_date                date,
  statement_number              integer,
  zip_file_name                 varchar(255),
  local_file_id                 integer,
  constraint pk_cm_pdf_statement primary key (id)
);

create table cm_statement (
  id                            integer auto_increment not null,
  account_id                    integer,
  creation_date                 datetime(6),
  reference1                    varchar(255),
  reference2                    varchar(255),
  opening_date                  date,
  opening_balance               decimal(38,3),
  opening_final                 tinyint(1) default 0 not null,
  closing_date                  date,
  closing_balance               decimal(38,3),
  closing_final                 tinyint(1) default 0 not null,
  currency_code                 varchar(3),
  statement_number              integer,
  page_number                   integer,
  legal_number                  integer,
  unique_id                     varchar(255),
  count_credit                  integer,
  count_debit                   integer,
  sum_credit                    decimal(38,3),
  sum_debit                     decimal(38,3),
  max_credit                    decimal(38,3),
  min_credit                    decimal(38,3),
  max_debit                     decimal(38,3),
  min_debit                     decimal(38,3),
  type                          integer not null,
  original_filename             varchar(255),
  additional_information        varchar(500),
  file_id                       integer,
  constraint uq_cm_statement_1 unique (account_id,unique_id),
  constraint pk_cm_statement primary key (id)
);

create table cm_value_group (
  id                            integer auto_increment not null,
  name                          varchar(255),
  tenant_id                     integer not null,
  constraint pk_cm_value_group primary key (id)
);

create table cm_value_group_account (
  cm_value_group_id             integer not null,
  account_id                    integer not null,
  constraint pk_cm_value_group_account primary key (cm_value_group_id,account_id)
);

create table cm_value_group_folder (
  cm_value_group_id             integer not null,
  cm_folder_id                  integer not null,
  constraint pk_cm_value_group_folder primary key (cm_value_group_id,cm_folder_id)
);

create table conversion (
  id                            integer auto_increment not null,
  name                          varchar(255),
  type                          integer,
  include_header                tinyint(1) default 0 not null,
  field_separator               varchar(255),
  text_separator                varchar(255),
  date_format                   varchar(255),
  number_format                 varchar(255),
  fields                        varchar(500),
  tenant_id                     integer not null,
  constraint pk_conversion primary key (id)
);

create table sepa_converter_format (
  id                            integer auto_increment not null,
  tpe                           integer,
  encoding                      varchar(25),
  field_separator               varchar(5),
  has_header                    tinyint(1),
  country_code                  varchar(2),
  format                        longtext,
  tenant_id                     integer not null,
  constraint pk_sepa_converter_format primary key (id)
);

create table directory_scanner (
  id                            integer auto_increment not null,
  directory                     varchar(255) not null,
  bank_id                       integer,
  reg_ex                        varchar(255),
  archive_directory             varchar(255),
  error_directory               varchar(255),
  order_or_file_type            varchar(255),
  signature                     tinyint(1),
  constraint pk_directory_scanner primary key (id)
);

create table ds_bank (
  id                            integer auto_increment not null,
  bank_id                       integer,
  activated                     tinyint(1) default 0 not null,
  hvz                           tinyint(1) default 0 not null,
  constraint uq_ds_bank_bank_id unique (bank_id),
  constraint pk_ds_bank primary key (id)
);

create table ds_open_order (
  id                            integer auto_increment not null,
  bank_user_id                  integer,
  file_type                     varchar(50) not null,
  pmt_type                      integer,
  order_id                      varchar(4) not null,
  submission_date               datetime(6) not null,
  customer_id                   varchar(35) not null,
  user_id                       varchar(35),
  user_name                     varchar(80),
  amount                        decimal(38,3),
  amount_currency               varchar(3),
  datasize                      bigint,
  originator                    varchar(140),
  digest_hex                    varchar(80),
  is_signable                   tinyint(1) default 0 not null,
  is_order_data_available       tinyint(1) default 0 not null,
  is_payment_data_available     tinyint(1) default 0 not null,
  num_sig_done                  integer not null,
  num_sig_required              integer not null,
  ticket                        longblob,
  order_data_id                 integer,
  payment_data_id               integer,
  additional_order_info         varchar(255),
  constraint pk_ds_open_order primary key (id)
);

create table ds_open_order_signer (
  id                            integer auto_increment not null,
  ds_open_order_id              integer,
  sign_date                     datetime(6) not null,
  customer_id                   varchar(35) not null,
  user_id                       varchar(35),
  user_name                     varchar(80),
  permission                    varchar(1) not null,
  constraint pk_ds_open_order_signer primary key (id)
);

create table ds_order_details (
  id                            integer auto_increment not null,
  bank_id                       integer,
  pmt_type                      integer,
  file_type                     varchar(50) not null,
  order_id                      varchar(4) not null,
  filename                      varchar(256),
  submission_date               datetime(6) not null,
  customer_id                   varchar(35) not null,
  user_id                       varchar(35),
  user_name                     varchar(40),
  num_sig_done                  integer,
  num_sig_required              integer,
  amount                        decimal(38,3),
  amount_currency               varchar(3),
  datasize                      bigint,
  ticket                        longblob,
  data_file_id                  integer,
  state                         integer,
  error_code                    varchar(4),
  additional_order_info         varchar(255),
  tp                            integer,
  constraint pk_ds_order_details primary key (id)
);

create table ds_order_details_account (
  ds_order_details_id           integer not null,
  account_id                    integer not null,
  constraint pk_ds_order_details_account primary key (ds_order_details_id,account_id)
);

create table ds_signing_info (
  id                            integer auto_increment not null,
  ds_order_details_id           integer not null,
  customer_id                   varchar(35) not null,
  user_id                       varchar(35) not null,
  user_name                     varchar(256),
  sign_date                     datetime(6) not null,
  ip_address                    varchar(255),
  permission                    varchar(1) not null,
  constraint pk_ds_signing_info primary key (id)
);

create table export_file (
  id                            integer auto_increment not null,
  workspace_file_id             integer,
  last_update                   datetime(6),
  constraint pk_export_file primary key (id)
);

create table export_file_account (
  export_file_id                integer not null,
  account_id                    integer not null,
  constraint pk_export_file_account primary key (export_file_id,account_id)
);

create table export_file_aut_export (
  export_file_id                integer not null,
  automatic_export_id           integer not null,
  constraint pk_export_file_aut_export primary key (export_file_id,automatic_export_id)
);

create table exportfile_filter (
  id                            integer auto_increment not null,
  user_id                       integer not null,
  from_date                     date,
  to_date                       date,
  date_comp                     integer,
  export_file_active            tinyint(1) default 0 not null,
  automatic_export_id           integer,
  file_name                     varchar(255),
  file_name_comp                integer not null,
  constraint pk_exportfile_filter primary key (id)
);

create table fetch_item (
  id                            integer auto_increment not null,
  bank_id                       integer,
  fetched                       datetime(6) not null,
  file_id                       integer,
  file_type                     varchar(255),
  order_type                    varchar(3) not null,
  error                         longtext,
  from_date                     date,
  to_date                       date,
  fetcher                       varchar(255),
  constraint pk_fetch_item primary key (id)
);

create table fe_filter (
  id                            integer auto_increment not null,
  user_id                       integer not null,
  from_date                     date,
  to_date                       date,
  date_comp                     integer,
  order_type                    varchar(255),
  order_type_comp               integer not null,
  bank_id                       integer,
  bank_comp                     integer not null,
  fetch_active                  tinyint(1) default 0 not null,
  fetcher                       varchar(255),
  fetcher_comp                  integer,
  constraint pk_fe_filter primary key (id)
);

create table hac_entry (
  id                            integer auto_increment not null,
  bank_id                       integer,
  hac_time                      datetime(6) not null,
  axn                           integer,
  customer_id                   varchar(35),
  user_id                       varchar(35),
  reason                        varchar(4),
  order_number                  varchar(4),
  order_type                    varchar(3),
  file_type                     varchar(255),
  additional_information        longtext,
  constraint pk_hac_entry primary key (id)
);

create table hac_filter (
  id                            integer auto_increment not null,
  user_id                       integer not null,
  from_date                     date,
  to_date                       date,
  date_comp                     integer,
  order_type                    varchar(255),
  order_type_comp               integer not null,
  order_nr                      varchar(255),
  order_nr_comp                 integer not null,
  axn                           integer,
  customer_id                   varchar(35),
  bank_user_id                  varchar(35),
  reason                        varchar(4),
  constraint pk_hac_filter primary key (id)
);

create table license (
  id                            varchar(11) not null,
  content                       longblob,
  constraint pk_license primary key (id)
);

create table log (
  id                            integer auto_increment not null,
  log_time                      datetime(6),
  tenant_id                     integer,
  account_id                    integer,
  actor_id                      integer not null,
  message_name                  varchar(255),
  message_en                    varchar(500),
  message_de                    varchar(500),
  pmt_type                      integer,
  parameter                     longblob,
  constraint pk_log primary key (id)
);

create table log_filter (
  id                            integer auto_increment not null,
  user_id                       integer not null,
  active                        tinyint(1),
  type                          varchar(255),
  account_id                    integer,
  filter_user_id                integer,
  from_date                     date,
  to_date                       date,
  date_comp                     integer,
  constraint uq_log_filter_user_id unique (user_id),
  constraint pk_log_filter primary key (id)
);

create table login_session (
  id                            integer auto_increment not null,
  user_id                       integer not null,
  active                        tinyint(1) default 0 not null,
  session_activity              datetime(6) not null,
  constraint pk_login_session primary key (id)
);

create table notification (
  id                            integer auto_increment not null,
  bank_id                       integer,
  fetched                       datetime(6) not null,
  type                          integer not null,
  file_id                       integer,
  file_type                     varchar(255),
  order_type                    varchar(3),
  send_id                       integer,
  order_info                    varchar(255),
  orgnl_msg_id                  varchar(35),
  orgnl_msg_nm_id               varchar(255),
  orgnl_nb_of_txs               integer,
  orgnl_ctrl_sum                decimal(38,3),
  grp_sts                       varchar(4),
  nb_of_rjct                    integer,
  constraint pk_notification primary key (id)
);

create table nf_filter (
  id                            integer auto_increment not null,
  user_id                       integer not null,
  from_date                     date,
  to_date                       date,
  date_comp                     integer,
  order_type                    varchar(255),
  order_type_comp               integer not null,
  bank_id                       integer,
  bank_comp                     integer not null,
  notification_active           tinyint(1) default 0 not null,
  constraint pk_nf_filter primary key (id)
);

create table notification_pmt_inf (
  id                            integer auto_increment not null,
  notification_id               integer,
  orgnl_pmt_inf_id              varchar(35),
  orgnl_nb_of_txs               integer,
  orgnl_ctrl_sum                decimal(38,3),
  pmt_inf_sts                   varchar(4),
  constraint pk_notification_pmt_inf primary key (id)
);

create table nf_setting (
  id                            integer auto_increment not null,
  bank_id                       integer,
  active                        tinyint(1) default 0 not null,
  credit_notifications          tinyint(1) default 0 not null,
  debit_notifications           tinyint(1) default 0 not null,
  instant_notifications         tinyint(1) default 0 not null,
  foreign_notifications         tinyint(1) default 0 not null,
  vop_notifications             tinyint(1) default 0 not null,
  callback_notifications        tinyint(1) default 0 not null,
  bundesbank                    tinyint(1) default 0 not null,
  credit_fetch_type             varchar(255),
  debit_fetch_type              varchar(255),
  instant_fetch_type            varchar(255),
  foreign_fetch_type            varchar(255),
  vop_fetch_type                varchar(255),
  callback_fetch_type           varchar(255),
  fetch_mode                    integer,
  last_fetch                    date,
  constraint uq_nf_setting_bank_id unique (bank_id),
  constraint pk_nf_setting primary key (id)
);

create table notification_trx (
  id                            integer auto_increment not null,
  notification_id               integer,
  pmt_inf_id                    integer,
  send_id                       integer,
  signed_payment_id             integer,
  orgnl_instr_id                varchar(255),
  orgnl_end_to_end_id           varchar(255),
  tx_sts                        varchar(4),
  originator                    varchar(70),
  originator_account_number     varchar(40),
  originator_bank_code          varchar(34),
  recipient                     varchar(70),
  recipient_account_number      varchar(40),
  recipient_bank_code           varchar(34),
  amount                        decimal(38,3),
  amount_currency               varchar(3),
  purpose                       varchar(140),
  execution_date                datetime(6),
  status_reason_info            longtext,
  creditor_id                   varchar(35),
  mandate_id                    varchar(35),
  mandate_sign_date             date,
  constraint pk_notification_trx primary key (id)
);

create table open_id_token (
  id                            integer auto_increment not null,
  user_id                       integer,
  id_token                      longblob,
  access_token                  longblob,
  refresh_token                 longblob,
  constraint pk_open_id_token primary key (id)
);

create table pmt_open (
  id                            integer auto_increment not null,
  business_id                   integer,
  created_user_id               integer not null,
  created                       datetime(6) not null,
  confirmed_user_id             integer,
  confirmed                     datetime(6),
  version                       integer not null,
  locking_user_id               integer,
  deleted                       tinyint(1) default 0 not null,
  bank_id                       integer not null,
  account_id                    integer,
  pmt_type                      integer,
  order_type                    varchar(3),
  file_type                     varchar(50),
  is_credit                     tinyint(1),
  is_urgent                     tinyint(1),
  originator                    varchar(70),
  recipient                     varchar(70),
  amount                        decimal(38,3),
  amount_currency               varchar(3),
  purpose                       varchar(140),
  execution_date                datetime(6),
  payment_data                  longblob,
  folder_id                     integer,
  salary_payment                tinyint(1),
  constraint pk_pmt_open primary key (id)
);

create table order_type (
  id                            integer auto_increment not null,
  bank_id                       integer,
  transfer_type                 integer not null,
  order_type                    varchar(3),
  file_format                   varchar(50),
  order_format                  varchar(8),
  num_sig_required              integer,
  description                   varchar(255),
  constraint pk_order_type primary key (id)
);

create table password_history (
  id                            integer auto_increment not null,
  user_id                       integer not null,
  change_date                   datetime(6),
  hash_value                    varchar(64),
  constraint pk_password_history primary key (id)
);

create table pmt_xchgrate (
  id                            integer auto_increment not null,
  currency_code                 varchar(3) not null,
  exchange_rate                 decimal(38,10) not null,
  rate_time                     datetime(6),
  constraint uq_pmt_xchgrate_currency_code unique (currency_code),
  constraint pk_pmt_xchgrate primary key (id)
);

create table pmt_filter (
  id                            integer auto_increment not null,
  user_id                       integer not null,
  pmt_open_active               tinyint(1),
  pmt_signed_active             tinyint(1),
  pmt_template_active           tinyint(1),
  pmt_periodic_active           tinyint(1),
  pmt_type                      integer,
  pmt_type_comp                 integer,
  account_id                    integer,
  filter_user_id                integer,
  text                          varchar(255),
  text_comp                     integer,
  amount_from                   decimal(38,3),
  amount_to                     decimal(38,3),
  amount_comp                   integer,
  from_exec_date                date,
  to_exec_date                  date,
  exec_date_comp                integer,
  state                         integer,
  constraint uq_pmt_filter_user_id unique (user_id),
  constraint pk_pmt_filter primary key (id)
);

create table pmt_folder (
  id                            integer auto_increment not null,
  name                          varchar(255),
  tenant_id                     integer not null,
  constraint pk_pmt_folder primary key (id)
);

create table pmt_originator (
  id                            integer auto_increment not null,
  name                          varchar(255),
  tenant_id                     integer not null,
  default_account_id            integer,
  payment_type                  integer not null,
  originator_info               longtext,
  constraint pk_pmt_originator primary key (id)
);

create table pmt_props (
  id                            integer auto_increment not null,
  bank_id                       integer not null,
  dtazv_separat                 tinyint(1),
  mt101_separat                 tinyint(1),
  mt101_save_acc_currency       tinyint(1),
  sepa_dbt_ldtime               integer,
  sepa_cdt_ftype                varchar(50),
  sepa_coredbt_ftype            varchar(50),
  sepa_b2bdbt_ftype             varchar(50),
  sepa_max_exec_date            integer default 15 not null,
  sepa_max_urgt_pmnts           integer,
  cfonb160_sender               varchar(6),
  cfonb160_allowxpf             tinyint(1),
  cfonb320_custid               varchar(16),
  mt101swift_header             tinyint(1),
  constraint uq_pmt_props_bank_id unique (bank_id),
  constraint pk_pmt_props primary key (id)
);

create table pmt_recipient (
  id                            integer auto_increment not null,
  business_id                   integer,
  created_user_id               integer not null,
  created                       datetime(6) not null,
  confirmed_user_id             integer,
  confirmed                     datetime(6),
  version                       integer not null,
  locking_user_id               integer,
  deleted                       tinyint(1) default 0 not null,
  payment_type                  integer not null,
  tenant_id                     integer not null,
  display_name                  varchar(128),
  name                          varchar(70),
  account_number                varchar(40),
  bank_code                     varchar(34),
  bank_name                     varchar(128),
  purpose                       varchar(400),
  reference                     varchar(35),
  sepa_mandate_id               varchar(35),
  recipient_info                longtext,
  vop_name                      varchar(70),
  vop_result                    varchar(4),
  vop_reason                    varchar(4),
  vop_additional_info           varchar(210),
  vop_date                      datetime(6),
  last_usage                    datetime(6),
  constraint pk_pmt_recipient primary key (id)
);

create table recip_filter (
  id                            integer auto_increment not null,
  user_id                       integer not null,
  payment_type                  integer,
  payment_type_comp             integer,
  vop_result                    varchar(4),
  vop_result_comp               integer,
  text                          varchar(255),
  text_comp                     integer,
  from_last_usage               date,
  to_last_usage                 date,
  last_usage_comp               integer,
  constraint uq_recip_filter_user_id unique (user_id),
  constraint pk_recip_filter primary key (id)
);

create table pmt_template (
  id                            integer auto_increment not null,
  bank_id                       integer not null,
  name                          varchar(80),
  account_id                    integer,
  pmt_type                      integer,
  order_type                    varchar(3),
  file_type                     varchar(50),
  is_credit                     tinyint(1),
  is_urgent                     tinyint(1),
  originator                    varchar(70),
  recipient                     varchar(70),
  amount                        decimal(38,3),
  amount_currency               varchar(3),
  payment_data                  longblob,
  folder_id                     integer,
  generic_purpose               varchar(150),
  salary_payment                tinyint(1),
  constraint pk_pmt_template primary key (id)
);

create table pmt_transfer_type (
  id                            integer auto_increment not null,
  bank_id                       integer not null,
  pmt_type                      integer,
  order_type                    varchar(50),
  btf                           varchar(50),
  order_type_vop                varchar(50),
  btf_vop                       varchar(50),
  format                        varchar(50),
  constraint pk_pmt_transfer_type primary key (id)
);

create table pdfstatements_filter (
  id                            integer auto_increment not null,
  user_id                       integer not null,
  from_date                     date,
  to_date                       date,
  date_comp                     integer,
  order_type                    varchar(255),
  order_type_comp               integer not null,
  bank_id                       integer,
  bank_comp                     integer not null,
  statement_active              tinyint(1) default 0 not null,
  account_id                    integer,
  type                          integer,
  constraint pk_pdfstatements_filter primary key (id)
);

create table pmt_periodic (
  id                            integer auto_increment not null,
  business_id                   integer,
  created_user_id               integer not null,
  created                       datetime(6) not null,
  confirmed_user_id             integer,
  confirmed                     datetime(6),
  version                       integer not null,
  locking_user_id               integer,
  deleted                       tinyint(1) default 0 not null,
  bank_id                       integer not null,
  account_id                    integer,
  pmt_type                      integer,
  order_type                    varchar(3),
  file_type                     varchar(50),
  is_credit                     tinyint(1),
  is_urgent                     tinyint(1),
  originator                    varchar(70),
  recipient                     varchar(70),
  amount                        decimal(38,3),
  amount_currency               varchar(3),
  purpose                       varchar(140),
  exec_ival                     integer not null,
  first_execution_date          date,
  last_execution_date           date,
  previous_execution_date       date,
  next_execution_date           date,
  payment_data                  longblob,
  generic_purpose               varchar(150),
  folder_id                     integer,
  salary_payment                tinyint(1),
  constraint pk_pmt_periodic primary key (id)
);

create table preference (
  id                            integer auto_increment not null,
  application_id                integer not null,
  pref_key                      varchar(80) not null,
  pref_value                    varchar(255),
  user_id                       integer,
  tenant_id                     integer,
  constraint uq_preference_1 unique (application_id,pref_key,user_id),
  constraint pk_preference primary key (id)
);

create table protocol_setting (
  id                            integer auto_increment not null,
  bank_id                       integer,
  active                        tinyint(1) default 0 not null,
  protocol_type                 integer(3),
  last_protocol_fetch           date,
  constraint uq_protocol_setting_bank_id unique (bank_id),
  constraint pk_protocol_setting primary key (id)
);

create table ptk_entry (
  id                            integer auto_increment not null,
  bank_id                       integer,
  ptk_time                      datetime(6) not null,
  axn                           integer not null,
  result                        integer,
  order_number                  varchar(4),
  order_type                    varchar(3),
  data                          longtext not null,
  constraint pk_ptk_entry primary key (id)
);

create table ptk_filter (
  id                            integer auto_increment not null,
  user_id                       integer not null,
  from_date                     date,
  to_date                       date,
  date_comp                     integer,
  order_type                    varchar(255),
  order_type_comp               integer not null,
  order_nr                      varchar(255),
  order_nr_comp                 integer not null,
  axn                           integer,
  result                        integer,
  constraint pk_ptk_filter primary key (id)
);

create table rsapubkey (
  id                            integer auto_increment not null,
  exponent                      longblob,
  modulo                        longblob,
  cert                          longblob,
  constraint pk_rsapubkey primary key (id)
);

create table scheduler (
  id                            integer auto_increment not null,
  bank_id                       integer not null,
  login_user_id                 integer,
  order_or_file_type            varchar(255),
  days                          varchar(255),
  month                         varchar(255),
  hour                          varchar(255),
  minute                        varchar(255),
  year                          varchar(255),
  last_fetch                    datetime(6),
  parameter                     varchar(255),
  s_interval                    integer,
  error                         longtext,
  constraint pk_scheduler primary key (id)
);

create table scl_directory (
  bic                           varchar(11) not null,
  name                          varchar(140),
  sct                           tinyint(1),
  sdd                           tinyint(1),
  cor1                          tinyint(1),
  b2b                           tinyint(1),
  scc                           tinyint(1),
  valid_date                    date,
  constraint pk_scl_directory primary key (bic)
);

create table send_item (
  id                            integer auto_increment not null,
  bank_id                       integer,
  sent                          datetime(6) not null,
  file_id                       integer,
  orig_file_name                varchar(250),
  state                         integer,
  sts                           varchar(4),
  cncl_sts                      varchar(4),
  vop_sts                       varchar(4),
  error_code                    varchar(4),
  sender                        varchar(255),
  pmt_type                      integer,
  file_type                     varchar(255),
  order_type                    varchar(3) not null,
  order_number                  varchar(4) not null,
  amount                        decimal(38,3),
  nb_of_txs                     integer,
  signature_hash                varchar(64),
  msg_id                        varchar(35),
  scheme                        varchar(255),
  additional_order_info         varchar(255),
  currency                      varchar(3),
  with_selaries                 tinyint(1),
  manual_approval               tinyint(1),
  callback_id                   integer,
  ip_address                    varchar(255),
  signed_payments               integer,
  constraint pk_send_item primary key (id)
);

create table send_item_account (
  send_item_id                  integer not null,
  account_id                    integer not null,
  constraint pk_send_item_account primary key (send_item_id,account_id)
);

create table send_filter (
  id                            integer auto_increment not null,
  user_id                       integer not null,
  bank_id                       integer,
  account_id                    integer,
  send_active                   tinyint(1) default 0 not null,
  ds_signed_active              tinyint(1) default 0 not null,
  ds_cncl_active                tinyint(1) default 0 not null,
  ds_active                     tinyint(1) default 0 not null,
  bank_comp                     integer not null,
  ds_overview_signed            tinyint(1),
  pmt_type                      integer,
  pmt_type_comp                 integer,
  order_type                    varchar(255),
  order_type_comp               integer not null,
  order_nr                      varchar(255),
  order_nr_comp                 integer not null,
  sender                        varchar(255),
  sender_comp                   integer,
  send_state                    integer,
  ds_state                      integer,
  state_comp                    integer not null,
  from_date                     date,
  to_date                       date,
  date_comp                     integer,
  from_amount                   decimal(38,3),
  to_amount                     decimal(38,3),
  amount_comp                   integer,
  constraint pk_send_filter primary key (id)
);

create table pmt_signed (
  id                            integer auto_increment not null,
  account_id                    integer,
  folder_id                     integer,
  send_id                       integer not null,
  booking_id                    integer,
  logical_file                  integer,
  payment_number                integer,
  callback_id                   integer,
  pmt_type                      integer,
  is_credit                     tinyint(1),
  is_urgent                     tinyint(1),
  originator                    varchar(70),
  recipient                     varchar(70),
  amount                        decimal(38,3),
  salary_amount                 decimal(38,3),
  amount_currency               varchar(3),
  purpose                       varchar(140),
  execution_date                datetime(6),
  reference                     varchar(50),
  manual_payment                tinyint(1),
  salary_payment                tinyint(1),
  pmt_inf_id                    varchar(35),
  state                         integer,
  sts                           varchar(4),
  status_reason_info            longtext,
  cncl_sts                      varchar(4),
  vop_sts                       varchar(4),
  payment_data                  longblob,
  constraint pk_pmt_signed primary key (id)
);

create table simple_text_filter (
  id                            integer auto_increment not null,
  user_id                       integer not null,
  filter_view                   varchar(255) not null,
  filter_text                   varchar(255),
  filter_active                 tinyint(1) default 0 not null,
  constraint pk_simple_text_filter primary key (id)
);

create table sorting (
  id                            integer auto_increment not null,
  user_id                       integer,
  table_id                      varchar(255),
  sorting_column                integer,
  sort_ascending                tinyint(1),
  column_order                  varchar(255),
  column_sizes                  varchar(255),
  page_size                     integer,
  additional_information        longtext,
  constraint pk_sorting primary key (id)
);

create table tenant (
  id                            integer auto_increment not null,
  name                          varchar(256) not null,
  user_count                    integer,
  uuid                          varchar(40),
  admins_uuid                   varchar(40),
  deleted                       tinyint(1) default 0 not null,
  constraint uq_tenant_name unique (name),
  constraint pk_tenant primary key (id)
);

create table pmt_urgnt_rcpnt (
  id                            integer auto_increment not null,
  bank_id                       integer not null,
  orgntr_acct_number            varchar(34),
  orgntr_bank_code              varchar(11),
  rcpnt_acct_number             varchar(34),
  rcpnt_bank_code               varchar(11),
  rcpnt_name                    varchar(35),
  rcpnt_tp                      integer,
  constraint pk_pmt_urgnt_rcpnt primary key (id)
);

create table loginuser (
  id                            integer auto_increment not null,
  name                          varchar(256) not null,
  is_admin                      tinyint(1) default 0 not null,
  security_medium               integer not null,
  enc_key                       longblob not null,
  key_dir                       varchar(256),
  iccsn                         varchar(50),
  driver                        varchar(2048),
  alias                         varchar(256),
  serial_number                 varchar(50),
  proxy_password                longblob,
  proxy_user                    varchar(256),
  system_name                   varchar(255),
  license_id                    varchar(11),
  web_license_id                varchar(11),
  error_counter                 integer,
  error_sign_counter            integer,
  last_login                    datetime(6),
  last_login_error              datetime(6),
  last_password_change          date,
  random_id                     varchar(128),
  challenge                     varchar(300),
  last_des_fetch                datetime(6),
  given_name                    varchar(256),
  family_name                   varchar(256),
  email                         varchar(256),
  uuid                          varchar(40),
  deleted                       tinyint(1) default 0 not null,
  constraint pk_loginuser primary key (id)
);

create table loginuser_tenant (
  loginuser_id                  integer not null,
  tenant_id                     integer not null,
  constraint pk_loginuser_tenant primary key (loginuser_id,tenant_id)
);

create table loginuser_managed_tenant (
  loginuser_id                  integer not null,
  tenant_id                     integer not null,
  constraint pk_loginuser_managed_tenant primary key (loginuser_id,tenant_id)
);

create table user_effective_permission (
  id                            integer auto_increment not null,
  bank_user_id                  integer not null,
  account_id                    integer not null,
  pmt_type                      integer not null,
  constraint pk_user_effective_permission primary key (id)
);

create table user_notification (
  id                            integer auto_increment not null,
  user_id                       integer,
  t                             integer,
  info                          longblob,
  constraint pk_user_notification primary key (id)
);

create table user_permission (
  id                            integer auto_increment not null,
  bank_user_id                  integer not null,
  order_type_id                 integer,
  auth_level                    integer,
  max_amount                    decimal(38,4),
  max_amount_currency           varchar(3),
  account_permission_id         integer,
  constraint pk_user_permission primary key (id)
);

create table web_authn (
  id                            integer auto_increment not null,
  yubikey_id                    integer,
  counter                       bigint,
  rp_id                         varchar(255),
  serialized_data               longblob,
  constraint uq_web_authn_yubikey_id unique (yubikey_id),
  constraint pk_web_authn primary key (id)
);

create table workspace_file (
  id                            integer auto_increment not null,
  prefix_id                     integer not null,
  deleted                       tinyint(1) default 0 not null,
  path                          varchar(256) not null,
  file_size                     bigint,
  md5hash                       varchar(32),
  sha256hash                    varchar(64),
  constraint pk_workspace_file primary key (id)
);

create table workspace_file_cluster_node (
  workspace_file_id             integer not null,
  cluster_node_id               integer not null,
  constraint pk_workspace_file_cluster_node primary key (workspace_file_id,cluster_node_id)
);

create table yubikey (
  id                            integer auto_increment not null,
  user_id                       integer,
  public_id                     varchar(2048),
  description                   varchar(255),
  used_since                    date,
  security_type                 integer,
  constraint pk_yubikey primary key (id)
);

create table yubikey_history (
  id                            integer auto_increment not null,
  user_id                       integer,
  public_id                     varchar(2048),
  opt                           varchar(2048),
  error_message                 varchar(255),
  time_stamp                    datetime(6),
  constraint pk_yubikey_history primary key (id)
);

create table zip_filter (
  id                            integer auto_increment not null,
  position                      integer default 0 not null,
  scheduler_id                  integer not null,
  reg_ex_pattern                varchar(255),
  folder                        varchar(255),
  constraint pk_zip_filter primary key (id)
);

create index ix_account_cm_identification on account (bank_id,cm_identification);
create index ix_account_iban on account (bank_id,iban,currency);
create index ix_account_iban_bic on account (bank_id,iban,bic,currency);
create index ix_account_german on account (bank_id,de_bank_code,de_account_number,currency);
create index ix_account_french on account (bank_id,fr_bank_code,fr_branch_code,fr_account_number,currency);
create index ix_awv_entry_report_month on awv_entry (month);
create index ix_cm_booking_statement_pos on cm_booking (statement_id,pos);
create index ix_cm_booking_account_msg_id on cm_booking (account_id,msg_id);
create index ix_notification_trx_status_recipient_account on notification_trx (tx_sts,recipient,recipient_account_number);
create index ix_pmt_open_order_type on pmt_open (order_type);
create index ix_pmt_open_file_type on pmt_open (file_type);
create index ix_pmt_recipient_display_name on pmt_recipient (payment_type,display_name);
create index ix_pmt_recipient_name on pmt_recipient (payment_type,name);
create index ix_pmt_template_order_type on pmt_template (order_type);
create index ix_pmt_template_file_type on pmt_template (file_type);
create index ix_pmt_periodic_order_type on pmt_periodic (order_type);
create index ix_pmt_periodic_file_type on pmt_periodic (file_type);
create index ix_send_item_bank_msg_id on send_item (bank_id,msg_id);
create index ix_pmt_signed_execution_date on pmt_signed (execution_date,account_id);
create index ix_workspace_file_prefix_id_path on workspace_file (prefix_id,path);
create index ix_account_bank_1 on account (bank_id);
alter table account add constraint fk_account_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_account_sepa_originator_id on account (sepa_originator_id);
alter table account add constraint fk_account_sepa_originator_id foreign key (sepa_originator_id) references pmt_originator (id) on delete restrict on update restrict;

create index ix_account_dtazv_originator_id on account (dtazv_originator_id);
alter table account add constraint fk_account_dtazv_originator_id foreign key (dtazv_originator_id) references pmt_originator (id) on delete restrict on update restrict;

create index ix_account_mt101_originator_id on account (mt101_originator_id);
alter table account add constraint fk_account_mt101_originator_id foreign key (mt101_originator_id) references pmt_originator (id) on delete restrict on update restrict;

create index ix_account_folder_1 on account (folder_id);
alter table account add constraint fk_account_folder_1 foreign key (folder_id) references cm_folder (id) on delete restrict on update restrict;

create index ix_account_permission_bankUser_1 on account_permission (bank_user_id);
alter table account_permission add constraint fk_account_permission_bankUser_1 foreign key (bank_user_id) references bankuser (id) on delete restrict on update restrict;

create index ix_account_permission_account_1 on account_permission (account_id);
alter table account_permission add constraint fk_account_permission_account_1 foreign key (account_id) references account (id) on delete restrict on update restrict;

create index ix_ap_overwrite_bankUser_1 on ap_overwrite (bank_user_id);
alter table ap_overwrite add constraint fk_ap_overwrite_bankUser_1 foreign key (bank_user_id) references bankuser (id) on delete restrict on update restrict;

create index ix_ap_overwrite_account_1 on ap_overwrite (account_id);
alter table ap_overwrite add constraint fk_ap_overwrite_account_1 foreign key (account_id) references account (id) on delete restrict on update restrict;

create index ix_automatic_export_conversion_1 on automatic_export (conversion_id);
alter table automatic_export add constraint fk_automatic_export_conversion_1 foreign key (conversion_id) references conversion (id) on delete restrict on update restrict;

create index ix_automatic_export_tenant_1 on automatic_export (tenant_id);
alter table automatic_export add constraint fk_automatic_export_tenant_1 foreign key (tenant_id) references tenant (id) on delete restrict on update restrict;

create index ix_automatic_export_account_automatic_export on automatic_export_account (automatic_export_id);
alter table automatic_export_account add constraint fk_automatic_export_account_a_01 foreign key (automatic_export_id) references automatic_export (id) on delete restrict on update restrict;

create index ix_automatic_export_account_account on automatic_export_account (account_id);
alter table automatic_export_account add constraint fk_automatic_export_account_a_02 foreign key (account_id) references account (id) on delete restrict on update restrict;

create index ix_automatic_export_folder_automatic_export on automatic_export_folder (automatic_export_id);
alter table automatic_export_folder add constraint fk_automatic_export_folder_automatic_export foreign key (automatic_export_id) references automatic_export (id) on delete restrict on update restrict;

create index ix_automatic_export_folder_cm_folder on automatic_export_folder (cm_folder_id);
alter table automatic_export_folder add constraint fk_automatic_export_folder_cm_folder foreign key (cm_folder_id) references cm_folder (id) on delete restrict on update restrict;

create index ix_awv_dika_abstractEntry_1 on awv_dika (abstract_entry_id);
alter table awv_dika add constraint fk_awv_dika_abstractEntry_1 foreign key (abstract_entry_id) references awv_entry (id) on delete restrict on update restrict;

create index ix_awv_dirinv_abstractEntry_1 on awv_dirinv (abstract_entry_id);
alter table awv_dirinv add constraint fk_awv_dirinv_abstractEntry_1 foreign key (abstract_entry_id) references awv_entry (id) on delete restrict on update restrict;

create index ix_awv_entry_entryReporter_1 on awv_entry (reporter);
alter table awv_entry add constraint fk_awv_entry_entryReporter_1 foreign key (reporter) references awv_contact (id) on delete restrict on update restrict;

create index ix_awv_entry_tenant_1 on awv_entry (tenant_id);
alter table awv_entry add constraint fk_awv_entry_tenant_1 foreign key (tenant_id) references tenant (id) on delete restrict on update restrict;

create index ix_awv_entry_signedPayment_1 on awv_entry (signed_payment_id);
alter table awv_entry add constraint fk_awv_entry_signedPayment_1 foreign key (signed_payment_id) references pmt_signed (id) on delete restrict on update restrict;

create index ix_awv_entry_cmBooking_1 on awv_entry (cm_booking_id);
alter table awv_entry add constraint fk_awv_entry_cmBooking_1 foreign key (cm_booking_id) references cm_booking (id) on delete restrict on update restrict;

create index ix_awv_export_tenant_1 on awv_export (tenant_id);
alter table awv_export add constraint fk_awv_export_tenant_1 foreign key (tenant_id) references tenant (id) on delete restrict on update restrict;

create index ix_awv_company_tenant_1 on awv_company (tenant_id);
alter table awv_company add constraint fk_awv_company_tenant_1 foreign key (tenant_id) references tenant (id) on delete restrict on update restrict;

create index ix_awv_contact_company_1 on awv_contact (company);
alter table awv_contact add constraint fk_awv_contact_company_1 foreign key (company) references awv_company (id) on delete restrict on update restrict;

create index ix_awv_transit_abstractEntry_1 on awv_transit (abstract_entry_id);
alter table awv_transit add constraint fk_awv_transit_abstractEntry_1 foreign key (abstract_entry_id) references awv_entry (id) on delete restrict on update restrict;

create index ix_bank_e001Key_1 on bank (e001key_id);
alter table bank add constraint fk_bank_e001Key_1 foreign key (e001key_id) references rsapubkey (id) on delete restrict on update restrict;

create index ix_bank_e002Key_1 on bank (e002key_id);
alter table bank add constraint fk_bank_e002Key_1 foreign key (e002key_id) references rsapubkey (id) on delete restrict on update restrict;

create index ix_bank_x001Key_1 on bank (x001key_id);
alter table bank add constraint fk_bank_x001Key_1 foreign key (x001key_id) references rsapubkey (id) on delete restrict on update restrict;

create index ix_bank_x002Key_1 on bank (x002key_id);
alter table bank add constraint fk_bank_x002Key_1 foreign key (x002key_id) references rsapubkey (id) on delete restrict on update restrict;

create index ix_bank_tenant_1 on bank (tenant_id);
alter table bank add constraint fk_bank_tenant_1 foreign key (tenant_id) references tenant (id) on delete restrict on update restrict;

create index ix_bankuser_bank_1 on bankuser (bank_id);
alter table bankuser add constraint fk_bankuser_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_bankuser_user_1 on bankuser (user_id);
alter table bankuser add constraint fk_bankuser_user_1 foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

alter table bank_user_htd_info add constraint fk_bank_user_htd_info_bankUser_1 foreign key (bank_user_id) references bankuser (id) on delete restrict on update restrict;

create index ix_cm_balance_account_1 on cm_balance (account_id);
alter table cm_balance add constraint fk_cm_balance_account_1 foreign key (account_id) references account (id) on delete restrict on update restrict;

create index ix_cm_balance2_account_1 on cm_balance2 (account_id);
alter table cm_balance2 add constraint fk_cm_balance2_account_1 foreign key (account_id) references account (id) on delete restrict on update restrict;

alter table cm_bank add constraint fk_cm_bank_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_cm_booking_statement_1 on cm_booking (statement_id);
alter table cm_booking add constraint fk_cm_booking_statement_1 foreign key (statement_id) references cm_statement (id) on delete restrict on update restrict;

create index ix_cm_booking_page_1 on cm_booking (page_id);
alter table cm_booking add constraint fk_cm_booking_page_1 foreign key (page_id) references cm_page (id) on delete restrict on update restrict;

create index ix_cm_booking_account_1 on cm_booking (account_id);
alter table cm_booking add constraint fk_cm_booking_account_1 foreign key (account_id) references account (id) on delete restrict on update restrict;

create index ix_cm_booking_parentBooking_1 on cm_booking (parent_booking_id);
alter table cm_booking add constraint fk_cm_booking_parentBooking_1 foreign key (parent_booking_id) references cm_booking (id) on delete restrict on update restrict;

alter table cm_b_filter add constraint fk_cm_b_filter_user_1 foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_cm_charge_booking_id on cm_charge (booking_id);
alter table cm_charge add constraint fk_cm_charge_booking_id foreign key (booking_id) references cm_booking (id) on delete restrict on update restrict;

create index ix_cm_charge_statement_id on cm_charge (statement_id);
alter table cm_charge add constraint fk_cm_charge_statement_id foreign key (statement_id) references cm_statement (id) on delete restrict on update restrict;

create index ix_cm_charge_page_id on cm_charge (page_id);
alter table cm_charge add constraint fk_cm_charge_page_id foreign key (page_id) references cm_page (id) on delete restrict on update restrict;

create index ix_cm_check_login_1 on cm_check (login_id);
alter table cm_check add constraint fk_cm_check_login_1 foreign key (login_id) references loginuser (id) on delete restrict on update restrict;

create index ix_cm_check_statement_1 on cm_check (statement_id);
alter table cm_check add constraint fk_cm_check_statement_1 foreign key (statement_id) references cm_statement (id) on delete restrict on update restrict;

create index ix_cm_check_page_1 on cm_check (page_id);
alter table cm_check add constraint fk_cm_check_page_1 foreign key (page_id) references cm_page (id) on delete restrict on update restrict;

create index ix_cm_folder_tenant_1 on cm_folder (tenant_id);
alter table cm_folder add constraint fk_cm_folder_tenant_1 foreign key (tenant_id) references tenant (id) on delete restrict on update restrict;

create index ix_cm_page_statement_1 on cm_page (statement_id);
alter table cm_page add constraint fk_cm_page_statement_1 foreign key (statement_id) references cm_statement (id) on delete restrict on update restrict;

create index ix_cm_page_file_id on cm_page (file_id);
alter table cm_page add constraint fk_cm_page_file_id foreign key (file_id) references workspace_file (id) on delete restrict on update restrict;

create index ix_cm_pdf_statement_bank_1 on cm_pdf_statement (bank_id);
alter table cm_pdf_statement add constraint fk_cm_pdf_statement_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_cm_pdf_statement_account_1 on cm_pdf_statement (account_id);
alter table cm_pdf_statement add constraint fk_cm_pdf_statement_account_1 foreign key (account_id) references account (id) on delete restrict on update restrict;

create index ix_cm_pdf_statement_local_file_id on cm_pdf_statement (local_file_id);
alter table cm_pdf_statement add constraint fk_cm_pdf_statement_local_file_id foreign key (local_file_id) references workspace_file (id) on delete restrict on update restrict;

create index ix_cm_statement_account_1 on cm_statement (account_id);
alter table cm_statement add constraint fk_cm_statement_account_1 foreign key (account_id) references account (id) on delete restrict on update restrict;

create index ix_cm_statement_file_id on cm_statement (file_id);
alter table cm_statement add constraint fk_cm_statement_file_id foreign key (file_id) references workspace_file (id) on delete restrict on update restrict;

create index ix_cm_value_group_tenant_1 on cm_value_group (tenant_id);
alter table cm_value_group add constraint fk_cm_value_group_tenant_1 foreign key (tenant_id) references tenant (id) on delete restrict on update restrict;

create index ix_cm_value_group_account_cm_value_group on cm_value_group_account (cm_value_group_id);
alter table cm_value_group_account add constraint fk_cm_value_group_account_cm__01 foreign key (cm_value_group_id) references cm_value_group (id) on delete restrict on update restrict;

create index ix_cm_value_group_account_account on cm_value_group_account (account_id);
alter table cm_value_group_account add constraint fk_cm_value_group_account_acc_02 foreign key (account_id) references account (id) on delete restrict on update restrict;

create index ix_cm_value_group_folder_cm_value_group on cm_value_group_folder (cm_value_group_id);
alter table cm_value_group_folder add constraint fk_cm_value_group_folder_cm_v_01 foreign key (cm_value_group_id) references cm_value_group (id) on delete restrict on update restrict;

create index ix_cm_value_group_folder_cm_folder on cm_value_group_folder (cm_folder_id);
alter table cm_value_group_folder add constraint fk_cm_value_group_folder_cm_f_02 foreign key (cm_folder_id) references cm_folder (id) on delete restrict on update restrict;

create index ix_conversion_tenant_1 on conversion (tenant_id);
alter table conversion add constraint fk_conversion_tenant_1 foreign key (tenant_id) references tenant (id) on delete restrict on update restrict;

create index ix_sepa_converter_format_tenan_1 on sepa_converter_format (tenant_id);
alter table sepa_converter_format add constraint fk_sepa_converter_format_tenan_1 foreign key (tenant_id) references tenant (id) on delete restrict on update restrict;

create index ix_directory_scanner_bank_1 on directory_scanner (bank_id);
alter table directory_scanner add constraint fk_directory_scanner_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

alter table ds_bank add constraint fk_ds_bank_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_ds_open_order_bankUser_1 on ds_open_order (bank_user_id);
alter table ds_open_order add constraint fk_ds_open_order_bankUser_1 foreign key (bank_user_id) references bankuser (id) on delete restrict on update restrict;

create index ix_ds_open_order_order_data_id on ds_open_order (order_data_id);
alter table ds_open_order add constraint fk_ds_open_order_order_data_id foreign key (order_data_id) references workspace_file (id) on delete restrict on update restrict;

create index ix_ds_open_order_payment_data_id on ds_open_order (payment_data_id);
alter table ds_open_order add constraint fk_ds_open_order_payment_data_id foreign key (payment_data_id) references workspace_file (id) on delete restrict on update restrict;

create index ix_ds_open_order_signer_dsOpen_1 on ds_open_order_signer (ds_open_order_id);
alter table ds_open_order_signer add constraint fk_ds_open_order_signer_dsOpen_1 foreign key (ds_open_order_id) references ds_open_order (id) on delete restrict on update restrict;

create index ix_ds_order_details_bank_1 on ds_order_details (bank_id);
alter table ds_order_details add constraint fk_ds_order_details_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_ds_order_details_data_file_id on ds_order_details (data_file_id);
alter table ds_order_details add constraint fk_ds_order_details_data_file_id foreign key (data_file_id) references workspace_file (id) on delete restrict on update restrict;

create index ix_ds_order_details_account_ds_order_details on ds_order_details_account (ds_order_details_id);
alter table ds_order_details_account add constraint fk_ds_order_details_account_d_01 foreign key (ds_order_details_id) references ds_order_details (id) on delete restrict on update restrict;

create index ix_ds_order_details_account_account on ds_order_details_account (account_id);
alter table ds_order_details_account add constraint fk_ds_order_details_account_a_02 foreign key (account_id) references account (id) on delete restrict on update restrict;

create index ix_ds_signing_info_dsOrderDeta_1 on ds_signing_info (ds_order_details_id);
alter table ds_signing_info add constraint fk_ds_signing_info_dsOrderDeta_1 foreign key (ds_order_details_id) references ds_order_details (id) on delete restrict on update restrict;

create index ix_export_file_workspace_file_id on export_file (workspace_file_id);
alter table export_file add constraint fk_export_file_workspace_file_id foreign key (workspace_file_id) references workspace_file (id) on delete restrict on update restrict;

create index ix_export_file_account_export_file on export_file_account (export_file_id);
alter table export_file_account add constraint fk_export_file_account_export_01 foreign key (export_file_id) references export_file (id) on delete restrict on update restrict;

create index ix_export_file_account_account on export_file_account (account_id);
alter table export_file_account add constraint fk_export_file_account_accoun_02 foreign key (account_id) references account (id) on delete restrict on update restrict;

create index ix_export_file_aut_export_export_file on export_file_aut_export (export_file_id);
alter table export_file_aut_export add constraint fk_export_file_aut_export_exp_01 foreign key (export_file_id) references export_file (id) on delete restrict on update restrict;

create index ix_export_file_aut_export_automatic_export on export_file_aut_export (automatic_export_id);
alter table export_file_aut_export add constraint fk_export_file_aut_export_aut_02 foreign key (automatic_export_id) references automatic_export (id) on delete restrict on update restrict;

create index ix_exportfile_filter_user_id on exportfile_filter (user_id);
alter table exportfile_filter add constraint fk_exportfile_filter_user_id foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_fetch_item_bank_1 on fetch_item (bank_id);
alter table fetch_item add constraint fk_fetch_item_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_fetch_item_file_id on fetch_item (file_id);
alter table fetch_item add constraint fk_fetch_item_file_id foreign key (file_id) references workspace_file (id) on delete restrict on update restrict;

create index ix_fe_filter_user_1 on fe_filter (user_id);
alter table fe_filter add constraint fk_fe_filter_user_1 foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_fe_filter_bank_1 on fe_filter (bank_id);
alter table fe_filter add constraint fk_fe_filter_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_hac_entry_bank_1 on hac_entry (bank_id);
alter table hac_entry add constraint fk_hac_entry_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_hac_filter_user_1 on hac_filter (user_id);
alter table hac_filter add constraint fk_hac_filter_user_1 foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_log_tenant_id on log (tenant_id);
alter table log add constraint fk_log_tenant_id foreign key (tenant_id) references tenant (id) on delete restrict on update restrict;

create index ix_log_account_id on log (account_id);
alter table log add constraint fk_log_account_id foreign key (account_id) references account (id) on delete restrict on update restrict;

create index ix_log_actor_id on log (actor_id);
alter table log add constraint fk_log_actor_id foreign key (actor_id) references loginuser (id) on delete restrict on update restrict;

alter table log_filter add constraint fk_log_filter_user_id foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_login_session_user_id on login_session (user_id);
alter table login_session add constraint fk_login_session_user_id foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_notification_bank_1 on notification (bank_id);
alter table notification add constraint fk_notification_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_notification_file_id on notification (file_id);
alter table notification add constraint fk_notification_file_id foreign key (file_id) references workspace_file (id) on delete restrict on update restrict;

create index ix_notification_send_1 on notification (send_id);
alter table notification add constraint fk_notification_send_1 foreign key (send_id) references send_item (id) on delete restrict on update restrict;

create index ix_nf_filter_user_1 on nf_filter (user_id);
alter table nf_filter add constraint fk_nf_filter_user_1 foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_nf_filter_bank_1 on nf_filter (bank_id);
alter table nf_filter add constraint fk_nf_filter_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_notification_pmt_inf_notifi_1 on notification_pmt_inf (notification_id);
alter table notification_pmt_inf add constraint fk_notification_pmt_inf_notifi_1 foreign key (notification_id) references notification (id) on delete restrict on update restrict;

alter table nf_setting add constraint fk_nf_setting_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_notification_trx_notificati_1 on notification_trx (notification_id);
alter table notification_trx add constraint fk_notification_trx_notificati_1 foreign key (notification_id) references notification (id) on delete restrict on update restrict;

create index ix_notification_trx_pmtInf_1 on notification_trx (pmt_inf_id);
alter table notification_trx add constraint fk_notification_trx_pmtInf_1 foreign key (pmt_inf_id) references notification_pmt_inf (id) on delete restrict on update restrict;

create index ix_notification_trx_send_1 on notification_trx (send_id);
alter table notification_trx add constraint fk_notification_trx_send_1 foreign key (send_id) references send_item (id) on delete restrict on update restrict;

create index ix_notification_trx_signedPaym_1 on notification_trx (signed_payment_id);
alter table notification_trx add constraint fk_notification_trx_signedPaym_1 foreign key (signed_payment_id) references pmt_signed (id) on delete restrict on update restrict;

create index ix_open_id_token_user_id on open_id_token (user_id);
alter table open_id_token add constraint fk_open_id_token_user_id foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_pmt_open_createdUser_1 on pmt_open (created_user_id);
alter table pmt_open add constraint fk_pmt_open_createdUser_1 foreign key (created_user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_pmt_open_confirmedUser_1 on pmt_open (confirmed_user_id);
alter table pmt_open add constraint fk_pmt_open_confirmedUser_1 foreign key (confirmed_user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_pmt_open_lockingUser_1 on pmt_open (locking_user_id);
alter table pmt_open add constraint fk_pmt_open_lockingUser_1 foreign key (locking_user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_pmt_open_bank_1 on pmt_open (bank_id);
alter table pmt_open add constraint fk_pmt_open_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_pmt_open_account_1 on pmt_open (account_id);
alter table pmt_open add constraint fk_pmt_open_account_1 foreign key (account_id) references account (id) on delete restrict on update restrict;

create index ix_pmt_open_folder_1 on pmt_open (folder_id);
alter table pmt_open add constraint fk_pmt_open_folder_1 foreign key (folder_id) references pmt_folder (id) on delete restrict on update restrict;

create index ix_order_type_bank_1 on order_type (bank_id);
alter table order_type add constraint fk_order_type_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_password_history_user_1 on password_history (user_id);
alter table password_history add constraint fk_password_history_user_1 foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

alter table pmt_filter add constraint fk_pmt_filter_user_1 foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_pmt_folder_tenant_1 on pmt_folder (tenant_id);
alter table pmt_folder add constraint fk_pmt_folder_tenant_1 foreign key (tenant_id) references tenant (id) on delete restrict on update restrict;

create index ix_pmt_originator_tenant_1 on pmt_originator (tenant_id);
alter table pmt_originator add constraint fk_pmt_originator_tenant_1 foreign key (tenant_id) references tenant (id) on delete restrict on update restrict;

create index ix_pmt_originator_default_account_id on pmt_originator (default_account_id);
alter table pmt_originator add constraint fk_pmt_originator_default_account_id foreign key (default_account_id) references account (id) on delete restrict on update restrict;

alter table pmt_props add constraint fk_pmt_props_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_pmt_recipient_createdUser_1 on pmt_recipient (created_user_id);
alter table pmt_recipient add constraint fk_pmt_recipient_createdUser_1 foreign key (created_user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_pmt_recipient_confirmedUser_1 on pmt_recipient (confirmed_user_id);
alter table pmt_recipient add constraint fk_pmt_recipient_confirmedUser_1 foreign key (confirmed_user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_pmt_recipient_lockingUser_1 on pmt_recipient (locking_user_id);
alter table pmt_recipient add constraint fk_pmt_recipient_lockingUser_1 foreign key (locking_user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_pmt_recipient_tenant_1 on pmt_recipient (tenant_id);
alter table pmt_recipient add constraint fk_pmt_recipient_tenant_1 foreign key (tenant_id) references tenant (id) on delete restrict on update restrict;

alter table recip_filter add constraint fk_recip_filter_user_id foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_pmt_template_bank_1 on pmt_template (bank_id);
alter table pmt_template add constraint fk_pmt_template_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_pmt_template_account_1 on pmt_template (account_id);
alter table pmt_template add constraint fk_pmt_template_account_1 foreign key (account_id) references account (id) on delete restrict on update restrict;

create index ix_pmt_template_folder_1 on pmt_template (folder_id);
alter table pmt_template add constraint fk_pmt_template_folder_1 foreign key (folder_id) references pmt_folder (id) on delete restrict on update restrict;

create index ix_pmt_transfer_type_bank_1 on pmt_transfer_type (bank_id);
alter table pmt_transfer_type add constraint fk_pmt_transfer_type_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_pdfstatements_filter_user_id on pdfstatements_filter (user_id);
alter table pdfstatements_filter add constraint fk_pdfstatements_filter_user_id foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_pdfstatements_filter_bank_id on pdfstatements_filter (bank_id);
alter table pdfstatements_filter add constraint fk_pdfstatements_filter_bank_id foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_pmt_periodic_createdUser_1 on pmt_periodic (created_user_id);
alter table pmt_periodic add constraint fk_pmt_periodic_createdUser_1 foreign key (created_user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_pmt_periodic_confirmedUser_1 on pmt_periodic (confirmed_user_id);
alter table pmt_periodic add constraint fk_pmt_periodic_confirmedUser_1 foreign key (confirmed_user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_pmt_periodic_lockingUser_1 on pmt_periodic (locking_user_id);
alter table pmt_periodic add constraint fk_pmt_periodic_lockingUser_1 foreign key (locking_user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_pmt_periodic_bank_1 on pmt_periodic (bank_id);
alter table pmt_periodic add constraint fk_pmt_periodic_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_pmt_periodic_account_1 on pmt_periodic (account_id);
alter table pmt_periodic add constraint fk_pmt_periodic_account_1 foreign key (account_id) references account (id) on delete restrict on update restrict;

create index ix_pmt_periodic_folder_1 on pmt_periodic (folder_id);
alter table pmt_periodic add constraint fk_pmt_periodic_folder_1 foreign key (folder_id) references pmt_folder (id) on delete restrict on update restrict;

create index ix_preference_user_1 on preference (user_id);
alter table preference add constraint fk_preference_user_1 foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_preference_tenant_1 on preference (tenant_id);
alter table preference add constraint fk_preference_tenant_1 foreign key (tenant_id) references tenant (id) on delete restrict on update restrict;

alter table protocol_setting add constraint fk_protocol_setting_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_ptk_entry_bank_1 on ptk_entry (bank_id);
alter table ptk_entry add constraint fk_ptk_entry_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_ptk_filter_user_1 on ptk_filter (user_id);
alter table ptk_filter add constraint fk_ptk_filter_user_1 foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_scheduler_bank_id on scheduler (bank_id);
alter table scheduler add constraint fk_scheduler_bank_id foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_scheduler_login_user_id on scheduler (login_user_id);
alter table scheduler add constraint fk_scheduler_login_user_id foreign key (login_user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_send_item_bank_1 on send_item (bank_id);
alter table send_item add constraint fk_send_item_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_send_item_file_id on send_item (file_id);
alter table send_item add constraint fk_send_item_file_id foreign key (file_id) references workspace_file (id) on delete restrict on update restrict;

create index ix_send_item_callback_1 on send_item (callback_id);
alter table send_item add constraint fk_send_item_callback_1 foreign key (callback_id) references send_item (id) on delete restrict on update restrict;

create index ix_send_item_account_send_item on send_item_account (send_item_id);
alter table send_item_account add constraint fk_send_item_account_send_ite_01 foreign key (send_item_id) references send_item (id) on delete restrict on update restrict;

create index ix_send_item_account_account on send_item_account (account_id);
alter table send_item_account add constraint fk_send_item_account_account_02 foreign key (account_id) references account (id) on delete restrict on update restrict;

create index ix_send_filter_user_1 on send_filter (user_id);
alter table send_filter add constraint fk_send_filter_user_1 foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_send_filter_bank_1 on send_filter (bank_id);
alter table send_filter add constraint fk_send_filter_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_send_filter_account_1 on send_filter (account_id);
alter table send_filter add constraint fk_send_filter_account_1 foreign key (account_id) references account (id) on delete restrict on update restrict;

create index ix_pmt_signed_account_1 on pmt_signed (account_id);
alter table pmt_signed add constraint fk_pmt_signed_account_1 foreign key (account_id) references account (id) on delete restrict on update restrict;

create index ix_pmt_signed_folder_1 on pmt_signed (folder_id);
alter table pmt_signed add constraint fk_pmt_signed_folder_1 foreign key (folder_id) references pmt_folder (id) on delete restrict on update restrict;

create index ix_pmt_signed_send_1 on pmt_signed (send_id);
alter table pmt_signed add constraint fk_pmt_signed_send_1 foreign key (send_id) references send_item (id) on delete restrict on update restrict;

create index ix_pmt_signed_booking_id on pmt_signed (booking_id);
alter table pmt_signed add constraint fk_pmt_signed_booking_id foreign key (booking_id) references cm_booking (id) on delete restrict on update restrict;

create index ix_pmt_signed_callback_1 on pmt_signed (callback_id);
alter table pmt_signed add constraint fk_pmt_signed_callback_1 foreign key (callback_id) references send_item (id) on delete restrict on update restrict;

create index ix_simple_text_filter_user_1 on simple_text_filter (user_id);
alter table simple_text_filter add constraint fk_simple_text_filter_user_1 foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_sorting_user_1 on sorting (user_id);
alter table sorting add constraint fk_sorting_user_1 foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_pmt_urgnt_rcpnt_bank_1 on pmt_urgnt_rcpnt (bank_id);
alter table pmt_urgnt_rcpnt add constraint fk_pmt_urgnt_rcpnt_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_loginuser_license_1 on loginuser (license_id);
alter table loginuser add constraint fk_loginuser_license_1 foreign key (license_id) references license (id) on delete restrict on update restrict;

create index ix_loginuser_webLicense_1 on loginuser (web_license_id);
alter table loginuser add constraint fk_loginuser_webLicense_1 foreign key (web_license_id) references license (id) on delete restrict on update restrict;

create index ix_loginuser_tenant_loginuser on loginuser_tenant (loginuser_id);
alter table loginuser_tenant add constraint fk_loginuser_tenant_loginuser_01 foreign key (loginuser_id) references loginuser (id) on delete restrict on update restrict;

create index ix_loginuser_tenant_tenant on loginuser_tenant (tenant_id);
alter table loginuser_tenant add constraint fk_loginuser_tenant_tenant_02 foreign key (tenant_id) references tenant (id) on delete restrict on update restrict;

create index ix_loginuser_managed_tenant_loginuser on loginuser_managed_tenant (loginuser_id);
alter table loginuser_managed_tenant add constraint fk_loginuser_managed_tenant_l_01 foreign key (loginuser_id) references loginuser (id) on delete restrict on update restrict;

create index ix_loginuser_managed_tenant_tenant on loginuser_managed_tenant (tenant_id);
alter table loginuser_managed_tenant add constraint fk_loginuser_managed_tenant_t_02 foreign key (tenant_id) references tenant (id) on delete restrict on update restrict;

create index ix_user_effective_permission_bank_user_id on user_effective_permission (bank_user_id);
alter table user_effective_permission add constraint fk_user_effective_permission_bank_user_id foreign key (bank_user_id) references bankuser (id) on delete restrict on update restrict;

create index ix_user_effective_permission_account_id on user_effective_permission (account_id);
alter table user_effective_permission add constraint fk_user_effective_permission_account_id foreign key (account_id) references account (id) on delete restrict on update restrict;

create index ix_user_notification_user_id on user_notification (user_id);
alter table user_notification add constraint fk_user_notification_user_id foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_user_permission_bankUser_1 on user_permission (bank_user_id);
alter table user_permission add constraint fk_user_permission_bankUser_1 foreign key (bank_user_id) references bankuser (id) on delete restrict on update restrict;

create index ix_user_permission_orderType_1 on user_permission (order_type_id);
alter table user_permission add constraint fk_user_permission_orderType_1 foreign key (order_type_id) references order_type (id) on delete restrict on update restrict;

create index ix_user_permission_accountPerm_1 on user_permission (account_permission_id);
alter table user_permission add constraint fk_user_permission_accountPerm_1 foreign key (account_permission_id) references account_permission (id) on delete restrict on update restrict;

alter table web_authn add constraint fk_web_authn_yubikey_1 foreign key (yubikey_id) references yubikey (id) on delete restrict on update restrict;

create index ix_workspace_file_cluster_node_workspace_file on workspace_file_cluster_node (workspace_file_id);
alter table workspace_file_cluster_node add constraint fk_workspace_file_cluster_node_workspace_file foreign key (workspace_file_id) references workspace_file (id) on delete restrict on update restrict;

create index ix_workspace_file_cluster_node_cluster_node on workspace_file_cluster_node (cluster_node_id);
alter table workspace_file_cluster_node add constraint fk_workspace_file_cluster_node_cluster_node foreign key (cluster_node_id) references cluster_node (id) on delete restrict on update restrict;

create index ix_yubikey_user_1 on yubikey (user_id);
alter table yubikey add constraint fk_yubikey_user_1 foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_yubikey_history_user_1 on yubikey_history (user_id);
alter table yubikey_history add constraint fk_yubikey_history_user_1 foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_zip_filter_scheduler_1 on zip_filter (scheduler_id);
alter table zip_filter add constraint fk_zip_filter_scheduler_1 foreign key (scheduler_id) references scheduler (id) on delete restrict on update restrict;


INSERT INTO applicationinfo (prop_name, prop_value) VALUES ('db_layout', '379');
