-- apply changes
create table account (
  id                            integer not null,
  bank_id                       integer not null,
  name                          varchar(50) not null,
  description                   varchar(256),
  account_holder                varchar(256),
  account_holder_htd            varchar(256),
  info_text                     clob,
  sepa_originator_id            integer,
  dtazv_originator_id           integer,
  mt101_originator_id           integer,
  de_bank_code                  varchar(8),
  de_account_number             varchar(10),
  fr_bank_code                  varchar(5),
  fr_branch_code                varchar(5),
  fr_account_number             varchar(11),
  fr_check_code                 varchar(2),
  iban                          varchar(34),
  bic                           varchar(11),
  national_bank_code            varchar(30),
  national_account_number       varchar(40),
  currency                      varchar(3),
  cm_identification             varchar(256),
  credit_limit                  decimal(38,3),
  ip_limit                      decimal(38,3),
  ip_limit_type                 integer,
  ip_limit_state                integer,
  ip_limit_time                 timestamp,
  ip_limit_msg_id               varchar(35),
  investment_amount             decimal(38,3),
  type                          integer,
  folder_id                     integer,
  use_virtual_balances          boolean,
  virtual_start_balance         decimal(38,3),
  virtual_start_date            date,
  ignore_account_information    boolean,
  constraint ck_account_ip_limit_type check ( ip_limit_type in (0,1,2)),
  constraint ck_account_ip_limit_state check ( ip_limit_state in (0,1,2)),
  constraint ck_account_type check ( type in (0,1,2)),
  constraint pk_account primary key (id)
);
create sequence account_seq;

create table account_permission (
  id                            integer not null,
  bank_user_id                  integer not null,
  account_id                    integer not null,
  constraint uq_account_permission_1 unique (bank_user_id,account_id),
  constraint pk_account_permission primary key (id)
);
create sequence account_permission_seq;

create table ap_overwrite (
  id                            integer not null,
  bank_user_id                  integer not null,
  account_id                    integer not null,
  previous_enabled              boolean default true not null,
  amount_limit                  decimal(16,3),
  constraint uq_ap_overwrite_1 unique (bank_user_id,account_id),
  constraint pk_ap_overwrite primary key (id)
);
create sequence ap_overwrite_seq;

create table applicationinfo (
  prop_name                     varchar(50) not null,
  prop_value                    varchar(500),
  constraint pk_applicationinfo primary key (prop_name)
);

create table automatic_export (
  id                            integer not null,
  name                          varchar(255),
  conversion_id                 integer,
  convert_to_pdf                boolean,
  directory                     varchar(255),
  pattern                       varchar(255),
  activated                     boolean,
  type                          integer not null,
  tenant_id                     integer not null,
  constraint ck_automatic_export_type check ( type in (0,1,2)),
  constraint pk_automatic_export primary key (id)
);
create sequence automatic_export_seq;

create table automatic_export_account (
  automatic_export_id           integer not null,
  account_id                    integer not null,
  constraint pk_automatic_export_account primary key (automatic_export_id,account_id)
);

create table automatic_export_folder (
  automatic_export_id           integer not null,
  cm_folder_id                  integer not null,
  constraint pk_automatic_export_folder primary key (automatic_export_id,cm_folder_id)
);

create table awv_dika (
  id                            integer not null,
  abstract_entry_id             integer not null,
  purpose                       varchar(140),
  amount                        bigint,
  country                       varchar(2),
  ref_amount                    varchar(30),
  stlmnt_key                    varchar(1),
  constraint pk_awv_dika primary key (id)
);
create sequence awv_dika_seq;

create table awv_dirinv (
  id                            integer not null,
  abstract_entry_id             integer not null,
  isin                          varchar(12),
  label                         varchar(35),
  st_number                     integer,
  amount                        bigint,
  country                       varchar(2),
  ref_amount                    varchar(30),
  stlmnt_key                    varchar(1),
  constraint pk_awv_dirinv primary key (id)
);
create sequence awv_dirinv_seq;

create table awv_entry (
  id                            integer not null,
  type                          integer not null,
  month                         varchar(6) not null,
  reporter                      integer,
  category                      integer,
  svc_code                      varchar(3),
  reference                     varchar(35),
  cancel                        boolean not null,
  cmnt                          varchar(80),
  exported                      boolean not null,
  end_to_end_id                 varchar(50),
  tenant_id                     integer not null,
  origin                        integer not null,
  signed_payment_id             integer,
  cm_booking_id                 integer,
  constraint ck_awv_entry_type check ( type in (0,1,2)),
  constraint ck_awv_entry_origin check ( origin in (0,1,2,3)),
  constraint pk_awv_entry primary key (id)
);
create sequence awv_entry_seq;

create table awv_export (
  id                            integer not null,
  month                         varchar(6) not null,
  export_time                   timestamp,
  export_user                   varchar(256),
  export_file                   varchar(1024),
  tenant_id                     integer not null,
  constraint uq_awv_export_month unique (month),
  constraint pk_awv_export primary key (id)
);
create sequence awv_export_seq;

create table awv_company (
  id                            integer not null,
  institute                     varchar(9) not null,
  name                          varchar(80) not null,
  street                        varchar(80),
  pob                           varchar(80),
  zip                           varchar(20),
  town                          varchar(80),
  country                       varchar(2),
  tenant_id                     integer not null,
  constraint pk_awv_company primary key (id)
);
create sequence awv_company_seq;

create table awv_contact (
  id                            integer not null,
  company                       integer not null,
  title                         varchar(80),
  firstname                     varchar(80),
  surname                       varchar(80) not null,
  dept                          varchar(80),
  phone                         varchar(80) not null,
  fax                           varchar(80),
  email                         varchar(255),
  extranet                      varchar(8),
  constraint pk_awv_contact primary key (id)
);
create sequence awv_contact_seq;

create table awv_transit (
  id                            integer not null,
  abstract_entry_id             integer not null,
  warecode                      varchar(2),
  warename                      varchar(140),
  amount                        bigint,
  country                       varchar(2),
  ref_amount                    varchar(30),
  stlmnt_key                    varchar(1),
  constraint pk_awv_transit primary key (id)
);
create sequence awv_transit_seq;

create table bank (
  id                            integer not null,
  display_name                  varchar(64) not null,
  icon                          varchar(128),
  country                       varchar(2),
  url                           varchar(256) not null,
  prot_version                  varchar(4) not null,
  host_id                       varchar(35) not null,
  customer_id                   varchar(35) not null,
  hpd_time                      timestamp,
  hpd                           blob,
  e001key_id                    integer,
  e002key_id                    integer,
  x001key_id                    integer,
  x002key_id                    integer,
  expected_digest_e001          varchar(40),
  expected_digest_x001          varchar(40),
  expected_digest_e002          varchar(64),
  expected_digest_x002          varchar(64),
  dtazv_number                  integer,
  transfer_system               boolean,
  transport_only                boolean,
  use_hca_pub                   boolean,
  wss_fetch_type                varchar(255),
  vop_activated                 boolean default false not null,
  vop_mandatory                 boolean default false not null,
  tenant_id                     integer not null,
  constraint pk_bank primary key (id)
);
create sequence bank_seq;

create table bankuser (
  id                            integer not null,
  bank_id                       integer not null,
  user_id                       integer not null,
  default_user                  varchar(35),
  order_number                  varchar(4),
  with_certs                    boolean default false not null,
  state                         integer not null,
  deactivated                   boolean default false not null,
  wss_activated                 boolean default false not null,
  signature_version             varchar(4),
  sig_key_length                integer,
  auth_key_length               integer,
  encr_key_length               integer,
  dtaus_reference_number        integer,
  bundesbank_file_number        integer,
  sepa_message_id               integer,
  mt101_sender_reference        integer,
  encr_key                      blob,
  encr_cert                     blob,
  auth_key                      blob,
  auth_cert                     blob,
  sig_key                       blob,
  sig_cert                      blob,
  lock_user_signature           blob,
  ini_letter                    blob,
  constraint ck_bankuser_state check ( state in (0,1,2,3,4,5)),
  constraint uq_bankuser_1 unique (bank_id,user_id),
  constraint pk_bankuser primary key (id)
);
create sequence bankuser_seq;

create table bank_user_htd_info (
  id                            integer not null,
  bank_user_id                  integer,
  ebics_host_id                 varchar(35),
  name                          varchar(256),
  street                        varchar(256),
  post_code                     varchar(20),
  city                          varchar(256),
  region                        varchar(256),
  country                       varchar(256),
  user_id                       varchar(35),
  user_status                   integer,
  user_name                     varchar(256),
  htd_time                      timestamp,
  constraint uq_bank_user_htd_info_bank_user_ unique (bank_user_id),
  constraint pk_bank_user_htd_info primary key (id)
);
create sequence bank_user_htd_info_seq;

create table cluster_node (
  id                            integer not null,
  base_url                      varchar(255),
  secret                        varchar(20),
  primary_node                  boolean default false not null,
  constraint uq_cluster_node_base_url unique (base_url),
  constraint pk_cluster_node primary key (id)
);
create sequence cluster_node_seq;

create table cm_balance (
  id                            integer not null,
  account_id                    integer,
  value_date                    date,
  value_balance                 decimal(38,3),
  value_balance_with_advice     decimal(38,3),
  constraint pk_cm_balance primary key (id)
);
create sequence cm_balance_seq;

create table cm_balance2 (
  id                            integer not null,
  account_id                    integer,
  value_date                    date,
  value_balance                 decimal(38,3),
  value_balance_with_advice     decimal(38,3),
  constraint pk_cm_balance2 primary key (id)
);
create sequence cm_balance2_seq;

create table cm_bank (
  id                            integer not null,
  bank_id                       integer,
  statements_activated          boolean default false not null,
  advice_activated              boolean default false not null,
  credit_advice_activated       boolean default false not null,
  bka_activated                 boolean default false not null,
  bki_activated                 boolean default false not null,
  c54_activated                 boolean default false not null,
  cumulative_advice_provision   boolean default false not null,
  multidays_advice_repeated     boolean default false not null,
  statement_format              varchar(255),
  advice_format                 varchar(255),
  statement_fetch_type          varchar(255),
  advice_fetch_type             varchar(255),
  credit_advice_fetch_type      varchar(255),
  bka_fetch_type                varchar(255),
  bki_fetch_type                varchar(255),
  c54_fetch_type                varchar(255),
  last_sta_fetch                date,
  last_vmk_fetch                date,
  last_credit_advice_fetch      date,
  last_bka_fetch                date,
  last_bki_fetch                date,
  last_c54_fetch                date,
  sta_fetch_mode                integer,
  vmk_fetch_mode                integer,
  cav_fetch_mode                integer,
  bka_fetch_mode                integer,
  bki_fetch_mode                integer,
  c54_fetch_mode                integer,
  vb_calculation_with_cav       boolean default false not null,
  vb_calculation_with_pav       boolean default false not null,
  constraint ck_cm_bank_sta_fetch_mode check ( sta_fetch_mode in (0,1)),
  constraint ck_cm_bank_vmk_fetch_mode check ( vmk_fetch_mode in (0,1)),
  constraint ck_cm_bank_cav_fetch_mode check ( cav_fetch_mode in (0,1)),
  constraint ck_cm_bank_bka_fetch_mode check ( bka_fetch_mode in (0,1)),
  constraint ck_cm_bank_bki_fetch_mode check ( bki_fetch_mode in (0,1)),
  constraint ck_cm_bank_c54_fetch_mode check ( c54_fetch_mode in (0,1)),
  constraint uq_cm_bank_bank_id unique (bank_id),
  constraint pk_cm_bank primary key (id)
);
create sequence cm_bank_seq;

create table cm_booking (
  id                            integer not null,
  statement_id                  integer not null,
  page_id                       integer,
  account_id                    integer not null,
  parent_booking_id             integer,
  pos                           integer,
  booking_date                  date,
  value_date                    date,
  local_party                   varchar(140),
  local_party_bank_code         varchar(30),
  local_party_account_number    varchar(40),
  local_party_creditor_id       varchar(35),
  local_party_mandate_reference varchar(35),
  ultimate_local_party          varchar(140),
  counter_party                 varchar(140),
  counter_party_bank_code       varchar(30),
  counter_party_account_number  varchar(40),
  counter_party_creditor_id     varchar(35),
  counter_party_mandate_ref     varchar(35),
  ultimate_counter_party        varchar(140),
  purpose                       varchar(400),
  purpose_code                  varchar(35),
  purpose_overview              varchar(140),
  sts                           varchar(4),
  amount                        decimal(38,3),
  currency_code                 varchar(3),
  original_amount               decimal(38,3),
  original_currency             varchar(3),
  settlement_amount             decimal(38,3),
  settlement_currency           varchar(3),
  charges_amount                decimal(38,3),
  charges_currency              varchar(3),
  fee_type                      varchar(3),
  converted_amount              decimal(38,3),
  converted_currency            varchar(3),
  exchange_rate                 decimal(38,3),
  exchange_rate_date            date,
  booking_key                   varchar(3),
  booking_text                  varchar(27),
  gvc                           varchar(3),
  primanota                     varchar(10),
  text_key_appendix             varchar(3),
  additional_information        varchar(500),
  bank_reference                varchar(35),
  customer_reference            varchar(35),
  customer_reference_date       date,
  end_to_end_id                 varchar(35),
  instr_id                      varchar(35),
  pmt_inf_id                    varchar(35),
  msg_id                        varchar(35),
  transaction_code              varchar(4),
  domain_code                   varchar(4),
  family_code                   varchar(4),
  sub_family_code               varchar(4),
  interbank_transaction_code    varchar(2),
  rejection_cause_code          varchar(4),
  entry_number                  varchar(7),
  exemption                     boolean,
  unavailabilty_rating          boolean,
  balance                       decimal(38,3),
  collective                    boolean,
  debit                         boolean,
  reversal                      boolean,
  signed_payments               boolean,
  transaction_id                varchar(35),
  ntry_ref                      varchar(35),
  count_transactions            integer,
  constraint pk_cm_booking primary key (id)
);
create sequence cm_booking_seq;

create table cm_b_filter (
  id                            integer not null,
  user_id                       integer not null,
  filter_active                 boolean,
  booking_date_from             date,
  booking_date_to               date,
  bd_comp                       integer,
  value_date_from               date,
  value_date_to                 date,
  vd_comp                       integer,
  text                          varchar(255),
  text_comp                     integer,
  amount_from                   decimal(38,3),
  amount_to                     decimal(38,3),
  amount_comp                   integer,
  booking_dir                   integer not null,
  booking_type                  integer,
  booking_type_text             varchar(3),
  constraint ck_cm_b_filter_bd_comp check ( bd_comp in (0,1,2,3)),
  constraint ck_cm_b_filter_vd_comp check ( vd_comp in (0,1,2,3)),
  constraint ck_cm_b_filter_text_comp check ( text_comp in (0,1,2,3)),
  constraint ck_cm_b_filter_amount_comp check ( amount_comp in (0,1,2,3)),
  constraint ck_cm_b_filter_booking_dir check ( booking_dir in (0,1,2)),
  constraint ck_cm_b_filter_booking_type check ( booking_type in (0,1,2,3,4,5,6)),
  constraint uq_cm_b_filter_user_id unique (user_id),
  constraint pk_cm_b_filter primary key (id)
);
create sequence cm_b_filter_seq;

create table cm_charge (
  id                            integer not null,
  booking_id                    integer not null,
  statement_id                  integer,
  page_id                       integer,
  amount                        decimal(38,3),
  currency_code                 varchar(3),
  is_included                   boolean default false not null,
  bank_identification           varchar(140),
  type                          varchar(35),
  rate                          decimal(11,10),
  charge_bearer_type            varchar(4),
  tax_identification            varchar(35),
  tax_amount                    decimal(38,3),
  tax_currency_code             varchar(3),
  tax_rate                      decimal(11,10),
  constraint pk_cm_charge primary key (id)
);
create sequence cm_charge_seq;

create table cm_check (
  id                            integer not null,
  login_id                      integer,
  statement_id                  integer,
  page_id                       integer,
  checked                       boolean,
  constraint pk_cm_check primary key (id)
);
create sequence cm_check_seq;

create table cm_folder (
  id                            integer not null,
  name                          varchar(255),
  tenant_id                     integer not null,
  constraint uq_cm_folder_1 unique (name,tenant_id),
  constraint pk_cm_folder primary key (id)
);
create sequence cm_folder_seq;

create table cm_page (
  id                            integer not null,
  statement_id                  integer,
  creation_date                 timestamp,
  reference1                    varchar(255),
  reference2                    varchar(255),
  closing_date                  date,
  closing_balance               decimal(38,3),
  closing_final                 boolean default false not null,
  opening_date                  date,
  opening_balance               decimal(38,3),
  opening_final                 boolean default false not null,
  currency_code                 varchar(3),
  page_number                   integer,
  count_credit                  integer,
  count_debit                   integer,
  sum_credit                    decimal(38,3),
  sum_debit                     decimal(38,3),
  max_credit                    decimal(38,3),
  min_credit                    decimal(38,3),
  max_debit                     decimal(38,3),
  min_debit                     decimal(38,3),
  old                           boolean default false not null,
  file_id                       integer,
  constraint pk_cm_page primary key (id)
);
create sequence cm_page_seq;

create table cm_pdf_statement (
  id                            integer not null,
  type                          integer not null,
  bank_id                       integer,
  account_id                    integer,
  statement_date                date,
  statement_number              integer,
  zip_file_name                 varchar(255),
  local_file_id                 integer,
  constraint ck_cm_pdf_statement_type check ( type in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16)),
  constraint pk_cm_pdf_statement primary key (id)
);
create sequence cm_pdf_statement_seq;

create table cm_statement (
  id                            integer not null,
  account_id                    integer,
  creation_date                 timestamp,
  reference1                    varchar(255),
  reference2                    varchar(255),
  opening_date                  date,
  opening_balance               decimal(38,3),
  opening_final                 boolean default false not null,
  closing_date                  date,
  closing_balance               decimal(38,3),
  closing_final                 boolean default false not null,
  currency_code                 varchar(3),
  statement_number              integer,
  page_number                   integer,
  legal_number                  integer,
  unique_id                     varchar(255),
  count_credit                  integer,
  count_debit                   integer,
  sum_credit                    decimal(38,3),
  sum_debit                     decimal(38,3),
  max_credit                    decimal(38,3),
  min_credit                    decimal(38,3),
  max_debit                     decimal(38,3),
  min_debit                     decimal(38,3),
  type                          integer not null,
  original_filename             varchar(255),
  additional_information        varchar(500),
  file_id                       integer,
  constraint ck_cm_statement_type check ( type in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30)),
  constraint uq_cm_statement_1 unique (account_id,unique_id),
  constraint pk_cm_statement primary key (id)
);
create sequence cm_statement_seq;

create table cm_value_group (
  id                            integer not null,
  name                          varchar(255),
  tenant_id                     integer not null,
  constraint pk_cm_value_group primary key (id)
);
create sequence cm_value_group_seq;

create table cm_value_group_account (
  cm_value_group_id             integer not null,
  account_id                    integer not null,
  constraint pk_cm_value_group_account primary key (cm_value_group_id,account_id)
);

create table cm_value_group_folder (
  cm_value_group_id             integer not null,
  cm_folder_id                  integer not null,
  constraint pk_cm_value_group_folder primary key (cm_value_group_id,cm_folder_id)
);

create table conversion (
  id                            integer not null,
  name                          varchar(255),
  type                          integer,
  include_header                boolean default false not null,
  field_separator               varchar(255),
  text_separator                varchar(255),
  date_format                   varchar(255),
  number_format                 varchar(255),
  fields                        varchar(500),
  tenant_id                     integer not null,
  constraint ck_conversion_type check ( type in (0,1,2,3)),
  constraint pk_conversion primary key (id)
);
create sequence conversion_seq;

create table sepa_converter_format (
  id                            integer not null,
  tpe                           integer,
  encoding                      varchar(25),
  field_separator               varchar(5),
  has_header                    boolean,
  country_code                  varchar(2),
  format                        clob,
  tenant_id                     integer not null,
  constraint ck_sepa_converter_format_tpe check ( tpe in (0,1,2,3,4)),
  constraint pk_sepa_converter_format primary key (id)
);
create sequence sepa_converter_format_seq;

create table directory_scanner (
  id                            integer not null,
  directory                     varchar(255) not null,
  bank_id                       integer,
  reg_ex                        varchar(255),
  archive_directory             varchar(255),
  error_directory               varchar(255),
  order_or_file_type            varchar(255),
  signature                     boolean,
  constraint pk_directory_scanner primary key (id)
);
create sequence directory_scanner_seq;

create table ds_bank (
  id                            integer not null,
  bank_id                       integer,
  activated                     boolean default false not null,
  hvz                           boolean default false not null,
  constraint uq_ds_bank_bank_id unique (bank_id),
  constraint pk_ds_bank primary key (id)
);
create sequence ds_bank_seq;

create table ds_open_order (
  id                            integer not null,
  bank_user_id                  integer,
  file_type                     varchar(50) not null,
  pmt_type                      integer,
  order_id                      varchar(4) not null,
  submission_date               timestamp not null,
  customer_id                   varchar(35) not null,
  user_id                       varchar(35),
  user_name                     varchar(80),
  amount                        decimal(38,3),
  amount_currency               varchar(3),
  datasize                      bigint,
  originator                    varchar(140),
  digest_hex                    varchar(80),
  is_signable                   boolean default false not null,
  is_order_data_available       boolean default false not null,
  is_payment_data_available     boolean default false not null,
  num_sig_done                  integer not null,
  num_sig_required              integer not null,
  ticket                        blob,
  order_data_id                 integer,
  payment_data_id               integer,
  additional_order_info         varchar(255),
  constraint ck_ds_open_order_pmt_type check ( pmt_type in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49)),
  constraint pk_ds_open_order primary key (id)
);
create sequence ds_open_order_seq;

create table ds_open_order_signer (
  id                            integer not null,
  ds_open_order_id              integer,
  sign_date                     timestamp not null,
  customer_id                   varchar(35) not null,
  user_id                       varchar(35),
  user_name                     varchar(80),
  permission                    varchar(1) not null,
  constraint pk_ds_open_order_signer primary key (id)
);
create sequence ds_open_order_signer_seq;

create table ds_order_details (
  id                            integer not null,
  bank_id                       integer,
  pmt_type                      integer,
  file_type                     varchar(50) not null,
  order_id                      varchar(4) not null,
  filename                      varchar(256),
  submission_date               timestamp not null,
  customer_id                   varchar(35) not null,
  user_id                       varchar(35),
  user_name                     varchar(40),
  num_sig_done                  integer,
  num_sig_required              integer,
  amount                        decimal(38,3),
  amount_currency               varchar(3),
  datasize                      bigint,
  ticket                        blob,
  data_file_id                  integer,
  state                         integer,
  error_code                    varchar(4),
  additional_order_info         varchar(255),
  tp                            integer,
  constraint ck_ds_order_details_pmt_type check ( pmt_type in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49)),
  constraint ck_ds_order_details_state check ( state in (0,1,2,3,4,5)),
  constraint ck_ds_order_details_tp check ( tp in (0,1)),
  constraint pk_ds_order_details primary key (id)
);
create sequence ds_order_details_seq;

create table ds_order_details_account (
  ds_order_details_id           integer not null,
  account_id                    integer not null,
  constraint pk_ds_order_details_account primary key (ds_order_details_id,account_id)
);

create table ds_signing_info (
  id                            integer not null,
  ds_order_details_id           integer not null,
  customer_id                   varchar(35) not null,
  user_id                       varchar(35) not null,
  user_name                     varchar(256),
  sign_date                     timestamp not null,
  ip_address                    varchar(255),
  permission                    varchar(1) not null,
  constraint pk_ds_signing_info primary key (id)
);
create sequence ds_signing_info_seq;

create table export_file (
  id                            integer not null,
  workspace_file_id             integer,
  last_update                   timestamp,
  constraint pk_export_file primary key (id)
);
create sequence export_file_seq;

create table export_file_account (
  export_file_id                integer not null,
  account_id                    integer not null,
  constraint pk_export_file_account primary key (export_file_id,account_id)
);

create table export_file_aut_export (
  export_file_id                integer not null,
  automatic_export_id           integer not null,
  constraint pk_export_file_aut_export primary key (export_file_id,automatic_export_id)
);

create table exportfile_filter (
  id                            integer not null,
  user_id                       integer not null,
  from_date                     date,
  to_date                       date,
  date_comp                     integer,
  export_file_active            boolean default false not null,
  automatic_export_id           integer,
  file_name                     varchar(255),
  file_name_comp                integer not null,
  constraint ck_exportfile_filter_date_comp check ( date_comp in (0,1,2,3)),
  constraint ck_exportfile_filter_file_name_comp check ( file_name_comp in (0,1,2,3)),
  constraint pk_exportfile_filter primary key (id)
);
create sequence exportfile_filter_seq;

create table fetch_item (
  id                            integer not null,
  bank_id                       integer,
  fetched                       timestamp not null,
  file_id                       integer,
  file_type                     varchar(255),
  order_type                    varchar(3) not null,
  error                         clob,
  from_date                     date,
  to_date                       date,
  fetcher                       varchar(255),
  constraint pk_fetch_item primary key (id)
);
create sequence fetch_item_seq;

create table fe_filter (
  id                            integer not null,
  user_id                       integer not null,
  from_date                     date,
  to_date                       date,
  date_comp                     integer,
  order_type                    varchar(255),
  order_type_comp               integer not null,
  bank_id                       integer,
  bank_comp                     integer not null,
  fetch_active                  boolean default false not null,
  fetcher                       varchar(255),
  fetcher_comp                  integer,
  constraint ck_fe_filter_date_comp check ( date_comp in (0,1,2,3)),
  constraint ck_fe_filter_order_type_comp check ( order_type_comp in (0,1,2,3)),
  constraint ck_fe_filter_bank_comp check ( bank_comp in (0)),
  constraint ck_fe_filter_fetcher_comp check ( fetcher_comp in (0,1,2,3)),
  constraint pk_fe_filter primary key (id)
);
create sequence fe_filter_seq;

create table hac_entry (
  id                            integer not null,
  bank_id                       integer,
  hac_time                      timestamp not null,
  axn                           integer,
  customer_id                   varchar(35),
  user_id                       varchar(35),
  reason                        varchar(4),
  order_number                  varchar(4),
  order_type                    varchar(3),
  file_type                     varchar(255),
  additional_information        clob,
  constraint pk_hac_entry primary key (id)
);
create sequence hac_entry_seq;

create table hac_filter (
  id                            integer not null,
  user_id                       integer not null,
  from_date                     date,
  to_date                       date,
  date_comp                     integer,
  order_type                    varchar(255),
  order_type_comp               integer not null,
  order_nr                      varchar(255),
  order_nr_comp                 integer not null,
  axn                           integer,
  customer_id                   varchar(35),
  bank_user_id                  varchar(35),
  reason                        varchar(4),
  constraint ck_hac_filter_date_comp check ( date_comp in (0,1,2,3)),
  constraint ck_hac_filter_order_type_comp check ( order_type_comp in (0,1,2,3)),
  constraint ck_hac_filter_order_nr_comp check ( order_nr_comp in (0,1,2,3)),
  constraint pk_hac_filter primary key (id)
);
create sequence hac_filter_seq;

create table license (
  id                            varchar(11) not null,
  content                       blob,
  constraint pk_license primary key (id)
);

create table log (
  id                            integer not null,
  log_time                      timestamp,
  tenant_id                     integer,
  account_id                    integer,
  actor_id                      integer not null,
  message_name                  varchar(255),
  message_en                    varchar(500),
  message_de                    varchar(500),
  pmt_type                      integer,
  parameter                     blob,
  constraint ck_log_pmt_type check ( pmt_type in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49)),
  constraint pk_log primary key (id)
);
create sequence log_seq;

create table log_filter (
  id                            integer not null,
  user_id                       integer not null,
  active                        boolean,
  type                          varchar(255),
  account_id                    integer,
  filter_user_id                integer,
  from_date                     date,
  to_date                       date,
  date_comp                     integer,
  constraint ck_log_filter_date_comp check ( date_comp in (0,1,2,3)),
  constraint uq_log_filter_user_id unique (user_id),
  constraint pk_log_filter primary key (id)
);
create sequence log_filter_seq;

create table login_session (
  id                            integer not null,
  user_id                       integer not null,
  active                        boolean default false not null,
  session_activity              timestamp not null,
  constraint pk_login_session primary key (id)
);
create sequence login_session_seq;

create table notification (
  id                            integer not null,
  bank_id                       integer,
  fetched                       timestamp not null,
  type                          integer not null,
  file_id                       integer,
  file_type                     varchar(255),
  order_type                    varchar(3),
  send_id                       integer,
  order_info                    varchar(255),
  orgnl_msg_id                  varchar(35),
  orgnl_msg_nm_id               varchar(255),
  orgnl_nb_of_txs               integer,
  orgnl_ctrl_sum                decimal(38,3),
  grp_sts                       varchar(4),
  nb_of_rjct                    integer,
  constraint ck_notification_type check ( type in (0,1,2,3,4,5,6,7,8,9,10,11,12,13)),
  constraint pk_notification primary key (id)
);
create sequence notification_seq;

create table nf_filter (
  id                            integer not null,
  user_id                       integer not null,
  from_date                     date,
  to_date                       date,
  date_comp                     integer,
  order_type                    varchar(255),
  order_type_comp               integer not null,
  bank_id                       integer,
  bank_comp                     integer not null,
  notification_active           boolean default false not null,
  constraint ck_nf_filter_date_comp check ( date_comp in (0,1,2,3)),
  constraint ck_nf_filter_order_type_comp check ( order_type_comp in (0,1,2,3)),
  constraint ck_nf_filter_bank_comp check ( bank_comp in (0)),
  constraint pk_nf_filter primary key (id)
);
create sequence nf_filter_seq;

create table notification_pmt_inf (
  id                            integer not null,
  notification_id               integer,
  orgnl_pmt_inf_id              varchar(35),
  orgnl_nb_of_txs               integer,
  orgnl_ctrl_sum                decimal(38,3),
  pmt_inf_sts                   varchar(4),
  constraint pk_notification_pmt_inf primary key (id)
);
create sequence notification_pmt_inf_seq;

create table nf_setting (
  id                            integer not null,
  bank_id                       integer,
  active                        boolean default false not null,
  credit_notifications          boolean default false not null,
  debit_notifications           boolean default false not null,
  instant_notifications         boolean default false not null,
  foreign_notifications         boolean default false not null,
  vop_notifications             boolean default false not null,
  callback_notifications        boolean default false not null,
  bundesbank                    boolean default false not null,
  credit_fetch_type             varchar(255),
  debit_fetch_type              varchar(255),
  instant_fetch_type            varchar(255),
  foreign_fetch_type            varchar(255),
  vop_fetch_type                varchar(255),
  callback_fetch_type           varchar(255),
  fetch_mode                    integer,
  last_fetch                    date,
  constraint ck_nf_setting_fetch_mode check ( fetch_mode in (0,1)),
  constraint uq_nf_setting_bank_id unique (bank_id),
  constraint pk_nf_setting primary key (id)
);
create sequence nf_setting_seq;

create table notification_trx (
  id                            integer not null,
  notification_id               integer,
  pmt_inf_id                    integer,
  send_id                       integer,
  signed_payment_id             integer,
  orgnl_instr_id                varchar(255),
  orgnl_end_to_end_id           varchar(255),
  tx_sts                        varchar(4),
  originator                    varchar(70),
  originator_account_number     varchar(40),
  originator_bank_code          varchar(34),
  recipient                     varchar(70),
  recipient_account_number      varchar(40),
  recipient_bank_code           varchar(34),
  amount                        decimal(38,3),
  amount_currency               varchar(3),
  purpose                       varchar(140),
  execution_date                timestamp,
  status_reason_info            clob,
  creditor_id                   varchar(35),
  mandate_id                    varchar(35),
  mandate_sign_date             date,
  constraint pk_notification_trx primary key (id)
);
create sequence notification_trx_seq;

create table open_id_token (
  id                            integer not null,
  user_id                       integer,
  id_token                      blob,
  access_token                  blob,
  refresh_token                 blob,
  constraint pk_open_id_token primary key (id)
);
create sequence open_id_token_seq;

create table pmt_open (
  id                            integer not null,
  business_id                   integer,
  created_user_id               integer not null,
  created                       timestamp not null,
  confirmed_user_id             integer,
  confirmed                     timestamp,
  version                       integer not null,
  locking_user_id               integer,
  deleted                       boolean default false not null,
  bank_id                       integer not null,
  account_id                    integer,
  pmt_type                      integer,
  order_type                    varchar(3),
  file_type                     varchar(50),
  is_credit                     boolean,
  is_urgent                     boolean,
  originator                    varchar(70),
  recipient                     varchar(70),
  amount                        decimal(38,3),
  amount_currency               varchar(3),
  purpose                       varchar(140),
  execution_date                timestamp,
  payment_data                  blob,
  folder_id                     integer,
  salary_payment                boolean,
  constraint ck_pmt_open_version check ( version in (0,1,2)),
  constraint ck_pmt_open_pmt_type check ( pmt_type in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49)),
  constraint pk_pmt_open primary key (id)
);
create sequence pmt_open_seq;

create table order_type (
  id                            integer not null,
  bank_id                       integer,
  transfer_type                 integer not null,
  order_type                    varchar(3),
  file_format                   varchar(50),
  order_format                  varchar(8),
  num_sig_required              integer,
  description                   varchar(255),
  constraint ck_order_type_transfer_type check ( transfer_type in (0,1)),
  constraint pk_order_type primary key (id)
);
create sequence order_type_seq;

create table password_history (
  id                            integer not null,
  user_id                       integer not null,
  change_date                   timestamp,
  hash_value                    varchar(64),
  constraint pk_password_history primary key (id)
);
create sequence password_history_seq;

create table pmt_xchgrate (
  id                            integer not null,
  currency_code                 varchar(3) not null,
  exchange_rate                 decimal(38,10) not null,
  rate_time                     timestamp,
  constraint uq_pmt_xchgrate_currency_code unique (currency_code),
  constraint pk_pmt_xchgrate primary key (id)
);
create sequence pmt_xchgrate_seq;

create table pmt_filter (
  id                            integer not null,
  user_id                       integer not null,
  pmt_open_active               boolean,
  pmt_signed_active             boolean,
  pmt_template_active           boolean,
  pmt_periodic_active           boolean,
  pmt_type                      integer,
  pmt_type_comp                 integer,
  account_id                    integer,
  filter_user_id                integer,
  text                          varchar(255),
  text_comp                     integer,
  amount_from                   decimal(38,3),
  amount_to                     decimal(38,3),
  amount_comp                   integer,
  from_exec_date                date,
  to_exec_date                  date,
  exec_date_comp                integer,
  state                         integer,
  constraint ck_pmt_filter_pmt_type check ( pmt_type in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49)),
  constraint ck_pmt_filter_pmt_type_comp check ( pmt_type_comp in (0,1)),
  constraint ck_pmt_filter_text_comp check ( text_comp in (0,1,2,3)),
  constraint ck_pmt_filter_amount_comp check ( amount_comp in (0,1,2,3)),
  constraint ck_pmt_filter_exec_date_comp check ( exec_date_comp in (0,1,2,3)),
  constraint ck_pmt_filter_state check ( state in (0,1,2,3,4,5,6,7,8)),
  constraint uq_pmt_filter_user_id unique (user_id),
  constraint pk_pmt_filter primary key (id)
);
create sequence pmt_filter_seq;

create table pmt_folder (
  id                            integer not null,
  name                          varchar(255),
  tenant_id                     integer not null,
  constraint pk_pmt_folder primary key (id)
);
create sequence pmt_folder_seq;

create table pmt_originator (
  id                            integer not null,
  name                          varchar(255),
  tenant_id                     integer not null,
  default_account_id            integer,
  payment_type                  integer not null,
  originator_info               clob,
  constraint ck_pmt_originator_payment_type check ( payment_type in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15)),
  constraint pk_pmt_originator primary key (id)
);
create sequence pmt_originator_seq;

create table pmt_props (
  id                            integer not null,
  bank_id                       integer not null,
  dtazv_separat                 boolean,
  mt101_separat                 boolean,
  mt101_save_acc_currency       boolean,
  sepa_dbt_ldtime               integer,
  sepa_cdt_ftype                varchar(50),
  sepa_coredbt_ftype            varchar(50),
  sepa_b2bdbt_ftype             varchar(50),
  sepa_max_exec_date            integer default 15 not null,
  sepa_max_urgt_pmnts           integer,
  cfonb160_sender               varchar(6),
  cfonb160_allowxpf             boolean,
  cfonb320_custid               varchar(16),
  mt101swift_header             boolean,
  constraint uq_pmt_props_bank_id unique (bank_id),
  constraint pk_pmt_props primary key (id)
);
create sequence pmt_props_seq;

create table pmt_recipient (
  id                            integer not null,
  business_id                   integer,
  created_user_id               integer not null,
  created                       timestamp not null,
  confirmed_user_id             integer,
  confirmed                     timestamp,
  version                       integer not null,
  locking_user_id               integer,
  deleted                       boolean default false not null,
  payment_type                  integer not null,
  tenant_id                     integer not null,
  display_name                  varchar(128),
  name                          varchar(70),
  account_number                varchar(40),
  bank_code                     varchar(34),
  bank_name                     varchar(128),
  purpose                       varchar(400),
  reference                     varchar(35),
  sepa_mandate_id               varchar(35),
  recipient_info                clob,
  vop_name                      varchar(70),
  vop_result                    varchar(4),
  vop_reason                    varchar(4),
  vop_additional_info           varchar(210),
  vop_date                      timestamp,
  last_usage                    timestamp,
  constraint ck_pmt_recipient_version check ( version in (0,1,2)),
  constraint ck_pmt_recipient_payment_type check ( payment_type in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15)),
  constraint pk_pmt_recipient primary key (id)
);
create sequence pmt_recipient_seq;

create table recip_filter (
  id                            integer not null,
  user_id                       integer not null,
  payment_type                  integer,
  payment_type_comp             integer,
  vop_result                    varchar(4),
  vop_result_comp               integer,
  text                          varchar(255),
  text_comp                     integer,
  from_last_usage               date,
  to_last_usage                 date,
  last_usage_comp               integer,
  constraint ck_recip_filter_payment_type check ( payment_type in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15)),
  constraint ck_recip_filter_payment_type_comp check ( payment_type_comp in (0,1)),
  constraint ck_recip_filter_vop_result_comp check ( vop_result_comp in (0,1)),
  constraint ck_recip_filter_text_comp check ( text_comp in (0,1,2,3)),
  constraint ck_recip_filter_last_usage_comp check ( last_usage_comp in (0,1,2,3)),
  constraint uq_recip_filter_user_id unique (user_id),
  constraint pk_recip_filter primary key (id)
);
create sequence recip_filter_seq;

create table pmt_template (
  id                            integer not null,
  bank_id                       integer not null,
  name                          varchar(80),
  account_id                    integer,
  pmt_type                      integer,
  order_type                    varchar(3),
  file_type                     varchar(50),
  is_credit                     boolean,
  is_urgent                     boolean,
  originator                    varchar(70),
  recipient                     varchar(70),
  amount                        decimal(38,3),
  amount_currency               varchar(3),
  payment_data                  blob,
  folder_id                     integer,
  generic_purpose               varchar(150),
  salary_payment                boolean,
  constraint ck_pmt_template_pmt_type check ( pmt_type in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49)),
  constraint pk_pmt_template primary key (id)
);
create sequence pmt_template_seq;

create table pmt_transfer_type (
  id                            integer not null,
  bank_id                       integer not null,
  pmt_type                      integer,
  order_type                    varchar(50),
  btf                           varchar(50),
  order_type_vop                varchar(50),
  btf_vop                       varchar(50),
  format                        varchar(50),
  constraint ck_pmt_transfer_type_pmt_type check ( pmt_type in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49)),
  constraint pk_pmt_transfer_type primary key (id)
);
create sequence pmt_transfer_type_seq;

create table pdfstatements_filter (
  id                            integer not null,
  user_id                       integer not null,
  from_date                     date,
  to_date                       date,
  date_comp                     integer,
  order_type                    varchar(255),
  order_type_comp               integer not null,
  bank_id                       integer,
  bank_comp                     integer not null,
  statement_active              boolean default false not null,
  account_id                    integer,
  type                          integer,
  constraint ck_pdfstatements_filter_date_comp check ( date_comp in (0,1,2,3)),
  constraint ck_pdfstatements_filter_order_type_comp check ( order_type_comp in (0,1,2,3)),
  constraint ck_pdfstatements_filter_bank_comp check ( bank_comp in (0)),
  constraint ck_pdfstatements_filter_type check ( type in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16)),
  constraint pk_pdfstatements_filter primary key (id)
);
create sequence pdfstatements_filter_seq;

create table pmt_periodic (
  id                            integer not null,
  business_id                   integer,
  created_user_id               integer not null,
  created                       timestamp not null,
  confirmed_user_id             integer,
  confirmed                     timestamp,
  version                       integer not null,
  locking_user_id               integer,
  deleted                       boolean default false not null,
  bank_id                       integer not null,
  account_id                    integer,
  pmt_type                      integer,
  order_type                    varchar(3),
  file_type                     varchar(50),
  is_credit                     boolean,
  is_urgent                     boolean,
  originator                    varchar(70),
  recipient                     varchar(70),
  amount                        decimal(38,3),
  amount_currency               varchar(3),
  purpose                       varchar(140),
  exec_ival                     integer not null,
  first_execution_date          date,
  last_execution_date           date,
  previous_execution_date       date,
  next_execution_date           date,
  payment_data                  blob,
  generic_purpose               varchar(150),
  folder_id                     integer,
  salary_payment                boolean,
  constraint ck_pmt_periodic_version check ( version in (0,1,2)),
  constraint ck_pmt_periodic_pmt_type check ( pmt_type in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49)),
  constraint ck_pmt_periodic_exec_ival check ( exec_ival in (0,1,2,3,4,5,6,7,8,9)),
  constraint pk_pmt_periodic primary key (id)
);
create sequence pmt_periodic_seq;

create table preference (
  id                            integer not null,
  application_id                integer not null,
  pref_key                      varchar(80) not null,
  pref_value                    varchar(255),
  user_id                       integer,
  tenant_id                     integer,
  constraint ck_preference_application_id check ( application_id in (0,1,2,3,4,5,6,7,8,9)),
  constraint uq_preference_1 unique (application_id,pref_key,user_id),
  constraint pk_preference primary key (id)
);
create sequence preference_seq;

create table protocol_setting (
  id                            integer not null,
  bank_id                       integer,
  active                        boolean default false not null,
  protocol_type                 integer,
  last_protocol_fetch           date,
  constraint ck_protocol_setting_protocol_type check ( protocol_type in (0,1,2)),
  constraint uq_protocol_setting_bank_id unique (bank_id),
  constraint pk_protocol_setting primary key (id)
);
create sequence protocol_setting_seq;

create table ptk_entry (
  id                            integer not null,
  bank_id                       integer,
  ptk_time                      timestamp not null,
  axn                           integer not null,
  result                        integer,
  order_number                  varchar(4),
  order_type                    varchar(3),
  data                          clob not null,
  constraint pk_ptk_entry primary key (id)
);
create sequence ptk_entry_seq;

create table ptk_filter (
  id                            integer not null,
  user_id                       integer not null,
  from_date                     date,
  to_date                       date,
  date_comp                     integer,
  order_type                    varchar(255),
  order_type_comp               integer not null,
  order_nr                      varchar(255),
  order_nr_comp                 integer not null,
  axn                           integer,
  result                        integer,
  constraint ck_ptk_filter_date_comp check ( date_comp in (0,1,2,3)),
  constraint ck_ptk_filter_order_type_comp check ( order_type_comp in (0,1,2,3)),
  constraint ck_ptk_filter_order_nr_comp check ( order_nr_comp in (0,1,2,3)),
  constraint pk_ptk_filter primary key (id)
);
create sequence ptk_filter_seq;

create table rsapubkey (
  id                            integer not null,
  exponent                      blob,
  modulo                        blob,
  cert                          blob,
  constraint pk_rsapubkey primary key (id)
);
create sequence rsapubkey_seq;

create table scheduler (
  id                            integer not null,
  bank_id                       integer not null,
  login_user_id                 integer,
  order_or_file_type            varchar(255),
  days                          varchar(255),
  month                         varchar(255),
  hour                          varchar(255),
  minute                        varchar(255),
  year                          varchar(255),
  last_fetch                    timestamp,
  parameter                     varchar(255),
  s_interval                    integer,
  error                         clob,
  constraint ck_scheduler_s_interval check ( s_interval in (0,1,2,3,4)),
  constraint pk_scheduler primary key (id)
);
create sequence scheduler_seq;

create table scl_directory (
  bic                           varchar(11) not null,
  name                          varchar(140),
  sct                           boolean,
  sdd                           boolean,
  cor1                          boolean,
  b2b                           boolean,
  scc                           boolean,
  valid_date                    date,
  constraint pk_scl_directory primary key (bic)
);

create table send_item (
  id                            integer not null,
  bank_id                       integer,
  sent                          timestamp not null,
  file_id                       integer,
  orig_file_name                varchar(250),
  state                         integer,
  sts                           varchar(4),
  cncl_sts                      varchar(4),
  vop_sts                       varchar(4),
  error_code                    varchar(4),
  sender                        varchar(255),
  pmt_type                      integer,
  file_type                     varchar(255),
  order_type                    varchar(3) not null,
  order_number                  varchar(4) not null,
  amount                        decimal(38,3),
  nb_of_txs                     integer,
  signature_hash                varchar(64),
  msg_id                        varchar(35),
  scheme                        varchar(255),
  additional_order_info         varchar(255),
  currency                      varchar(3),
  with_selaries                 boolean,
  manual_approval               boolean,
  callback_id                   integer,
  ip_address                    varchar(255),
  signed_payments               integer,
  constraint ck_send_item_state check ( state in (0,1,2,3,4,5,6,7)),
  constraint ck_send_item_pmt_type check ( pmt_type in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49)),
  constraint ck_send_item_signed_payments check ( signed_payments in (0,1,2)),
  constraint pk_send_item primary key (id)
);
create sequence send_item_seq;

create table send_item_account (
  send_item_id                  integer not null,
  account_id                    integer not null,
  constraint pk_send_item_account primary key (send_item_id,account_id)
);

create table send_filter (
  id                            integer not null,
  user_id                       integer not null,
  bank_id                       integer,
  account_id                    integer,
  send_active                   boolean default false not null,
  ds_signed_active              boolean default false not null,
  ds_cncl_active                boolean default false not null,
  ds_active                     boolean default false not null,
  bank_comp                     integer not null,
  ds_overview_signed            boolean,
  pmt_type                      integer,
  pmt_type_comp                 integer,
  order_type                    varchar(255),
  order_type_comp               integer not null,
  order_nr                      varchar(255),
  order_nr_comp                 integer not null,
  sender                        varchar(255),
  sender_comp                   integer,
  send_state                    integer,
  ds_state                      integer,
  state_comp                    integer not null,
  from_date                     date,
  to_date                       date,
  date_comp                     integer,
  from_amount                   decimal(38,3),
  to_amount                     decimal(38,3),
  amount_comp                   integer,
  constraint ck_send_filter_bank_comp check ( bank_comp in (0)),
  constraint ck_send_filter_pmt_type check ( pmt_type in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49)),
  constraint ck_send_filter_pmt_type_comp check ( pmt_type_comp in (0,1)),
  constraint ck_send_filter_order_type_comp check ( order_type_comp in (0,1,2,3)),
  constraint ck_send_filter_order_nr_comp check ( order_nr_comp in (0,1,2,3)),
  constraint ck_send_filter_sender_comp check ( sender_comp in (0,1,2,3)),
  constraint ck_send_filter_send_state check ( send_state in (0,1,2,3,4,5,6,7,8,9)),
  constraint ck_send_filter_ds_state check ( ds_state in (0,1,2,3,4,5)),
  constraint ck_send_filter_state_comp check ( state_comp in (0)),
  constraint ck_send_filter_date_comp check ( date_comp in (0,1,2,3)),
  constraint ck_send_filter_amount_comp check ( amount_comp in (0,1,2,3)),
  constraint pk_send_filter primary key (id)
);
create sequence send_filter_seq;

create table pmt_signed (
  id                            integer not null,
  account_id                    integer,
  folder_id                     integer,
  send_id                       integer not null,
  booking_id                    integer,
  logical_file                  integer,
  payment_number                integer,
  callback_id                   integer,
  pmt_type                      integer,
  is_credit                     boolean,
  is_urgent                     boolean,
  originator                    varchar(70),
  recipient                     varchar(70),
  amount                        decimal(38,3),
  salary_amount                 decimal(38,3),
  amount_currency               varchar(3),
  purpose                       varchar(140),
  execution_date                timestamp,
  reference                     varchar(50),
  manual_payment                boolean,
  salary_payment                boolean,
  pmt_inf_id                    varchar(35),
  state                         integer,
  sts                           varchar(4),
  status_reason_info            clob,
  cncl_sts                      varchar(4),
  vop_sts                       varchar(4),
  payment_data                  blob,
  constraint ck_pmt_signed_pmt_type check ( pmt_type in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49)),
  constraint ck_pmt_signed_state check ( state in (0,1,2,3,4,5,6,7)),
  constraint pk_pmt_signed primary key (id)
);
create sequence pmt_signed_seq;

create table simple_text_filter (
  id                            integer not null,
  user_id                       integer not null,
  filter_view                   varchar(255) not null,
  filter_text                   varchar(255),
  filter_active                 boolean default false not null,
  constraint pk_simple_text_filter primary key (id)
);
create sequence simple_text_filter_seq;

create table sorting (
  id                            integer not null,
  user_id                       integer,
  table_id                      varchar(255),
  sorting_column                integer,
  sort_ascending                boolean,
  column_order                  varchar(255),
  column_sizes                  varchar(255),
  page_size                     integer,
  additional_information        clob,
  constraint pk_sorting primary key (id)
);
create sequence sorting_seq;

create table tenant (
  id                            integer not null,
  name                          varchar(256) not null,
  user_count                    integer,
  uuid                          uuid,
  admins_uuid                   uuid,
  deleted                       boolean default false not null,
  constraint uq_tenant_name unique (name),
  constraint pk_tenant primary key (id)
);
create sequence tenant_seq;

create table pmt_urgnt_rcpnt (
  id                            integer not null,
  bank_id                       integer not null,
  orgntr_acct_number            varchar(34),
  orgntr_bank_code              varchar(11),
  rcpnt_acct_number             varchar(34),
  rcpnt_bank_code               varchar(11),
  rcpnt_name                    varchar(35),
  rcpnt_tp                      integer,
  constraint ck_pmt_urgnt_rcpnt_rcpnt_tp check ( rcpnt_tp in (0,1)),
  constraint pk_pmt_urgnt_rcpnt primary key (id)
);
create sequence pmt_urgnt_rcpnt_seq;

create table loginuser (
  id                            integer not null,
  name                          varchar(256) not null,
  is_admin                      boolean default false not null,
  security_medium               integer not null,
  enc_key                       blob not null,
  key_dir                       varchar(256),
  iccsn                         varchar(50),
  driver                        varchar(2048),
  alias                         varchar(256),
  serial_number                 varchar(50),
  proxy_password                blob,
  proxy_user                    varchar(256),
  system_name                   varchar(255),
  license_id                    varchar(11),
  web_license_id                varchar(11),
  error_counter                 integer,
  error_sign_counter            integer,
  last_login                    timestamp,
  last_login_error              timestamp,
  last_password_change          date,
  random_id                     varchar(128),
  challenge                     varchar(300),
  last_des_fetch                timestamp,
  given_name                    varchar(256),
  family_name                   varchar(256),
  email                         varchar(256),
  uuid                          uuid,
  deleted                       boolean default false not null,
  constraint ck_loginuser_security_medium check ( security_medium in (0,1,2,3,4)),
  constraint pk_loginuser primary key (id)
);
create sequence loginuser_seq;

create table loginuser_tenant (
  loginuser_id                  integer not null,
  tenant_id                     integer not null,
  constraint pk_loginuser_tenant primary key (loginuser_id,tenant_id)
);

create table loginuser_managed_tenant (
  loginuser_id                  integer not null,
  tenant_id                     integer not null,
  constraint pk_loginuser_managed_tenant primary key (loginuser_id,tenant_id)
);

create table user_effective_permission (
  id                            integer not null,
  bank_user_id                  integer not null,
  account_id                    integer not null,
  pmt_type                      integer not null,
  constraint ck_user_effective_permission_pmt_type check ( pmt_type in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49)),
  constraint pk_user_effective_permission primary key (id)
);
create sequence user_effective_permission_seq;

create table user_notification (
  id                            integer not null,
  user_id                       integer,
  t                             integer,
  info                          blob,
  constraint ck_user_notification_t check ( t in (0,1)),
  constraint pk_user_notification primary key (id)
);
create sequence user_notification_seq;

create table user_permission (
  id                            integer not null,
  bank_user_id                  integer not null,
  order_type_id                 integer,
  auth_level                    integer,
  max_amount                    decimal(38,4),
  max_amount_currency           varchar(3),
  account_permission_id         integer,
  constraint ck_user_permission_auth_level check ( auth_level in (0,1,2,3)),
  constraint pk_user_permission primary key (id)
);
create sequence user_permission_seq;

create table web_authn (
  id                            integer not null,
  yubikey_id                    integer,
  counter                       bigint,
  rp_id                         varchar(255),
  serialized_data               blob,
  constraint uq_web_authn_yubikey_id unique (yubikey_id),
  constraint pk_web_authn primary key (id)
);
create sequence web_authn_seq;

create table workspace_file (
  id                            integer not null,
  prefix_id                     integer not null,
  deleted                       boolean default false not null,
  path                          varchar(256) not null,
  file_size                     bigint,
  md5hash                       varchar(32),
  sha256hash                    varchar(64),
  constraint pk_workspace_file primary key (id)
);
create sequence workspace_file_seq;

create table workspace_file_cluster_node (
  workspace_file_id             integer not null,
  cluster_node_id               integer not null,
  constraint pk_workspace_file_cluster_node primary key (workspace_file_id,cluster_node_id)
);

create table yubikey (
  id                            integer not null,
  user_id                       integer,
  public_id                     varchar(2048),
  description                   varchar(255),
  used_since                    date,
  security_type                 integer,
  constraint ck_yubikey_security_type check ( security_type in (0,1,2)),
  constraint pk_yubikey primary key (id)
);
create sequence yubikey_seq;

create table yubikey_history (
  id                            integer not null,
  user_id                       integer,
  public_id                     varchar(2048),
  opt                           varchar(2048),
  error_message                 varchar(255),
  time_stamp                    timestamp,
  constraint pk_yubikey_history primary key (id)
);
create sequence yubikey_history_seq;

create table zip_filter (
  id                            integer not null,
  position                      integer default 0 not null,
  scheduler_id                  integer not null,
  reg_ex_pattern                varchar(255),
  folder                        varchar(255),
  constraint pk_zip_filter primary key (id)
);
create sequence zip_filter_seq;

create index ix_account_cm_identification on account (bank_id,cm_identification);
create index ix_account_iban on account (bank_id,iban,currency);
create index ix_account_iban_bic on account (bank_id,iban,bic,currency);
create index ix_account_german on account (bank_id,de_bank_code,de_account_number,currency);
create index ix_account_french on account (bank_id,fr_bank_code,fr_branch_code,fr_account_number,currency);
create index ix_awv_entry_report_month on awv_entry (month);
create index ix_cm_booking_statement_pos on cm_booking (statement_id,pos);
create index ix_cm_booking_account_msg_id on cm_booking (account_id,msg_id);
create index ix_notification_trx_status_recipient_account on notification_trx (tx_sts,recipient,recipient_account_number);
create index ix_pmt_open_order_type on pmt_open (order_type);
create index ix_pmt_open_file_type on pmt_open (file_type);
create index ix_pmt_recipient_display_name on pmt_recipient (payment_type,display_name);
create index ix_pmt_recipient_name on pmt_recipient (payment_type,name);
create index ix_pmt_template_order_type on pmt_template (order_type);
create index ix_pmt_template_file_type on pmt_template (file_type);
create index ix_pmt_periodic_order_type on pmt_periodic (order_type);
create index ix_pmt_periodic_file_type on pmt_periodic (file_type);
create index ix_send_item_bank_msg_id on send_item (bank_id,msg_id);
create index ix_pmt_signed_execution_date on pmt_signed (execution_date,account_id);
create index ix_workspace_file_prefix_id_path on workspace_file (prefix_id,path);
create index ix_account_bank_1 on account (bank_id);
alter table account add constraint fk_account_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_account_sepa_originator_id on account (sepa_originator_id);
alter table account add constraint fk_account_sepa_originator_id foreign key (sepa_originator_id) references pmt_originator (id) on delete restrict on update restrict;

create index ix_account_dtazv_originator_id on account (dtazv_originator_id);
alter table account add constraint fk_account_dtazv_originator_id foreign key (dtazv_originator_id) references pmt_originator (id) on delete restrict on update restrict;

create index ix_account_mt101_originator_id on account (mt101_originator_id);
alter table account add constraint fk_account_mt101_originator_id foreign key (mt101_originator_id) references pmt_originator (id) on delete restrict on update restrict;

create index ix_account_folder_1 on account (folder_id);
alter table account add constraint fk_account_folder_1 foreign key (folder_id) references cm_folder (id) on delete restrict on update restrict;

create index ix_account_permission_bankUser_1 on account_permission (bank_user_id);
alter table account_permission add constraint fk_account_permission_bankUser_1 foreign key (bank_user_id) references bankuser (id) on delete restrict on update restrict;

create index ix_account_permission_account_1 on account_permission (account_id);
alter table account_permission add constraint fk_account_permission_account_1 foreign key (account_id) references account (id) on delete restrict on update restrict;

create index ix_ap_overwrite_bankUser_1 on ap_overwrite (bank_user_id);
alter table ap_overwrite add constraint fk_ap_overwrite_bankUser_1 foreign key (bank_user_id) references bankuser (id) on delete restrict on update restrict;

create index ix_ap_overwrite_account_1 on ap_overwrite (account_id);
alter table ap_overwrite add constraint fk_ap_overwrite_account_1 foreign key (account_id) references account (id) on delete restrict on update restrict;

create index ix_automatic_export_conversion_1 on automatic_export (conversion_id);
alter table automatic_export add constraint fk_automatic_export_conversion_1 foreign key (conversion_id) references conversion (id) on delete restrict on update restrict;

create index ix_automatic_export_tenant_1 on automatic_export (tenant_id);
alter table automatic_export add constraint fk_automatic_export_tenant_1 foreign key (tenant_id) references tenant (id) on delete restrict on update restrict;

create index ix_automatic_export_account_automatic_export on automatic_export_account (automatic_export_id);
alter table automatic_export_account add constraint fk_automatic_export_account_a_01 foreign key (automatic_export_id) references automatic_export (id) on delete restrict on update restrict;

create index ix_automatic_export_account_account on automatic_export_account (account_id);
alter table automatic_export_account add constraint fk_automatic_export_account_a_02 foreign key (account_id) references account (id) on delete restrict on update restrict;

create index ix_automatic_export_folder_automatic_export on automatic_export_folder (automatic_export_id);
alter table automatic_export_folder add constraint fk_automatic_export_folder_automatic_export foreign key (automatic_export_id) references automatic_export (id) on delete restrict on update restrict;

create index ix_automatic_export_folder_cm_folder on automatic_export_folder (cm_folder_id);
alter table automatic_export_folder add constraint fk_automatic_export_folder_cm_folder foreign key (cm_folder_id) references cm_folder (id) on delete restrict on update restrict;

create index ix_awv_dika_abstractEntry_1 on awv_dika (abstract_entry_id);
alter table awv_dika add constraint fk_awv_dika_abstractEntry_1 foreign key (abstract_entry_id) references awv_entry (id) on delete restrict on update restrict;

create index ix_awv_dirinv_abstractEntry_1 on awv_dirinv (abstract_entry_id);
alter table awv_dirinv add constraint fk_awv_dirinv_abstractEntry_1 foreign key (abstract_entry_id) references awv_entry (id) on delete restrict on update restrict;

create index ix_awv_entry_entryReporter_1 on awv_entry (reporter);
alter table awv_entry add constraint fk_awv_entry_entryReporter_1 foreign key (reporter) references awv_contact (id) on delete restrict on update restrict;

create index ix_awv_entry_tenant_1 on awv_entry (tenant_id);
alter table awv_entry add constraint fk_awv_entry_tenant_1 foreign key (tenant_id) references tenant (id) on delete restrict on update restrict;

create index ix_awv_entry_signedPayment_1 on awv_entry (signed_payment_id);
alter table awv_entry add constraint fk_awv_entry_signedPayment_1 foreign key (signed_payment_id) references pmt_signed (id) on delete restrict on update restrict;

create index ix_awv_entry_cmBooking_1 on awv_entry (cm_booking_id);
alter table awv_entry add constraint fk_awv_entry_cmBooking_1 foreign key (cm_booking_id) references cm_booking (id) on delete restrict on update restrict;

create index ix_awv_export_tenant_1 on awv_export (tenant_id);
alter table awv_export add constraint fk_awv_export_tenant_1 foreign key (tenant_id) references tenant (id) on delete restrict on update restrict;

create index ix_awv_company_tenant_1 on awv_company (tenant_id);
alter table awv_company add constraint fk_awv_company_tenant_1 foreign key (tenant_id) references tenant (id) on delete restrict on update restrict;

create index ix_awv_contact_company_1 on awv_contact (company);
alter table awv_contact add constraint fk_awv_contact_company_1 foreign key (company) references awv_company (id) on delete restrict on update restrict;

create index ix_awv_transit_abstractEntry_1 on awv_transit (abstract_entry_id);
alter table awv_transit add constraint fk_awv_transit_abstractEntry_1 foreign key (abstract_entry_id) references awv_entry (id) on delete restrict on update restrict;

create index ix_bank_e001Key_1 on bank (e001key_id);
alter table bank add constraint fk_bank_e001Key_1 foreign key (e001key_id) references rsapubkey (id) on delete restrict on update restrict;

create index ix_bank_e002Key_1 on bank (e002key_id);
alter table bank add constraint fk_bank_e002Key_1 foreign key (e002key_id) references rsapubkey (id) on delete restrict on update restrict;

create index ix_bank_x001Key_1 on bank (x001key_id);
alter table bank add constraint fk_bank_x001Key_1 foreign key (x001key_id) references rsapubkey (id) on delete restrict on update restrict;

create index ix_bank_x002Key_1 on bank (x002key_id);
alter table bank add constraint fk_bank_x002Key_1 foreign key (x002key_id) references rsapubkey (id) on delete restrict on update restrict;

create index ix_bank_tenant_1 on bank (tenant_id);
alter table bank add constraint fk_bank_tenant_1 foreign key (tenant_id) references tenant (id) on delete restrict on update restrict;

create index ix_bankuser_bank_1 on bankuser (bank_id);
alter table bankuser add constraint fk_bankuser_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_bankuser_user_1 on bankuser (user_id);
alter table bankuser add constraint fk_bankuser_user_1 foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

alter table bank_user_htd_info add constraint fk_bank_user_htd_info_bankUser_1 foreign key (bank_user_id) references bankuser (id) on delete restrict on update restrict;

create index ix_cm_balance_account_1 on cm_balance (account_id);
alter table cm_balance add constraint fk_cm_balance_account_1 foreign key (account_id) references account (id) on delete restrict on update restrict;

create index ix_cm_balance2_account_1 on cm_balance2 (account_id);
alter table cm_balance2 add constraint fk_cm_balance2_account_1 foreign key (account_id) references account (id) on delete restrict on update restrict;

alter table cm_bank add constraint fk_cm_bank_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_cm_booking_statement_1 on cm_booking (statement_id);
alter table cm_booking add constraint fk_cm_booking_statement_1 foreign key (statement_id) references cm_statement (id) on delete restrict on update restrict;

create index ix_cm_booking_page_1 on cm_booking (page_id);
alter table cm_booking add constraint fk_cm_booking_page_1 foreign key (page_id) references cm_page (id) on delete restrict on update restrict;

create index ix_cm_booking_account_1 on cm_booking (account_id);
alter table cm_booking add constraint fk_cm_booking_account_1 foreign key (account_id) references account (id) on delete restrict on update restrict;

create index ix_cm_booking_parentBooking_1 on cm_booking (parent_booking_id);
alter table cm_booking add constraint fk_cm_booking_parentBooking_1 foreign key (parent_booking_id) references cm_booking (id) on delete restrict on update restrict;

alter table cm_b_filter add constraint fk_cm_b_filter_user_1 foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_cm_charge_booking_id on cm_charge (booking_id);
alter table cm_charge add constraint fk_cm_charge_booking_id foreign key (booking_id) references cm_booking (id) on delete restrict on update restrict;

create index ix_cm_charge_statement_id on cm_charge (statement_id);
alter table cm_charge add constraint fk_cm_charge_statement_id foreign key (statement_id) references cm_statement (id) on delete restrict on update restrict;

create index ix_cm_charge_page_id on cm_charge (page_id);
alter table cm_charge add constraint fk_cm_charge_page_id foreign key (page_id) references cm_page (id) on delete restrict on update restrict;

create index ix_cm_check_login_1 on cm_check (login_id);
alter table cm_check add constraint fk_cm_check_login_1 foreign key (login_id) references loginuser (id) on delete restrict on update restrict;

create index ix_cm_check_statement_1 on cm_check (statement_id);
alter table cm_check add constraint fk_cm_check_statement_1 foreign key (statement_id) references cm_statement (id) on delete restrict on update restrict;

create index ix_cm_check_page_1 on cm_check (page_id);
alter table cm_check add constraint fk_cm_check_page_1 foreign key (page_id) references cm_page (id) on delete restrict on update restrict;

create index ix_cm_folder_tenant_1 on cm_folder (tenant_id);
alter table cm_folder add constraint fk_cm_folder_tenant_1 foreign key (tenant_id) references tenant (id) on delete restrict on update restrict;

create index ix_cm_page_statement_1 on cm_page (statement_id);
alter table cm_page add constraint fk_cm_page_statement_1 foreign key (statement_id) references cm_statement (id) on delete restrict on update restrict;

create index ix_cm_page_file_id on cm_page (file_id);
alter table cm_page add constraint fk_cm_page_file_id foreign key (file_id) references workspace_file (id) on delete restrict on update restrict;

create index ix_cm_pdf_statement_bank_1 on cm_pdf_statement (bank_id);
alter table cm_pdf_statement add constraint fk_cm_pdf_statement_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_cm_pdf_statement_account_1 on cm_pdf_statement (account_id);
alter table cm_pdf_statement add constraint fk_cm_pdf_statement_account_1 foreign key (account_id) references account (id) on delete restrict on update restrict;

create index ix_cm_pdf_statement_local_file_id on cm_pdf_statement (local_file_id);
alter table cm_pdf_statement add constraint fk_cm_pdf_statement_local_file_id foreign key (local_file_id) references workspace_file (id) on delete restrict on update restrict;

create index ix_cm_statement_account_1 on cm_statement (account_id);
alter table cm_statement add constraint fk_cm_statement_account_1 foreign key (account_id) references account (id) on delete restrict on update restrict;

create index ix_cm_statement_file_id on cm_statement (file_id);
alter table cm_statement add constraint fk_cm_statement_file_id foreign key (file_id) references workspace_file (id) on delete restrict on update restrict;

create index ix_cm_value_group_tenant_1 on cm_value_group (tenant_id);
alter table cm_value_group add constraint fk_cm_value_group_tenant_1 foreign key (tenant_id) references tenant (id) on delete restrict on update restrict;

create index ix_cm_value_group_account_cm_value_group on cm_value_group_account (cm_value_group_id);
alter table cm_value_group_account add constraint fk_cm_value_group_account_cm__01 foreign key (cm_value_group_id) references cm_value_group (id) on delete restrict on update restrict;

create index ix_cm_value_group_account_account on cm_value_group_account (account_id);
alter table cm_value_group_account add constraint fk_cm_value_group_account_acc_02 foreign key (account_id) references account (id) on delete restrict on update restrict;

create index ix_cm_value_group_folder_cm_value_group on cm_value_group_folder (cm_value_group_id);
alter table cm_value_group_folder add constraint fk_cm_value_group_folder_cm_v_01 foreign key (cm_value_group_id) references cm_value_group (id) on delete restrict on update restrict;

create index ix_cm_value_group_folder_cm_folder on cm_value_group_folder (cm_folder_id);
alter table cm_value_group_folder add constraint fk_cm_value_group_folder_cm_f_02 foreign key (cm_folder_id) references cm_folder (id) on delete restrict on update restrict;

create index ix_conversion_tenant_1 on conversion (tenant_id);
alter table conversion add constraint fk_conversion_tenant_1 foreign key (tenant_id) references tenant (id) on delete restrict on update restrict;

create index ix_sepa_converter_format_tenan_1 on sepa_converter_format (tenant_id);
alter table sepa_converter_format add constraint fk_sepa_converter_format_tenan_1 foreign key (tenant_id) references tenant (id) on delete restrict on update restrict;

create index ix_directory_scanner_bank_1 on directory_scanner (bank_id);
alter table directory_scanner add constraint fk_directory_scanner_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

alter table ds_bank add constraint fk_ds_bank_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_ds_open_order_bankUser_1 on ds_open_order (bank_user_id);
alter table ds_open_order add constraint fk_ds_open_order_bankUser_1 foreign key (bank_user_id) references bankuser (id) on delete restrict on update restrict;

create index ix_ds_open_order_order_data_id on ds_open_order (order_data_id);
alter table ds_open_order add constraint fk_ds_open_order_order_data_id foreign key (order_data_id) references workspace_file (id) on delete restrict on update restrict;

create index ix_ds_open_order_payment_data_id on ds_open_order (payment_data_id);
alter table ds_open_order add constraint fk_ds_open_order_payment_data_id foreign key (payment_data_id) references workspace_file (id) on delete restrict on update restrict;

create index ix_ds_open_order_signer_dsOpen_1 on ds_open_order_signer (ds_open_order_id);
alter table ds_open_order_signer add constraint fk_ds_open_order_signer_dsOpen_1 foreign key (ds_open_order_id) references ds_open_order (id) on delete restrict on update restrict;

create index ix_ds_order_details_bank_1 on ds_order_details (bank_id);
alter table ds_order_details add constraint fk_ds_order_details_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_ds_order_details_data_file_id on ds_order_details (data_file_id);
alter table ds_order_details add constraint fk_ds_order_details_data_file_id foreign key (data_file_id) references workspace_file (id) on delete restrict on update restrict;

create index ix_ds_order_details_account_ds_order_details on ds_order_details_account (ds_order_details_id);
alter table ds_order_details_account add constraint fk_ds_order_details_account_d_01 foreign key (ds_order_details_id) references ds_order_details (id) on delete restrict on update restrict;

create index ix_ds_order_details_account_account on ds_order_details_account (account_id);
alter table ds_order_details_account add constraint fk_ds_order_details_account_a_02 foreign key (account_id) references account (id) on delete restrict on update restrict;

create index ix_ds_signing_info_dsOrderDeta_1 on ds_signing_info (ds_order_details_id);
alter table ds_signing_info add constraint fk_ds_signing_info_dsOrderDeta_1 foreign key (ds_order_details_id) references ds_order_details (id) on delete restrict on update restrict;

create index ix_export_file_workspace_file_id on export_file (workspace_file_id);
alter table export_file add constraint fk_export_file_workspace_file_id foreign key (workspace_file_id) references workspace_file (id) on delete restrict on update restrict;

create index ix_export_file_account_export_file on export_file_account (export_file_id);
alter table export_file_account add constraint fk_export_file_account_export_01 foreign key (export_file_id) references export_file (id) on delete restrict on update restrict;

create index ix_export_file_account_account on export_file_account (account_id);
alter table export_file_account add constraint fk_export_file_account_accoun_02 foreign key (account_id) references account (id) on delete restrict on update restrict;

create index ix_export_file_aut_export_export_file on export_file_aut_export (export_file_id);
alter table export_file_aut_export add constraint fk_export_file_aut_export_exp_01 foreign key (export_file_id) references export_file (id) on delete restrict on update restrict;

create index ix_export_file_aut_export_automatic_export on export_file_aut_export (automatic_export_id);
alter table export_file_aut_export add constraint fk_export_file_aut_export_aut_02 foreign key (automatic_export_id) references automatic_export (id) on delete restrict on update restrict;

create index ix_exportfile_filter_user_id on exportfile_filter (user_id);
alter table exportfile_filter add constraint fk_exportfile_filter_user_id foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_fetch_item_bank_1 on fetch_item (bank_id);
alter table fetch_item add constraint fk_fetch_item_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_fetch_item_file_id on fetch_item (file_id);
alter table fetch_item add constraint fk_fetch_item_file_id foreign key (file_id) references workspace_file (id) on delete restrict on update restrict;

create index ix_fe_filter_user_1 on fe_filter (user_id);
alter table fe_filter add constraint fk_fe_filter_user_1 foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_fe_filter_bank_1 on fe_filter (bank_id);
alter table fe_filter add constraint fk_fe_filter_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_hac_entry_bank_1 on hac_entry (bank_id);
alter table hac_entry add constraint fk_hac_entry_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_hac_filter_user_1 on hac_filter (user_id);
alter table hac_filter add constraint fk_hac_filter_user_1 foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_log_tenant_id on log (tenant_id);
alter table log add constraint fk_log_tenant_id foreign key (tenant_id) references tenant (id) on delete restrict on update restrict;

create index ix_log_account_id on log (account_id);
alter table log add constraint fk_log_account_id foreign key (account_id) references account (id) on delete restrict on update restrict;

create index ix_log_actor_id on log (actor_id);
alter table log add constraint fk_log_actor_id foreign key (actor_id) references loginuser (id) on delete restrict on update restrict;

alter table log_filter add constraint fk_log_filter_user_id foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_login_session_user_id on login_session (user_id);
alter table login_session add constraint fk_login_session_user_id foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_notification_bank_1 on notification (bank_id);
alter table notification add constraint fk_notification_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_notification_file_id on notification (file_id);
alter table notification add constraint fk_notification_file_id foreign key (file_id) references workspace_file (id) on delete restrict on update restrict;

create index ix_notification_send_1 on notification (send_id);
alter table notification add constraint fk_notification_send_1 foreign key (send_id) references send_item (id) on delete restrict on update restrict;

create index ix_nf_filter_user_1 on nf_filter (user_id);
alter table nf_filter add constraint fk_nf_filter_user_1 foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_nf_filter_bank_1 on nf_filter (bank_id);
alter table nf_filter add constraint fk_nf_filter_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_notification_pmt_inf_notifi_1 on notification_pmt_inf (notification_id);
alter table notification_pmt_inf add constraint fk_notification_pmt_inf_notifi_1 foreign key (notification_id) references notification (id) on delete restrict on update restrict;

alter table nf_setting add constraint fk_nf_setting_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_notification_trx_notificati_1 on notification_trx (notification_id);
alter table notification_trx add constraint fk_notification_trx_notificati_1 foreign key (notification_id) references notification (id) on delete restrict on update restrict;

create index ix_notification_trx_pmtInf_1 on notification_trx (pmt_inf_id);
alter table notification_trx add constraint fk_notification_trx_pmtInf_1 foreign key (pmt_inf_id) references notification_pmt_inf (id) on delete restrict on update restrict;

create index ix_notification_trx_send_1 on notification_trx (send_id);
alter table notification_trx add constraint fk_notification_trx_send_1 foreign key (send_id) references send_item (id) on delete restrict on update restrict;

create index ix_notification_trx_signedPaym_1 on notification_trx (signed_payment_id);
alter table notification_trx add constraint fk_notification_trx_signedPaym_1 foreign key (signed_payment_id) references pmt_signed (id) on delete restrict on update restrict;

create index ix_open_id_token_user_id on open_id_token (user_id);
alter table open_id_token add constraint fk_open_id_token_user_id foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_pmt_open_createdUser_1 on pmt_open (created_user_id);
alter table pmt_open add constraint fk_pmt_open_createdUser_1 foreign key (created_user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_pmt_open_confirmedUser_1 on pmt_open (confirmed_user_id);
alter table pmt_open add constraint fk_pmt_open_confirmedUser_1 foreign key (confirmed_user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_pmt_open_lockingUser_1 on pmt_open (locking_user_id);
alter table pmt_open add constraint fk_pmt_open_lockingUser_1 foreign key (locking_user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_pmt_open_bank_1 on pmt_open (bank_id);
alter table pmt_open add constraint fk_pmt_open_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_pmt_open_account_1 on pmt_open (account_id);
alter table pmt_open add constraint fk_pmt_open_account_1 foreign key (account_id) references account (id) on delete restrict on update restrict;

create index ix_pmt_open_folder_1 on pmt_open (folder_id);
alter table pmt_open add constraint fk_pmt_open_folder_1 foreign key (folder_id) references pmt_folder (id) on delete restrict on update restrict;

create index ix_order_type_bank_1 on order_type (bank_id);
alter table order_type add constraint fk_order_type_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_password_history_user_1 on password_history (user_id);
alter table password_history add constraint fk_password_history_user_1 foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

alter table pmt_filter add constraint fk_pmt_filter_user_1 foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_pmt_folder_tenant_1 on pmt_folder (tenant_id);
alter table pmt_folder add constraint fk_pmt_folder_tenant_1 foreign key (tenant_id) references tenant (id) on delete restrict on update restrict;

create index ix_pmt_originator_tenant_1 on pmt_originator (tenant_id);
alter table pmt_originator add constraint fk_pmt_originator_tenant_1 foreign key (tenant_id) references tenant (id) on delete restrict on update restrict;

create index ix_pmt_originator_default_account_id on pmt_originator (default_account_id);
alter table pmt_originator add constraint fk_pmt_originator_default_account_id foreign key (default_account_id) references account (id) on delete restrict on update restrict;

alter table pmt_props add constraint fk_pmt_props_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_pmt_recipient_createdUser_1 on pmt_recipient (created_user_id);
alter table pmt_recipient add constraint fk_pmt_recipient_createdUser_1 foreign key (created_user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_pmt_recipient_confirmedUser_1 on pmt_recipient (confirmed_user_id);
alter table pmt_recipient add constraint fk_pmt_recipient_confirmedUser_1 foreign key (confirmed_user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_pmt_recipient_lockingUser_1 on pmt_recipient (locking_user_id);
alter table pmt_recipient add constraint fk_pmt_recipient_lockingUser_1 foreign key (locking_user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_pmt_recipient_tenant_1 on pmt_recipient (tenant_id);
alter table pmt_recipient add constraint fk_pmt_recipient_tenant_1 foreign key (tenant_id) references tenant (id) on delete restrict on update restrict;

alter table recip_filter add constraint fk_recip_filter_user_id foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_pmt_template_bank_1 on pmt_template (bank_id);
alter table pmt_template add constraint fk_pmt_template_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_pmt_template_account_1 on pmt_template (account_id);
alter table pmt_template add constraint fk_pmt_template_account_1 foreign key (account_id) references account (id) on delete restrict on update restrict;

create index ix_pmt_template_folder_1 on pmt_template (folder_id);
alter table pmt_template add constraint fk_pmt_template_folder_1 foreign key (folder_id) references pmt_folder (id) on delete restrict on update restrict;

create index ix_pmt_transfer_type_bank_1 on pmt_transfer_type (bank_id);
alter table pmt_transfer_type add constraint fk_pmt_transfer_type_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_pdfstatements_filter_user_id on pdfstatements_filter (user_id);
alter table pdfstatements_filter add constraint fk_pdfstatements_filter_user_id foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_pdfstatements_filter_bank_id on pdfstatements_filter (bank_id);
alter table pdfstatements_filter add constraint fk_pdfstatements_filter_bank_id foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_pmt_periodic_createdUser_1 on pmt_periodic (created_user_id);
alter table pmt_periodic add constraint fk_pmt_periodic_createdUser_1 foreign key (created_user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_pmt_periodic_confirmedUser_1 on pmt_periodic (confirmed_user_id);
alter table pmt_periodic add constraint fk_pmt_periodic_confirmedUser_1 foreign key (confirmed_user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_pmt_periodic_lockingUser_1 on pmt_periodic (locking_user_id);
alter table pmt_periodic add constraint fk_pmt_periodic_lockingUser_1 foreign key (locking_user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_pmt_periodic_bank_1 on pmt_periodic (bank_id);
alter table pmt_periodic add constraint fk_pmt_periodic_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_pmt_periodic_account_1 on pmt_periodic (account_id);
alter table pmt_periodic add constraint fk_pmt_periodic_account_1 foreign key (account_id) references account (id) on delete restrict on update restrict;

create index ix_pmt_periodic_folder_1 on pmt_periodic (folder_id);
alter table pmt_periodic add constraint fk_pmt_periodic_folder_1 foreign key (folder_id) references pmt_folder (id) on delete restrict on update restrict;

create index ix_preference_user_1 on preference (user_id);
alter table preference add constraint fk_preference_user_1 foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_preference_tenant_1 on preference (tenant_id);
alter table preference add constraint fk_preference_tenant_1 foreign key (tenant_id) references tenant (id) on delete restrict on update restrict;

alter table protocol_setting add constraint fk_protocol_setting_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_ptk_entry_bank_1 on ptk_entry (bank_id);
alter table ptk_entry add constraint fk_ptk_entry_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_ptk_filter_user_1 on ptk_filter (user_id);
alter table ptk_filter add constraint fk_ptk_filter_user_1 foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_scheduler_bank_id on scheduler (bank_id);
alter table scheduler add constraint fk_scheduler_bank_id foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_scheduler_login_user_id on scheduler (login_user_id);
alter table scheduler add constraint fk_scheduler_login_user_id foreign key (login_user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_send_item_bank_1 on send_item (bank_id);
alter table send_item add constraint fk_send_item_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_send_item_file_id on send_item (file_id);
alter table send_item add constraint fk_send_item_file_id foreign key (file_id) references workspace_file (id) on delete restrict on update restrict;

create index ix_send_item_callback_1 on send_item (callback_id);
alter table send_item add constraint fk_send_item_callback_1 foreign key (callback_id) references send_item (id) on delete restrict on update restrict;

create index ix_send_item_account_send_item on send_item_account (send_item_id);
alter table send_item_account add constraint fk_send_item_account_send_ite_01 foreign key (send_item_id) references send_item (id) on delete restrict on update restrict;

create index ix_send_item_account_account on send_item_account (account_id);
alter table send_item_account add constraint fk_send_item_account_account_02 foreign key (account_id) references account (id) on delete restrict on update restrict;

create index ix_send_filter_user_1 on send_filter (user_id);
alter table send_filter add constraint fk_send_filter_user_1 foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_send_filter_bank_1 on send_filter (bank_id);
alter table send_filter add constraint fk_send_filter_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_send_filter_account_1 on send_filter (account_id);
alter table send_filter add constraint fk_send_filter_account_1 foreign key (account_id) references account (id) on delete restrict on update restrict;

create index ix_pmt_signed_account_1 on pmt_signed (account_id);
alter table pmt_signed add constraint fk_pmt_signed_account_1 foreign key (account_id) references account (id) on delete restrict on update restrict;

create index ix_pmt_signed_folder_1 on pmt_signed (folder_id);
alter table pmt_signed add constraint fk_pmt_signed_folder_1 foreign key (folder_id) references pmt_folder (id) on delete restrict on update restrict;

create index ix_pmt_signed_send_1 on pmt_signed (send_id);
alter table pmt_signed add constraint fk_pmt_signed_send_1 foreign key (send_id) references send_item (id) on delete restrict on update restrict;

create index ix_pmt_signed_booking_id on pmt_signed (booking_id);
alter table pmt_signed add constraint fk_pmt_signed_booking_id foreign key (booking_id) references cm_booking (id) on delete restrict on update restrict;

create index ix_pmt_signed_callback_1 on pmt_signed (callback_id);
alter table pmt_signed add constraint fk_pmt_signed_callback_1 foreign key (callback_id) references send_item (id) on delete restrict on update restrict;

create index ix_simple_text_filter_user_1 on simple_text_filter (user_id);
alter table simple_text_filter add constraint fk_simple_text_filter_user_1 foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_sorting_user_1 on sorting (user_id);
alter table sorting add constraint fk_sorting_user_1 foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_pmt_urgnt_rcpnt_bank_1 on pmt_urgnt_rcpnt (bank_id);
alter table pmt_urgnt_rcpnt add constraint fk_pmt_urgnt_rcpnt_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;

create index ix_loginuser_license_1 on loginuser (license_id);
alter table loginuser add constraint fk_loginuser_license_1 foreign key (license_id) references license (id) on delete restrict on update restrict;

create index ix_loginuser_webLicense_1 on loginuser (web_license_id);
alter table loginuser add constraint fk_loginuser_webLicense_1 foreign key (web_license_id) references license (id) on delete restrict on update restrict;

create index ix_loginuser_tenant_loginuser on loginuser_tenant (loginuser_id);
alter table loginuser_tenant add constraint fk_loginuser_tenant_loginuser_01 foreign key (loginuser_id) references loginuser (id) on delete restrict on update restrict;

create index ix_loginuser_tenant_tenant on loginuser_tenant (tenant_id);
alter table loginuser_tenant add constraint fk_loginuser_tenant_tenant_02 foreign key (tenant_id) references tenant (id) on delete restrict on update restrict;

create index ix_loginuser_managed_tenant_loginuser on loginuser_managed_tenant (loginuser_id);
alter table loginuser_managed_tenant add constraint fk_loginuser_managed_tenant_l_01 foreign key (loginuser_id) references loginuser (id) on delete restrict on update restrict;

create index ix_loginuser_managed_tenant_tenant on loginuser_managed_tenant (tenant_id);
alter table loginuser_managed_tenant add constraint fk_loginuser_managed_tenant_t_02 foreign key (tenant_id) references tenant (id) on delete restrict on update restrict;

create index ix_user_effective_permission_bank_user_id on user_effective_permission (bank_user_id);
alter table user_effective_permission add constraint fk_user_effective_permission_bank_user_id foreign key (bank_user_id) references bankuser (id) on delete restrict on update restrict;

create index ix_user_effective_permission_account_id on user_effective_permission (account_id);
alter table user_effective_permission add constraint fk_user_effective_permission_account_id foreign key (account_id) references account (id) on delete restrict on update restrict;

create index ix_user_notification_user_id on user_notification (user_id);
alter table user_notification add constraint fk_user_notification_user_id foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_user_permission_bankUser_1 on user_permission (bank_user_id);
alter table user_permission add constraint fk_user_permission_bankUser_1 foreign key (bank_user_id) references bankuser (id) on delete restrict on update restrict;

create index ix_user_permission_orderType_1 on user_permission (order_type_id);
alter table user_permission add constraint fk_user_permission_orderType_1 foreign key (order_type_id) references order_type (id) on delete restrict on update restrict;

create index ix_user_permission_accountPerm_1 on user_permission (account_permission_id);
alter table user_permission add constraint fk_user_permission_accountPerm_1 foreign key (account_permission_id) references account_permission (id) on delete restrict on update restrict;

alter table web_authn add constraint fk_web_authn_yubikey_1 foreign key (yubikey_id) references yubikey (id) on delete restrict on update restrict;

create index ix_workspace_file_cluster_node_workspace_file on workspace_file_cluster_node (workspace_file_id);
alter table workspace_file_cluster_node add constraint fk_workspace_file_cluster_node_workspace_file foreign key (workspace_file_id) references workspace_file (id) on delete restrict on update restrict;

create index ix_workspace_file_cluster_node_cluster_node on workspace_file_cluster_node (cluster_node_id);
alter table workspace_file_cluster_node add constraint fk_workspace_file_cluster_node_cluster_node foreign key (cluster_node_id) references cluster_node (id) on delete restrict on update restrict;

create index ix_yubikey_user_1 on yubikey (user_id);
alter table yubikey add constraint fk_yubikey_user_1 foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_yubikey_history_user_1 on yubikey_history (user_id);
alter table yubikey_history add constraint fk_yubikey_history_user_1 foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_zip_filter_scheduler_1 on zip_filter (scheduler_id);
alter table zip_filter add constraint fk_zip_filter_scheduler_1 foreign key (scheduler_id) references scheduler (id) on delete restrict on update restrict;


# don't know how to remove these indexes in a update, so create them to satisfy the test
create index ix_bank_user_htd_info_bankUser_1 on bank_user_htd_info (bank_user_id);
create index ix_cm_bank_bank_1 on cm_bank (bank_id);
create index ix_cm_b_filter_user_1 on cm_b_filter (user_id);
create index ix_ds_bank_bank_1 on ds_bank (bank_id);
create index ix_pmt_filter_user_1 on pmt_filter (user_id);
create index ix_pmt_props_bank_1 on pmt_props (bank_id);


INSERT INTO applicationinfo (prop_name, prop_value) VALUES ('db_layout', '379');
