/**
 * Parameters for the current script
 * @type {
 *     {challenge : string},
 *     {rp : {
 *         name : string,
 *         id : string
 *     }},
 *     {user : {
 *         id : string,
 *         name : string,
 *         displayName : string
 *     }}
 * }
 */
const yubikeyAddWebAuthnViewParams = JSON.parse(atob($('#yubikeyAddWebAuthnView_js').data('params')));

// Build the object for registration
function publicKeyCredentialCreationOptions() {
    const stringToUint8Array = function (str) {
        let result = [];
        str.split(',').forEach(function (challengeId) {
            result.push(parseInt(challengeId));
        });
        return new Uint8Array(result);
    }

    return {
        challenge: stringToUint8Array(yubikeyAddWebAuthnViewParams.challenge),
        rp: yubikeyAddWebAuthnViewParams.rp,
        user: {
            id: stringToUint8Array(yubikeyAddWebAuthnViewParams.user.id),
            name: yubikeyAddWebAuthnViewParams.user.name,
            displayName: yubikeyAddWebAuthnViewParams.user.displayName
        },
        pubKeyCredParams: [{alg: -7, type: "public-key"}, {alg: -257, type: "public-key"}],
        authenticatorSelection: {
            authenticatorAttachment: "cross-platform",
            userVerification: "discouraged"
        },
    }
}

function register() {
    // Ask the browser to create the credential
    $('#errorMsg').hide();

    navigator.credentials.create({
        publicKey: publicKeyCredentialCreationOptions()
    }).then(function (newCredential) {
        // Send the new credential to the server
        $('#credentialId').val(newCredential.id);
        $('#attestationObject').val(new Int8Array(newCredential.response.attestationObject));
        $('#clientDataJSON').val(new Int8Array(newCredential.response.clientDataJSON));
        $('#sendData').submit();
    }, function (error) {
        $('#errorMsg').append(' - ' + error.message);
        $('#errorMsg').show();
    });
}

$(document).ready(function () {
    $('#errorMsg').hide();
    $('#add-token_button').click(register);
});