let adminIds = null;

function getUserList(dataId) {
    const result = [];
    const userList = $('#tenantusers_js').data(dataId);
    if (userList) {
        if (isNaN(userList)) {
            userList.split(',').forEach(function (u) {
                result.push(parseInt(u))
            })
        } else {
            result.push(userList)
        }
    }
    return result;
}

function getSelectedUserNames(selection){
      var html = [];
    html.push("<ul>");
    selection.split(',').forEach(function (u) {
        html.push("<li>");
        html.push(htmlEncodeAntiXSS($('#tenantusers_js').data('username_' + u)));
        html.push("</li>");
    });
    html.push("</ul>");
    return html.join("");
}


function isAdmin(id) {
    if (adminIds == null) {
        adminIds = getUserList('admins');
    }
    return adminIds.indexOf(parseInt(id)) >= 0;
}

function checkboxCallback(numSelected) {
    if (numSelected === 0) {
        $('#tenant_users_remove_button').addClass('disabled disabled-menu-item');
    }else {
        const selection = getSelectedIds('tenantUsersTable_select');
        $('#tenant_users_remove_button').removeClass('disabled disabled-menu-item');
        setHiddenFormTextParameter($('#tenant_users_delete_form'), selection);

        const infoText = $('#tenant_users_delete_info');
        const hintText = $('#tenant_users_delete_info_hint');
        if (numSelected === 1) {
             infoText.html(infoText.data('template').replaceAll(
            'USERNAME', htmlEncodeAntiXSS($('#tenantusers_js').data('username_' + selection))));
            hintText.html(hintText.data('template'));
        }else{
            infoText.html(infoText.data('template-multi') + getSelectedUserNames(selection));
            hintText.html(hintText.data('template-multi'));
        }
    }
}

$(document).ready(function () {
    $('tr[id^=tenantUsersTable_row_]').click(function () {
        $('#tenant_users_modal_' + $(this).data('rownumber')).modal('show');
    });

    $('#tenant_users_add_button').click(function () {
        $('#tenant_users_add_modal').modal('show');
    });

    $('#tenant_users_remove_button').click(function () {
        $('#tenant_users_delete_modal').modal('show');
    });
    checkboxCallback(0);

    const userIdToOpen = $('#tenantusers_js').data('openuserid');
    if(userIdToOpen!=null && userIdToOpen!=-1){
        $('#tenantUsersTable_row_'+userIdToOpen).click();
    }

    // Update "managing User" checkbox when selecting admins in the add-user dialog
    const userSelect = $('#userId');
    userSelect.change(function () {
        let managingUserCheckbox = $('#isManagingUser');
        let selectedUserId = userSelect.val();
        if (isAdmin(selectedUserId)) {
            managingUserCheckbox.prop("disabled", true);
            managingUserCheckbox.prop("checked", true);
        } else {
            managingUserCheckbox.prop("disabled", false);
            managingUserCheckbox.prop("checked", false);
        }
    }).change();
});
