function applyNewName() {
    let max = $('#new_tenant_modal_maxusercount').val();
    if (max == null || max.length === 0) {
        max = -1;
    }
    let name = $('#new_tenant_modal_name').val();
    let customerID = $('#new_tenant_modal_customerid').val();
    if (customerID === undefined) customerID = "";
    
    const js = $('#tenantsaddmodal_js');
    const link = js.data('newlink').replace('999', max).replace('NAME', htmlEncodeAntiXSS(name)).replace('CUSTOMERID', htmlEncodeAntiXSS(customerID));
    $.ajax({
        url: link,
        mimeType: 'application/json',
        dataType: 'json',
        success: function (result) {
            if (result['nameError'].length === 0) {
                $('#' + js.data('new_tenant_modal_name')).val(result['name']);
                $('#' + js.data('new_tenant_modal_maxusercount')).val(result['maxUserCount']);
                $('#' + js.data('new_tenant_modal_customerid')).val(result['customerId']);
                $('#new_tenant_prepare_question_modal').modal('hide');
                $('#invalid_name_warning').parent().hide();
                window.location.href = result['redirect'];
            } else {
                const warningField = $('#invalid_name_warning');
                warningField.text(result['nameError']);
                warningField.parent().show();
                enableSubmitButton("new_tenant_modal_apply");
            }
        }
    });
}

function applyEdit() {
    let max = $('#edit_tenant_modal_maxusercount').val();
    if (max == null || max.length === 0) {
        max = -1;
    }
    let name = $('#edit_tenant_modal_name').val();
    let customerID = $('#new_tenant_modal_customerid').val();
    if (customerID === undefined) customerID = "";

    const js = $('#actions_menu_edit_tenant');
    const link = js.data('link').replace('999', max).replace('NAME', htmlEncodeAntiXSS(name)).replace('CUSTOMERID', htmlEncodeAntiXSS(customerID));
    $.ajax({
        url: link,
        mimeType: 'application/json',
        dataType: 'json',
        success: function (result) {
            if (result['nameError'].length === 0) {
                $('#edit_tenant_modal_name').val(result['name']);
                $('#edit_tenant_modal_maxusercount').val(result['maxUserCount']);
                $('#edit_tenant_modal_customerid').val(result['customerId']);
                $('#edit_tenant_prepare_question_modal').modal('hide');
                $('#edit_invalid_name_warning').parent().hide();
                window.location.href = result['redirect'];
            } else {
                const warningField = $('#edit_invalid_name_warning');
                warningField.text(result['nameError']);
                warningField.parent().show();
            }
        }
    });
}

$(document).ready(function () {
    $('#new_tenant_modal_maxusercount').keydown(checkInputNumeric)
    $('#new_tenant_modal_apply').click(applyNewName);
    $('#invalid_name_warning').parent().hide();

    $('#edit_tenant_modal_maxusercount').keydown(checkInputNumeric)
    $('#edit_tenant_modal_apply').click(applyEdit);
    $('#edit_invalid_name_warning').parent().hide();
})
