/**
 * Parameters for the current script
 * @type {
 *     {deleteTitle : {
 *         single : string,
 *         multiple : string,
 *         none : string
 *     }},
 *     {deleteQuestion : {
 *         single : string,
 *         multiple : string,
 *         none : string
 *     }}
 * }
 */
const foldersParams = JSON.parse(atob($('#folders_js').data('params')));

function checkboxCallback(numSelected) {
    if (numSelected === 0) {
        $('#folders_delete_button').addClass('disabled disabled-menu-item');
    } else {
        $('#folders_delete_button').removeClass('disabled disabled-menu-item');
    }
    if (numSelected === 0) {
        $('#folders_delete_modal_title').html(foldersParams.deleteTitle.none);
        $('#folders_delete_modal_text').html(foldersParams.deleteQuestion.none);
    } else if (numSelected === 1) {
        $('#folders_delete_modal_title').html(foldersParams.deleteTitle.single);
        $('#folders_delete_modal_text').html(foldersParams.deleteQuestion.single);
    } else {
        $('#folders_delete_modal_title').html(foldersParams.deleteTitle.multiple.replace('999', numSelected));
        $('#folders_delete_modal_text').html(foldersParams.deleteQuestion.multiple.replace('999', numSelected));
    }
    setHiddenFormTextParameter($('#folders_delete_form'), getSelectedIds('folders_table_select'));
}
