const adminsettings_js = $('#adminsettings_js');

function cleanUp(plugin) {
    let button;
    switch (plugin) {
        case 'transfer':
            button = $('#transfer-cleanup-button');
            break;
        case 'des':
            button = $('#des-cleanup-button');
            break;
        case 'cm':
            button = $('#cm-cleanup-button');
            break;
        default:
            return;
    }

    button.addClass('disabled');
    button.empty();
    createHtmlElement(button, 'SPAN', 'fa fa-spinner fa-spin-pulse bl-button-icon');
    button.append(adminsettings_js.data('cleanupbutton-active-text'))

    $.ajax({
        url: button.data('link'),
        cache: false,
        success: function () {
            button.empty();
            createHtmlElement(button, 'SPAN', 'fa fa-check bl-button-icon');
            button.append(adminsettings_js.data('cleanupbutton-done-text'));

            setTimeout(function () {
                button.removeClass('disabled');
                button.html(adminsettings_js.data('cleanupbutton-default-text'));
            }, 1000);
        },
        error: function (e) {
            console.log('Failed to run clean-up: ' + e);
        }
    });
}

$(document).ready(function () {
    $('#transfer-cleanup-button').click(function () {
        cleanUp('transfer');
    });
    $('#des-cleanup-button').click(function () {
        cleanUp('des');
    });
    $('#cm-cleanup-button').click(function () {
        cleanUp('cm');
    });

    // Select element used to switch between preferences, admin settings and tenant settings for individual tenants
    $('#settingsPage').change(function() {
        let linkSettings = $(this).attr('data-url-template-settings');
        let linkPreferences = $(this).attr('data-url-template-preferences');
        let link;
        let selectedOption = $(this).val();
        if (selectedOption === 'PERSONAL_SETTING') {
            link = linkPreferences;
        } else if (selectedOption === 'ADMIN_SETTING') {
            link = linkSettings;
        } else {
            link = linkSettings + '?tenantId=' + selectedOption;
        }
        window.location.href = link;
    })
});