/**
 * Parameters for the current script
 * @type {
 *     {accountType : string},
 *     {banks : [
 *         {id : number},
 *         {users : string}
 *     ]},
 *     {allUsers : string},
 *     {findBlzsLink : string},
 *     {findBicsLink : string},
 *     {bicFromIbanUrl : string},
 *     {getEditButtonUrl : string},
 *     {getCancelEditButtonUrl : string}
 * }
 */
const accountFormParams = JSON.parse(atob($('#accountform_js').attr('data-params')));

function bankChanged() {
    if (accountFormParams.banks != null) {
        const selectedBank = parseInt($('#bank').find('option:selected').val());
        let bankUsers = null;
        accountFormParams.banks.forEach(function (bank) {
            if (bankUsers != null) {
                return;
            }
            if (selectedBank === bank.id) {
                bankUsers = bank.users.split(',');
            }
        });
        if (bankUsers != null) {
            accountFormParams.allUsers.split(',').forEach(function (userId) {
                if (bankUsers.indexOf(userId) < 0) {
                    $('#user' + userId + '_field').hide();
                } else {
                    $('#user' + userId + '_field').show();
                }
            });
        }
    }
}

function virtualBalanceChanged() {
    if ($('#useVirtualBalances').prop('checked')) {
        $('#virtualBalance_field').show();
        $('#virtualStartDate_field').show();
    } else {
        $('#virtualBalance_field').hide();
        $('#virtualStartDate_field').hide();
    }
}

function updateBlz(blz) {
    $('#bankCode').val(blz);
    $('#blz_search').html('');
}

function searchBlz() {
    asyncSearchForTextField($('#bankCode'), $('#blz_search'), accountFormParams.findBlzsLink,
        handleBlzSearchResultLine);
}

function handleBlzSearchResultLine(line) {
    const blz = line.substring(0, 8);

    const result = document.createElement('A');
    return $(result).click(function () {
        updateBlz(blz);
    }).addClass('list-group-item').html(line);
}

function updateBic(bic) {
    $('#bic').val(bic);
    $('#bic_search').html('');
}

function searchBic() {
    asyncSearchForTextField($('#bic'), $('#bic_search'), accountFormParams.findBicsLink, handleBicSearchResultLine);
}

function handleBicSearchResultLine(line) {
    let bic;
    if (line.charAt(8) === ' ') {
        bic = line.substring(0, 8);
    } else {
        bic = line.substring(0, 11);
    }

    const result = document.createElement('A');
    return $(result).click(function () {
        updateBic(bic);
    }).prop('role', 'button').addClass('list-group-item').html(line);
}

function fillBICFromIBAN(event) {
    if (!accountFormParams.bicFromIbanUrl) {
        return;
    }
    const iban = event.target.value.replace(/ /g, '');
    if (iban.startsWith("DE") && iban.length === 22) {
        $.ajax({
            url: accountFormParams.bicFromIbanUrl.replace('SEARCH', encodeURIComponent(iban)),
            success: function (result) {
                updateBic(result);
            },
            error: function (error) {
                console.log(error);
                updateBic("");
            }
        });
    } else {
        updateBic("");
    }
}

function replaceEditLink(e) {
    // need to change link if another tab is selected. If an action will be executed the redirect will open the correct open tab again.
    let tab =  $(e.target).attr("id").replace("-tab","");
    $('#edit_button').attr("href", accountFormParams.getEditButtonUrl.replace("TAB", tab));
    $('#no_edit_button').attr("href", accountFormParams.getCancelEditButtonUrl.replace("TAB", tab));
}

$(document).ready(function () {
    addSearchBoxEnterPrevention('bankCode');
    addSearchBoxEnterPrevention('bic');
    bankChanged();
    virtualBalanceChanged();

    $('#iban').change(function (event) {
        formatIban($(this), false);
        if (accountFormParams.bicFromIbanUrl != null) {
            fillBICFromIBAN(event);
        }
    }).keydown(checkInputAlphanumeric);

    $('#bic').keydown(checkInputAlphanumeric).keyup(function (event) {
        searchFieldKeyHandler(event, 'bic_search', searchBic);
    }).focusout(function () {
        $('#bic_search').hide();
    });
    if (accountFormParams.accountType === 'DOMESTIC') {
        $('#accountNumber').keydown(checkInputNumeric);
        $('#bankCode').keydown(checkInputNumeric).keyup(function (event) {
            searchFieldKeyHandler(event, 'blz_search', searchBlz);
        }).focusout(function () {
            $('#blz_search').hide();
        });
    }
    const creditLimitField = $('#creditLimit');
    if (creditLimitField.length) {
        creditLimitField.keydown(checkInputDecimalNumeric);
        creditLimitField.change(function () {
            amountFieldChanged(creditLimitField);
        });
    }
    const investmentAmount = $('#investmentAmount');
    if (investmentAmount.length) {
        investmentAmount.keydown(checkInputDecimalNumeric);
        investmentAmount.change(function () {
            amountFieldChanged(investmentAmount);
        });
    }
    $('#useVirtualBalances').change(virtualBalanceChanged);
    const virtualBalanceField = $('#virtualBalance');
    if (virtualBalanceField.length) {
        virtualBalanceField.keydown(checkInputDecimalNumeric);
        virtualBalanceField.change(function () {
            amountFieldChanged(virtualBalanceField);
        });
    }

    $('#bank').change(bankChanged);

    $('#tabgeneral-tab').on('show.bs.tab', function (e) {
        replaceEditLink(e);
    });
    $('#tabusers-tab').on('show.bs.tab', function (e) {
        replaceEditLink(e);
    });
    $('#tabcm-tab').on('show.bs.tab', function (e) {
        replaceEditLink(e);
    });

    $('#taboriginator-tab').on('show.bs.tab', function (e) {
        replaceEditLink(e);
    });

    $('#accounts_delete').click(function () {
        $('#accounts_delete_form').submit();
    });

    $('#apply-defaultname').click(function () {
        $('#name').val($('#defaultName').attr("value"));
    });
    $('#apply-accountholder').click(function () {
        $('#accountHolder').val($('#accountHolderHTD').attr("value"));
    });



});