function setCookie(cname, value) {
    const d = new Date();
    if (value) {
        d.setTime(d.getTime() + (24 * 60 * 60 * 1000));
    } else {
        d.setTime(0);
        value = '';
    }
    document.cookie = cname + '=' + value + ';expires=' + d.toUTCString() + ';path=/';
}

function getCookie(cname) {
    let result = undefined;
    if (!document.cookie || !document.cookie.length) {
        return result;
    }
    let equalsPos;
    decodeURIComponent(document.cookie).split(';').forEach(function (cookiePart) {
        if (result) {
            return;
        }
        equalsPos = cookiePart.indexOf('=');
        if (equalsPos > 0 && cookiePart.substring(0, equalsPos).trim() === cname) {
            result = cookiePart.substring(equalsPos + 1).trim();
        }
    });
    return result;
}

function registerServiceWorker() {
    const js = $('#push_service_handler');
    const serverKey = atob(js.data('vapidpubkey'));
    const serverKeyArray = new Uint8Array(serverKey.length);
    for (let i = 0; i < serverKey.length; ++i) {
        serverKeyArray[i] = serverKey.charCodeAt(i);
    }

    const handleError = function (reason, message) {
        if (getCookie('PUSH_NOTIFICATION_ACTIVE') === undefined) {
            $('#pushnotification_request_modal').modal('show');
        } else {
            console.log(message + ': ' + reason);
        }
    }

    return navigator.serviceWorker.register(js.data('serviceworker')).then(reg => {
        return reg.pushManager.subscribe({
            userVisibleOnly: true,
            applicationServerKey: serverKeyArray
        }).then(subscription => {
            const form = $('#user_notification_form');
            $(form).find('#text').val(btoa(JSON.stringify(subscription)));
            $(form).submit(e => {
                const formData = $(form).serialize();
                $.ajax({
                    type: 'POST',
                    url: $(form).attr('action'),
                    data: formData,
                    success: () => console.log('Sent subscription information to server!')
                });
                e.preventDefault();
            }).submit();

            setCookie('PUSH_NOTIFICATION_ACTIVE', true);
            return subscription;
        }).catch(reason => handleError(reason, 'Failed to subscribe to push manager'));
    }).catch(reason => handleError(reason, 'Error registering service worker'));

}

function unregisterServiceWorker() {
    const serviceWorkerJs = $('#push_service_handler').data('serviceworker');
    navigator.serviceWorker.getRegistrations().then(regs => regs.forEach(reg => {
        if (reg.active != null && reg.active.scriptURL.endsWith(serviceWorkerJs)) {
            reg.unregister().finally();
        }
    })).finally(() => setCookie('PUSH_NOTIFICATION_ACTIVE', undefined));
}

function requestNotificationPermission() {
    $('#pushnotification_request_modal').modal('hide');
    Notification.requestPermission().then(permission => {
        if (permission !== 'granted') {
            console.log('No push notification permission granted!');
            return undefined;
        } else {
            return registerServiceWorker();
        }
    });
}

function disableNotificationPermission() {
    $('#pushnotification_request_modal').modal('hide');
    setCookie('PUSH_NOTIFICATION_ACTIVE', false);
}

$(document).ready(function () {
    if (('serviceWorker' in navigator) && ('PushManager' in window) && !getCookie('PUSH_NOTIFICATION_ACTIVE')) {
        $('#pushnotification_request_accept').click(requestNotificationPermission);
        $('#pushnotification_request_decline').click(disableNotificationPermission);
        registerServiceWorker().then();
    }
})