/**
 * Parameters for the current script
 * @type {
 *     {numberOfFolders: number},
 *     {saveAsOpenPaymentMessage : {
 *         single : string,
 *         multiple : string
 *     }},
 *     {saveAsOpenSelectFolderMessage : {
 *         single : string,
 *         multiple : string
 *     }},
 *     {createAwvMessage : {
 *         single : string,
 *         multiple : string
 *     }},
 *     {fetchingMessage : string},
 *     {saveAsPeriodicPaymentLink : string},
 *     {saveAsPaymentTemplateLink : string},
 *     {refreshLink : string},
 *     {indexLink : string},
 *     {payments : [{
 *         id : number,
 *         amount : number,
 *         currency : string
 *     }]},
 *     {addDecimalsUrl : String},
 *     {alwaysAllowCallback : boolean}
 * }
 */
const signedPaymentsParams = JSON.parse(atob($('#signedpayments_js').attr('data-params')));

function checkboxCallback(numberOfItemsSelected) {
    // Determine selected payments and count the ones that can be cancelled
    let cancellablePaymentCount = 0;
    let recallablePaymentCount = 0;
    let selectedIds = '';
    $('input:checkbox[id^="paymentsTable_select_"]:checked').each(function () {
        let id = $(this).attr('id').substring(21);
        if (id === 'all')
            return;

        // Checkboxes of payments that can be cancelled have '_c' appended to their id
        if (id.substring(id.length - 2) === '_c') {
            id = id.substring(0, id.length - 2);
            if (!isNaN(id)) {
                cancellablePaymentCount++;
            }
        }

        // Checkboxes of payments that can be recalled have '_r' appended to their id
        if (signedPaymentsParams.alwaysAllowCallback || id.substring(id.length - 2) === '_r') {
            if (id.indexOf('_') > -1) {
                id = id.substring(0, id.indexOf('_'));
            }
            if (!isNaN(id)) {
                recallablePaymentCount++;
            }
        }

        if (!isNaN(id)) {
            if (selectedIds.length > 0) {
                selectedIds += ',';
            }
            selectedIds += id;
        }
    });

    if (cancellablePaymentCount === 0) {
        $('#actions_menu_cancel_link').addClass('disabled disabled-menu-item');
    } else {
        $('#actions_menu_cancel_link').removeClass('disabled disabled-menu-item');
    }

    if (recallablePaymentCount === 0) {
        $('#actions_menu_callback_link').addClass('disabled disabled-menu-item');
    } else {
        $('#actions_menu_callback_link').removeClass('disabled disabled-menu-item');
    }

    let title = $('#actions_menu_movetofolder').children('span')[0].getAttribute("data-bs-original-title");
    // if a title was set "no folders were created." disabled should not be removed
    let enableMoveToFolder = title === null || title.length === 0;
    if (numberOfItemsSelected) {
        $('#actions_menu_saveas_open_link').removeClass('disabled disabled-menu-item');
        if (enableMoveToFolder) {
            $('#actions_menu_movetofolder_link').removeClass('disabled disabled-menu-item');
        }
        $('#actions_menu_print_link').removeClass('disabled disabled-menu-item');
        $('#menu_create_awv_report_link').removeClass('disabled disabled-menu-item');
    } else {
        $('#actions_menu_saveas_open_link').addClass('disabled disabled-menu-item');
        $('#actions_menu_movetofolder_link').addClass('disabled disabled-menu-item');
        $('#actions_menu_print_link').addClass('disabled disabled-menu-item');
        $('#menu_create_awv_report_link').addClass('disabled disabled-menu-item');
    }

    const saveAsPeriodicLink = $('#actions_menu_saveas_periodic_link');
    if (numberOfItemsSelected === 1) {
        saveAsPeriodicLink.removeClass('disabled disabled-menu-item');
        $('#actions_menu_saveas_template_link').removeClass('disabled disabled-menu-item');
        $('#actions_menu_show_protocol_link').removeClass('disabled disabled-menu-item');

        $('#periodic_parameters_form').attr('action',
            signedPaymentsParams.saveAsPeriodicPaymentLink.replace('999', selectedIds).replace(
                /amp;/g, ''));
        $('#payment_template_name_form').attr('action',
            signedPaymentsParams.saveAsPaymentTemplateLink.replace('999', selectedIds).replace(
                /amp;/g, ''));

        $('#actions_menu_saveas_open_link').html('<span class="bl-action-menu-icon fa fa-edit"></span>' +
            signedPaymentsParams.saveAsOpenPaymentMessage.single);
        $('#save_as_open_payment_modal_label').text(signedPaymentsParams.saveAsOpenPaymentMessage.single);
        $('#save_as_open_payment_modal_label_running').text(signedPaymentsParams.saveAsOpenPaymentMessage.single);
        $('#menu_create_awv_report_link').html('<span class="bl-action-menu-icon fa fa-map-signs"></span>' +
            signedPaymentsParams.createAwvMessage.single);
        $('#saveasopenpayment-modal-info').html(signedPaymentsParams.saveAsOpenSelectFolderMessage.single);
    } else {
        saveAsPeriodicLink.addClass('disabled disabled-menu-item');
        $('#actions_menu_saveas_template_link').addClass('disabled disabled-menu-item');
        $('#actions_menu_show_protocol_link').addClass('disabled disabled-menu-item');

        $('#periodic_parameters_form').removeAttr('action');
        $('#payment_template_name_form').removeAttr('action');

        $('#actions_menu_saveas_open_link').html('<span class="bl-action-menu-icon fa fa-edit"></span>' +
            signedPaymentsParams.saveAsOpenPaymentMessage.multiple);
        $('#save_as_open_payment_modal_label').text(signedPaymentsParams.saveAsOpenPaymentMessage.multiple);
        $('#save_as_open_payment_modal_label_running').text(signedPaymentsParams.saveAsOpenPaymentMessage.multiple);
        $('#menu_create_awv_report_link').html('<span class="bl-action-menu-icon fa fa-map-signs"></span>' +
            signedPaymentsParams.createAwvMessage.multiple);
        $('#saveasopenpayment-modal-info').html(signedPaymentsParams.saveAsOpenSelectFolderMessage.multiple.replace('999', '' + numberOfItemsSelected));
    }

    setHiddenFormTextParameter($('#signedpayments_cancel_form'), selectedIds);
    setHiddenFormTextParameter($('#signedpayments_callback_form'), selectedIds);
    setHiddenFormTextParameter($('#signedpayments_print_form'), selectedIds);
    setHiddenFormTextParameter($('#signedpayments_saveasopen_form'), selectedIds);
    setHiddenFormTextParameter($('#signedpayments_printoverview_form'), selectedIds);
    setHiddenFormTextParameter($('#signedpayments_exportoverview_form'), selectedIds);
    setHiddenFormTextParameter($('#signedpayments_createawv_form'), selectedIds);
    setHiddenFormTextParameter($('#folder_select_form'), selectedIds, 'paymentIds');
    updateSelectionInfo();
}

function updateSelectionInfo() {
    let paymentsNumber = 0;
    let id;
    const data = [];
    $('input[id^=paymentsTable_select]:not(#paymentsTable_select_all):checked').each(function () {
        id = parseInt($(this).attr('id').substring(21));
        paymentsNumber++;
        signedPaymentsParams.payments.forEach(function (paymentInfo) {
            if (id === paymentInfo.id) {
                if(paymentInfo.amount){
                    let currency = paymentInfo.currency;
                    if(currency == null){
                        currency='EUR';
                    }
                    let singleData = '' + paymentInfo.amount +'-'+currency;
                    data.push(singleData);
                }else {
                    data.push('');
                }
            }
        });
    });

    if (paymentsNumber > 1) {
        $.ajaxSetup({
            beforeSend: function (xhr) {
                xhr.setRequestHeader('Csrf-Token', $('input[name="csrfToken"]').attr('value'));
            }
        });
        let ajaxUrl = signedPaymentsParams.addDecimalsUrl;
        $.ajax({
            url: ajaxUrl,
            data: JSON.stringify({data: data}),
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            type: 'POST',
            success: function (result) {
                if ($('input[id^=paymentsTable_select]:not(#paymentsTable_select_all):checked').length !== paymentsNumber) {
                    return; // this is an outdated ajax result, do not use it! (Bug 7082)
                }
                const resultAmountString = result.sum;
                if (resultAmountString) {
                    const selectionInfo = $('#selection_info');
                    selectionInfo.html(result.sum);
                    selectionInfo.show();
                }
            },
            error: function (result) {
                console.log(result)
            }
        });
    } else {
        $('#selection_info').hide();
    }
}

function refresh() {
    const refreshButton = $('#navbar-refresh-button');
    if (refreshButton.length === 0) {
        return;
    }
    refreshButton.addClass('disabled disabled-menu-item');
    refreshButton.html('<span class="fa fa-spinner fa-spin-pulse bl-button-icon"></span>' +
        signedPaymentsParams.fetchingMessage);

    $.ajax({
        url: signedPaymentsParams.refreshLink,
        cache: false,
        success: function () {
            $(location).attr('href', signedPaymentsParams.indexLink);
        },
        error: function (error) {
            console.log(error);
        }
    });
}

function cancelPayments() {
    $('#signedpayments_cancel_form').submit();
}

$(document).ready(function () {
    $('#actions_menu_saveas_open').click(function () {
        if (signedPaymentsParams.numberOfFolders > 1) {
            $('#saveasopenpayment-modal').modal('show');
        } else {
            $('#signedpayments_saveasopen_form').submit();
        }
    });
    $('#navbar-refresh-button').click(refresh);
    $('#actions_menu_print_link').click(function () {
        $('#signedpayments_print_form').submit();
    });
    $('#actions_menu_printoverview_link').click(function () {
        $('#signedpayments_printoverview_form').submit();
    });
    $('#actions_menu_exportoverview_link').click(function () {
        $('#signedpayments_exportoverview_form').submit();
    });
    $('#actions_menu_cancel_link').click(cancelPayments);
    $('#actions_menu_show_protocol_link').click(showProtocolModal);
    $('#menu_create_awv_report_link').click(function () {
        $('#signedpayments_createawv_form').submit()
    });
    $('#actions_menu_callback_link').click(function () {
        $('#signedpayments_callback_form').submit()
    });
    updateSelectionInfo();
    checkboxCallback();
});
