if (!String.prototype.startsWith) {
    String.prototype.startsWith = function (searchString) {
        return this.indexOf(searchString) === 0;
    };
}

if (!String.prototype.trimEnd) {
    String.prototype.trimEnd = function () {
        return this.replace(/\s+$/, "");
    };
}

function accountAfterOriginator() {
    const account = $('#originatorAccountId_field');
    if (account.hasClass('afterOriginator')) {
        const originator = $('#originatorName_field');
        account.insertAfter(originator);
    }
}

function reorderDebitInputs() {
    const creditorId = $('#creditorId_field');
    if (creditorId.length && creditorId.hasClass('reorderInputs')) {
        const amount = $('#amount_group');
        const executionDate = $('#executionDate_field');
        const mandateReference = $('#mandateReference_field');
        const mandateSignDate = $('#mandateSignDate_field');
        executionDate.insertAfter(amount);
        creditorId.insertAfter(executionDate);
        mandateReference.insertAfter(creditorId);
        mandateSignDate.insertAfter(mandateReference);
    }
}

function hideEmptyField(name){
    var elements = $('input[id$='+name+']');
    for(var i=0; i<elements.length; i++){
        var element = elements.eq(i);
        if(element.val().length == 0){
            let id = element.attr('id');
            let idName = id +"_field";
            $('#'+idName).hide();
        }
    }
}

$(document).ready(function () {
    accountAfterOriginator();
    reorderDebitInputs();

    // if mandateReference_field is a mandatory field, mark creditorId_field as a mandatory field
    let creditorIdField = $('#creditorId_field');
    if (creditorIdField) {
        let mandateReferenceField = $('#mandateReference_field');
        if (mandateReferenceField && mandateReferenceField.hasClass("mandatory")) {
            creditorIdField.addClass('mandatory');
        }
    }

    if ($('button[id$=Dept_add]').length > 0){
        //Button found - it is editable - nothing to do
    }else{
        // it is not editable -  hide empty fields
        hideEmptyField('Dept');
        hideEmptyField('Subdept');
        hideEmptyField('Buildingname');
        hideEmptyField('Floor');
        hideEmptyField('Subcountry');
        hideEmptyField('Lei');
    }
});
