function findCountryValue(countryText) {
    let country_field = $('#country');
    if (countryText == null) {
        country_field.val('');
    } else {
        let found = false;
        country_field.find('OPTION').each(function () {
            if (countryText === $(this).text()) {
                found = true;
                country_field.val($(this).val());
            }
        });
        if (!found) {
            country_field.val('');
        }
    }
}

function updateAddress(street, postcode, city, region, country) {
    let line = "{STREET}\n {POSTCODE} {CITY}\n{REGION}";
    if (street != null) {
        line = line.replace(/\{STREET\}/g, street);
    } else {
        line = line.replace(/\{STREET\}/g, "");
    }
    if (postcode != null) {
        line = line.replace(/\{POSTCODE\}/g, postcode);
    } else {
        line = line.replace(/\{POSTCODE\}/g, "");
    }
    if (city != null) {
        line = line.replace(/\{CITY\}/g, city);
    } else {
        line = line.replace(/\{CITY\}/g, "");
    }
    if (region != null) {
        line = line.replace(/\{REGION\}/g, region);
    } else {
        line = line.replace(/\{REGION\}/g, "");
    }
    $('#address').val(line);
    findCountryValue(country);
}

$(document).ready(function () {
    $('#creditorId').keydown(function (event) {
        checkInputAlphanumeric(event);
    });

    $('a[id^=select_bank_link_]').click(function () {
        updateAddress($(this).data('street'), $(this).data('postcode'),
            $(this).data('city'), $(this).data('region'), $(this).data('country'))
        $('#street').val($(this).data('street'));
        $('#postcode').val($(this).data('postcode'));
        $('#town').val($(this).data('city'));
        $('#subcountry').val($(this).data('region'));
    })

    // Bug 6038 - Formatierung Steuernummer (nun Abgabenkontonummer) bei Finanzamtszahlungen
    let taxNumber_field = $('#taxNumber');
    formatReference(taxNumber_field);
    taxNumber_field.change(function () {
        formatReference($('#taxNumber'));
    });
});
