/**
 * Parameters for the current script
 * @type {
 *     {deleteMessage : {
 *         single : string,
 *         multiple : string
 *     }},
 *     {selectFolderMessage : {
 *         single : string,
 *         multiple : string
 *     }},
 *     {deleteQuestionMessage : {
 *         single : string,
 *         multiple : string
 *     }},
 *     {selectInfoMessage : string},
 *     {payments : [{
 *         id : number,
 *         amount : number,
 *         currency : string
 *     }]}
 * }
 */
const paymentTemplatesParams = JSON.parse(atob($('#paymenttemplates_js').attr('data-params')));

function checkboxCallback(itemSelected) {
    let title = $('#actions_menu_movetofolder').children('span')[0].getAttribute("data-bs-original-title");
    // if a title was set "no folders were created." disabled should not be removed
    let enableMoveToFolder = title === null || title.length === 0;
    if (itemSelected) {
        $('#payment_template_generate_button').removeClass('disabled disabled-menu-item');
        $('#payment_template_delete_button_link').removeClass('disabled disabled-menu-item');
        $('#actions_menu_duplicate_link').removeClass('disabled disabled-menu-item');
        if (enableMoveToFolder) {
           $('#actions_menu_movetofolder_link').removeClass('disabled disabled-menu-item');
        }
    } else {
        $('#payment_template_generate_button').addClass('disabled disabled-menu-item');
        $('#payment_template_delete_button_link').addClass('disabled disabled-menu-item');
        $('#actions_menu_duplicate_link').addClass('disabled disabled-menu-item');
        $('#actions_menu_movetofolder_link').addClass('disabled disabled-menu-item');
    }

    if (itemSelected <= 1) {
        $('#payment_template_delete_modal_title').html(paymentTemplatesParams.deleteMessage.single);
        $('#payment_template_delete_modal_text').html(paymentTemplatesParams.deleteQuestionMessage.single);
    } else {
        $('#payment_template_delete_modal_title').html(paymentTemplatesParams.deleteMessage.multiple);
        $('#payment_template_delete_modal_text').html(
            paymentTemplatesParams.deleteQuestionMessage.multiple.replace('999', itemSelected));
    }

    const selection = getSelectedIds('paymentsTable_select');
    setHiddenFormTextParameter($('#generate_payment_form'), selection, 'paymentIds');
    setHiddenFormTextParameter($('#folder_select_form'), selection, 'paymentIds');
    setHiddenFormTextParameter($('#payment_template_delete_form'), selection);
    setHiddenFormTextParameter($('#paymenttemplates_duplicate_form'), selection);
    updateSelectionInfo();
}

function updateSelectionInfo() {
    let paymentsNumber = 0;
    let totalAmount = 0;
    let currency = null;
    let id;
    $('input[id^=paymentsTable_select]:not(#paymentsTable_select_all):checked').each(function () {
        id = parseInt($(this).attr('id').substring(21));
        paymentTemplatesParams.payments.forEach(function (payment) {
            if (id === payment.id) {
                paymentsNumber++;
                totalAmount += payment.amount;
                if (currency == null) {
                    currency = payment.currency;
                } else if (currency !== payment.currency) {
                    currency = '';
                }
            }
        });
    });
    const selectionInfoField = $('#selection_info');
    if (paymentsNumber > 1 && currency != null && currency !== '') {
        selectionInfoField.html(
            paymentTemplatesParams.selectInfoMessage.replace('999', '' + paymentsNumber).replace(
                'AMOUNT', localizeAmount(totalAmount, currency)));
        selectionInfoField.show();
    } else {
        selectionInfoField.hide();
    }
}

$(document).ready(function () {
    $('#actions_menu_duplicate').click(function () {
        $('#paymenttemplates_duplicate_form').submit();
    });
    updateSelectionInfo();
    $('[data-toggle="tooltip"]').tooltip();
});