const paymentimportjs = $('#paymentimport_js');

function fileFormatChanged() {
    let fileTypeSelect = document.getElementById("fileFormat");
    if (fileTypeSelect.value === 'CSV_FILE') {
        // import CSV/Excel file
        $('#encoding_field').removeClass("hidden");
        $('#import_payment_file').removeAttr("multiple");
        $('#pmtTypeName_field').hide();
        $('#pmtTypeNameCsv_field').show();
        $('#sepaSingleBooking_field').hide();
    } else {
        // import payment file(s)
        $('#encoding_field').addClass("hidden");
        $('#import_payment_file').attr("multiple","multiple");
        $('#pmtTypeName_field').show();
        $('#pmtTypeNameCsv_field').hide();
        $('#sepaSingleBooking_field').show();
    }
}

function paymentContextChanged() {
    // Hide/show certain fields depending on the selected payment context
    const paymentContextSelect = $('#paymentContextTypeName');
    const selectedContext = paymentContextSelect.val();

    if (selectedContext === 'PAYMENT_TEMPLATE') {
        $('#templateName_field').show();
    } else {
        $('#templateName_field').hide();
    }

    if (selectedContext === 'PERIODIC_PAYMENT') {
        $('#periodic_parameters_panel').show();
        $('#readPeriodicParametersFromFile_field').show();
    } else {
        $('#periodic_parameters_panel').hide();
        $('#readPeriodicParametersFromFile_field').hide();
    }
}

function readPeriodicParametersFromFileChanged() {
    const checkbox = $('#readPeriodicParametersFromFile');
    const checked = checkbox.prop('checked');

    // Disable all fields in the periodic parameters panel when the checkbox is checked
    const periodicParametersPanel = $('#periodic_parameters_panel');
    if (checked) {
        periodicParametersPanel.hide();
    } else {
        periodicParametersPanel.show();
    }
}

function toggleFolders() {
    const folderSelect = $('#folderId');
    const selectedFolder = folderSelect.val();
    if (!folderSelect.data('originalhtml')) {
        folderSelect.data('originalhtml', folderSelect.html());
    } else {
        folderSelect.html(folderSelect.data('originalhtml'));
    }

    const bankId = parseInt($('#bankId').val());
    if (!bankId || bankId < 0) {
        return;
    }
    const tenant = paymentimportjs.data('banktenant_' + bankId);
    if (!tenant) {
        return;
    }

    let folderId;
    folderSelect.find('OPTION').each(function () {
        folderId = parseInt($(this).val());
        if (folderId >= 0 && tenant !== paymentimportjs.data('foldertenant_' + folderId)) {
            $(this).remove();
        }
    });
    folderSelect.val(selectedFolder);
}

$(document).ready(function () {
    $('#bankId').change(toggleFolders).change();
    $('#paymentContextTypeName').change(paymentContextChanged).change();
    $('#readPeriodicParametersFromFile').change(readPeriodicParametersFromFileChanged);
    $('#fileFormat').change(fileFormatChanged).change();
});
