const paymentEditableJs = $('#payment_editable_js');
/**
 * Parameters for the current script
 * @type {
 *     {conversionMessage : String},
 *     {conversionNotPossibleMessage : String},
 *     {conversionFactors : [
 *         {currency : String},
 *         {factor : number},
 *         {date : String},
 *         {fractions : number}
 *     ]},
 *     {addDecimalsUrl : String},
 *     {multiplyDecimalsUrl : String},
 *     {convertAmountUrl : String}
 * }
 */
const paymentEditableParams = JSON.parse(atob(paymentEditableJs.data('params')));

/**
 * Asynchronously convert an amount and put the result text into the given description field.
 */
function _getConvertedAmountText(currency, textField, convertToEur, showConversionFailedMessage = true) {
    let foundConversionFactor = false;
    paymentEditableParams.conversionFactors.forEach(function (conversionFactor) {
        if (conversionFactor.currency !== currency || conversionFactor.factor == null) {
            return;
        }

        let data = {
            amount: localizedToCanonicalNumberString($('#amount').val()),
            conversionFactor: conversionFactor.factor,
            convertToEur: convertToEur,
        };

        $.ajaxSetup({
            beforeSend: function (xhr) {
                xhr.setRequestHeader('Csrf-Token', $('input[name="csrfToken"]').attr('value'));
            }
        });
        $.ajax({
            url: paymentEditableParams.convertAmountUrl,
            data: JSON.stringify(data),
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            type: 'POST',
            success: function (result) {
                const resultAmountString = result.convertedAmount;
                if (resultAmountString) {
                    let fractions = convertToEur ? 2 : conversionFactor.fractions;
                    let conversionText = paymentEditableParams.conversionMessage.replace('[amount]',
                        canonicalToLocalizedNumberString(resultAmountString, fractions));
                    conversionText = conversionText.replace('[currency]', convertToEur ? '€' : currency);
                    conversionText = conversionText.replace('[date]', conversionFactor.date);
                    textField.html(conversionText);
                    textField.show();
                    foundConversionFactor = true;
                }
            },
            error: function (result) {
                console.log(result)
            }
        });
    });

    if (!foundConversionFactor) {
        if (showConversionFailedMessage) {
            let targetCurrency = (convertToEur) ? 'EUR' : currency;
            textField.html(paymentEditableParams.conversionNotPossibleMessage.replace(
                '[currency]', targetCurrency));
            textField.show();
        } else {
            textField.hide();
        }
    }
}

let postFormatAmountOperation = function () {
};

function formatAmountInTextField(textfield, currencyField) {
    let fractions = 2;
    if (currencyField != null && currencyField.length > 0 && currencyField.val() != null &&
        currencyField.val().length > 0) {
        const currency = currencyField.val();
        paymentEditableParams.conversionFactors.forEach(function (conversionFactor) {
            if (conversionFactor.currency === currency && conversionFactor.fractions !== fractions) {
                fractions = conversionFactor.fractions;
            }
        });
    }
    amountFieldChanged(textfield, fractions);

    postFormatAmountOperation();
}

function toggleFolders(tenantId) {
    if (tenantId == null || isNaN(tenantId) || tenantId < 0) {
        return;
    }
    const folderField = $('#targetFolder');
    if (!folderField.length) {
        return;
    }
    // store original select content, if not done yet
    const selectedFolder = folderField.val();
    if (!folderField.data('originalhtml')) {
        folderField.data('originalhtml', folderField.html());
    } else {
        folderField.html(folderField.data('originalhtml'));
    }
    let folderId;
    folderField.find('OPTION').each(function () {
        folderId = parseInt($(this).val());
        if (folderId >= 0 && tenantId !== parseInt(paymentEditableJs.data('foldertenant_' + folderId))) {
            $(this).remove();
        }
    });
    folderField.val(selectedFolder);
    // folder is not available for account select no folder
    let selText = $("#targetFolder option:selected").text();
    if (selText || selText.length === 0) {
        folderField.val(-2);
    }
}

function checkInputDtazv(event) {
    if (event.key !== '.' && event.key !== ',' && event.key !== '&' && event.key !== '-' && event.key !== '/' &&
        event.key !== '+' && event.key !== '*' && event.key !== '$' && event.key !== '%') {
        return checkInputAlphanumeric(event);
    }
}

function updateToolTipAccountId() {
    const originatorAccountIdField = $('#originatorAccountId');
    if (originatorAccountIdField !== null) {
        const id = parseInt(originatorAccountIdField.val());
        let found = false;
        originatorAccountIdField.find('OPTION').each(function () {
            let originatorId = parseInt($(this).val());
            if (id === originatorId) {
                found = true;
                originatorAccountIdField.attr("title", $(this).attr("title"));
            }
        });
        if (!found) {
            originatorAccountIdField.attr("title", "");
        }
    }
}

$(document).ready(function () {
    const amountField = $('#amount');
    const currencyField = $('#currency');

    amountField.change(function () {
        formatAmountInTextField(amountField, currencyField);
    });

    amountField.keydown(checkInputDecimalNumeric);

    if (currencyField != null && currencyField.length > 0) {
        currencyField.change(function () {
            formatAmountInTextField(amountField, currencyField);
        });
    }
    formatAmountInTextField(amountField, currencyField);
    // set the first tooltip on orginatoraccountid
    updateToolTipAccountId();

    // Show/Hide the createNewRecipient_field based on the checkbox status of rememberRecipient
    $('input#rememberRecipient').change(function () {
        const createNewRecipientField = $('#createNewRecipient_field');
        if ($(this).prop('checked')) {
            createNewRecipientField.show();
        } else {
            createNewRecipientField.hide();
        }
    }).change();
});
