$(document).ready(function () {
    $('script[id$="_passwordmodal_js"]').each(function () {
        if ($(this).data('prepared') === true) {
            return;
        }
        const id = /(.*)_passwordmodal_js/g.exec($(this).attr('id'))[1];

        // Bug 6957: Disable the password field after submit was clicked
        $('#' + id + '-submit').click(function () {
            const pwField = $('#' + id + '_password');
            if (pwField.val()) {
                pwField.addClass('disabled disabled-menu-item');
            }
        });

        const errorMsg = $('#' + id + "errorMsg");
        errorMsg.hide();

        /**
         *
         * @type {
         *     {challenge : string},
         *     {allowCredentials : [
         *         {id : string}
         *     ]}
         * }
         */
        const webauthndata = JSON.parse(atob($(this).data('params')));
        if (webauthndata.challenge != null) {
            // Build the object for the authentication
            let challenge = [];
            webauthndata.challenge.split(',').forEach(function (challengeId) {
                challenge.push(parseInt(challengeId));
            });
            let allowCredentials = [], allowCredentialsItemIds;
            webauthndata.allowCredentials.forEach(function (credential) {
                allowCredentialsItemIds = [];
                credential.id.split(',').forEach(function (c) {
                    allowCredentialsItemIds.push(parseInt(c));
                });
                allowCredentials.push({id: new Uint8Array(allowCredentialsItemIds), type: 'public-key'});
            });

            const form = $('#' + id + '_form');
            let done = false;
            form.submit(function () {
                if (done) {
                    return true;
                }
                const useOtp = $('#' + id + '_useOtp');
                if (useOtp.length && useOtp.prop('checked')) {
                    return true;
                }

                errorMsg.hide();
                navigator.credentials.get({
                    publicKey: {
                        challenge: new Uint8Array(challenge),
                        allowCredentials: allowCredentials
                    }
                }).then(function (assertion) {
                    $('#' + id + '_credentialId').val(assertion.id);
                    $('#' + id + '_authenticatorData').val(new Int8Array(assertion.response.authenticatorData));
                    $('#' + id + '_clientDataJSON').val(new Int8Array(assertion.response.clientDataJSON));
                    $('#' + id + '_signature').val(new Int8Array(assertion.response.signature));
                    done = true;
                    form.submit();
                }, function (error) {
                    var text = errorMsg.text();
                    // When an error has already been added, remove that first.
                    if (text.indexOf(' - ') > 0) {
                        errorMsg.text(errorMsg.text().substring(0, text.indexOf(' - ')));
                    }
                    // now add the error to the existing text.
                    errorMsg.append(' - ' + error.message);
                    errorMsg.show();
                    // make the dialog usable again by enabling the password field and the submit button
                    $('#' + id + '-submit').removeClass('disabled disabled-menu-item');
                    $('#' + id + '_password').removeClass('disabled disabled-menu-item');
                    // and remove the icon from the submit-button and replace it with the original icon.
                    const icon = $('#' + id + '-submit_icon');
                    const iconBase = icon.data("icon-template");
                    const iconWorking = icon.data("icon-template-working");
                    icon.removeClass(iconWorking);
                    icon.addClass(iconBase);
                });
                return false;
            });
        }
        const modal = $('#' + id);
        if ($(this).data('show')) {
            $(modal).modal('show');
        }
        $(modal).on('shown.bs.modal', function () {
            // When password modal is opened, enable password field in case it was disabled earlier
            const pwField = $(this).find('input[name=password]');
            pwField.removeClass('disabled disabled-menu-item');
            // Focus the password field
            pwField.focus();
            // hide any error
            errorMsg.hide();
        });
        const useOtpCheckbox = $('#' + id + '_useOtp');
        if (useOtpCheckbox.length) {
            const useOtpChecked = function () {
                const otp = $('#' + id + '_otp');
                const otpField = $('#' + id + '_otp_field');
                if ($(useOtpCheckbox).prop('checked')) {
                    otpField.show();
                    otp.prop('required', true);
                    otp.focus();
                } else {
                    otpField.hide();
                    otp.prop('required', false);
                }
            }

            useOtpCheckbox.change(useOtpChecked);
            if ($('#' + id + '_otp').hasClass('is-invalid')) {
                useOtpCheckbox.prop('checked', true);
            } else {
                useOtpCheckbox.removeProp('checked');
            }
            useOtpChecked();
        }

        $(this).data('prepared', 'true');
    });
});
