/**
 * Parameters for the current script.
 * @type {
 *     {pageTitle : string},
 *     {removedMessage : string},
 *     {vopTooltip : string},
 *     {vopButtonLabelSign : string},
 *     {vopButtonLabelSubmit : string},
 *     {printUrls : [
 *         {id : number},
 *         {url : string}
 *     ]},
 *     {websocketRequest : {
 *         user : string,
 *         ords : [{
 *             info : string,
 *             pmts : string
 *         }]
 *     }},
 *     {websocketUrl : string}
 * }
 */
const signorderParams = JSON.parse(atob($('#signorder_js').data('params')));

function getCurrentOrderId() {
    let result = 0;
    $('div[id^="bank_order_"]').each(function () {
        if (result === 0 && $(this).is(':visible')) {
            result = parseInt($(this).attr('id').substring(11));
        }
    });
    return result;
}

function updatePrintButton() {
    const id = getCurrentOrderId();
    signorderParams.printUrls.forEach(function (printUrl) {
        if (id === printUrl.id) {
            $('#signorder_print_button').attr('href', printUrl.url);
        }
    });
}

function switchBankOrder(oldOrder, newOrder) {
    $('#bank_order_' + oldOrder).addClass('hidden');
    $('#bank_order_' + newOrder).removeClass('hidden');
}

function showNextOrder(event) {
    const controlPressed = event.ctrlKey;
    const numberOfBankOrders = $('div[id^=bank_order_]').length;

    let current = getCurrentOrderId();
    if (current < numberOfBankOrders -1) {
        // CTRL-click scrolls directly to the last order
        let next = (controlPressed) ? numberOfBankOrders - 1 : current + 1;
        switchBankOrder(current, next);

        if (next >= numberOfBankOrders - 1) {
            // scrolled to the end: enable the sign button
            $('#signorder_show_next_button').addClass('disabled');
            $('#signorder_info_multiple_orders').hide();
            let signButton = $('#signorder_sign_button');
            signButton.removeClass('disabled');
            signButton.tooltip();
            let submitButton = $('#signorder_sign_vop_button');
            submitButton.removeClass('disabled');
            submitButton.tooltip();
        }
        $('#signorder_show_last_button').removeClass('disabled');
        $('#signorder_page').html(signorderParams.pageTitle.replace('999', '' + (next + 1)));
    }
    updatePrintButton();
}

function showPreviousOrder(event) {
    const controlPressed = event.ctrlKey;
    let current = getCurrentOrderId();
    if (current > 0) {
        // CTRL-click scrolls directly to the first order
        let previous = (controlPressed) ? 0 : current - 1;
        switchBankOrder(current, previous);

        if (previous <= 0) {
            $('#signorder_show_last_button').addClass('disabled');
        }
        $('#signorder_show_next_button').removeClass('disabled');
        $('#signorder_page').html(signorderParams.pageTitle.replace('999', '' + (previous + 1)));
    }
    updatePrintButton();
}

$(document).ready(function () {
    $('#signorder_show_last_button').click(showPreviousOrder);
    $('#signorder_show_next_button').click(showNextOrder);
    $('#signorder_warning').hide();

    // Prevent submitting the form when User presses ENTER inside the 'additional order info' field
    $('input[id^="additionalInfos_"]').each(function () {
        const fieldID = this.id;
        $('#' + fieldID).keydown(function (event) {
            if (event.target.id === fieldID && event.which === 0x0D) {
                event.preventDefault();
            }
        });
    });

    // Hide submit button by default, in case there are no orders that can use VoP
    $('#signorder_sign_vop_button').closest('.bl-action-menu-button').hide();

    // Hide/Show the sign/submit buttons when a VoP checkbox changes
    $('input[id^="useVop_"]').change(function () {
        const orderID = this.id.match(/\d+/);
        let signButton = $('#signorder_sign_button');
        let submitButton = $('#signorder_sign_vop_button');
        let orderTypeFieldVop = $("#paymentType_" + orderID + "_vop_field");
        let orderTypeFieldWithoutVop = $("#paymentType_" + orderID + "_field");
        let passwordModalSignButton = $('#signorder_signmodal-submit');
        let passwordModalSignButtonLabel = $('#signorder_signmodal-submit_label');
        let vopHint = $('#signorder_signmodal_vopHint');
        let anyVopCheckboxesChecked = false;
        $('input[id^="useVop_"]').each(function () {
            if ($(this).is(':checked')) {
                anyVopCheckboxesChecked = true;
            }
        });

        // Show the correct order type for VOP/no VOP
        if ($(this).is(":visible")) {
            if ($(this).is(':checked')) {
                orderTypeFieldWithoutVop.addClass('hidden');
                orderTypeFieldVop.removeClass('hidden');
            } else {
                orderTypeFieldWithoutVop.removeClass('hidden');
                orderTypeFieldVop.addClass('hidden');
            }
        }

        if (anyVopCheckboxesChecked) {
            signButton.closest('.bl-action-menu-button').hide();
            submitButton.closest('.bl-action-menu-button').show();
            passwordModalSignButton.removeClass('btn-success');
            passwordModalSignButton.addClass('btn-info');
            passwordModalSignButtonLabel.data('label-template', signorderParams.vopButtonLabelSubmit);
            passwordModalSignButtonLabel.data('label-template-working', signorderParams.vopButtonLabelSubmit);
            vopHint.removeAttr("hidden");
        } else {
            signButton.closest('.bl-action-menu-button').show();
            submitButton.closest('.bl-action-menu-button').hide();
            passwordModalSignButton.removeClass('btn-info');
            passwordModalSignButton.addClass('btn-success');
            passwordModalSignButtonLabel.data('label-template', signorderParams.vopButtonLabelSign);
            passwordModalSignButtonLabel.data('label-template-working', signorderParams.vopButtonLabelSign);
            vopHint.attr("hidden", "");
        }
    }).change();

    const webSocket = new WebSocket(signorderParams.websocketUrl);
    if (webSocket != null) {
        let connectionOpen = false;
        webSocket.onopen = function () {
            connectionOpen = true;
            webSocket.send(JSON.stringify(signorderParams.websocketRequest))
        };
        webSocket.onerror = function (event) {
            console.log('Error on web socket: ' + event.message);
        };
        webSocket.onmessage = function (event) {
            console.log('Received message: ' + event.data);
        };

        let signing = false;
        const signOrderButton = $('#signorder_signmodal-submit');
        if (signOrderButton.length) {
            signOrderButton.click(function () {
                webSocket.send('COMMIT');
                signing = true;
            });
        }
        webSocket.onclose = function () {
            if (connectionOpen && !signing) {
                const signOrderWarningField = $('#signorder_warning');
                signOrderWarningField.html(signorderParams.removedMessage);
                signOrderWarningField.show();
            }
        };
    }

    const alreadySentModal = $('#already_sent_modal');
    if (alreadySentModal.data('show') === true) {
        alreadySentModal.modal('show');
    }
    updatePrintButton();

    // Enable Bootstrap tooltips
    const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]')
    const tooltipList = [...tooltipTriggerList].map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl))
});
