/**
 * Parameters for the current script
 * @type {
 *     {ebics3Banks : [string]}
 * }
 */
const sendFileJs = $('#send_file_js');
const sendFileParams = JSON.parse(atob(sendFileJs.attr('data-params')));

function switchFileFormat() {
    let fileTypeSelect = document.getElementById("sendFileType");
    if (fileTypeSelect.value === 'SEPA_FILE') {
        $('#bankId_field').hide();
        $('#orderOrFileType_field').hide();
        $('#pmtTypeName_field').hide();
        $('#encoding_field').hide();
        $('#send_order_file').attr("multiple","multiple");
    } else if (fileTypeSelect.value === 'CSV_FILE') {
        $('#bankId_field').show();
        $('#orderOrFileType_field').hide();
        $('#pmtTypeName_field').show();
        $('#encoding_field').show();
        $('#send_order_file').removeAttr("multiple");
    } else {
        $('#bankId_field').show();
        $('#orderOrFileType_field').show();
        $('#pmtTypeName_field').hide();
        $('#encoding_field').hide();
        $('#send_order_file').attr("multiple","multiple");
    }
}

function checkEbicsVersionOfBank() {
    let bankSelect = document.getElementById("bankId");
    if (sendFileParams.ebics3Banks.includes(bankSelect.value)) {
        $('#sendordertype_btf_modify_button').removeClass('disabled disabled-menu-item');
    } else {
        $('#sendordertype_btf_modify_button').addClass('disabled disabled-menu-item');
    }
}

$(document).ready(function () {
    $('#send_order_file').prop('required', 'true');
    $('#sendFileType').change(switchFileFormat).change();
    $('#bankId').change(checkEbicsVersionOfBank).change().change(bankChanged);
});