/**
 * Parameters for the current script
 * @type {
 *     {checkboxPrefix : string},
 *     {user : string},
 *     {action : string},
 *     {message : string},
 *     {additionalInfo : string},
 *     {title : string},
 *     {fetching : string},
 *     {order : string},
 *     {printLink : string},
 *     {protocolLink : string}
 * }
 */
const protocolmodalParams = JSON.parse(atob($('#protocolmodal_js').attr('data-params')));

let lastProtocolOrderId = null;

function createHacPanel(parent, hac) {
    const panel = createHtmlElement(parent, 'DIV', 'card mb-3');
    createHtmlElement(panel, 'DIV', 'card-header').html(hac['time']);

    const panelBody = createHtmlElement(panel, 'DIV', 'card-body');
    const table = createHtmlElement(panelBody, 'TABLE', 'table table-condensed borderless description-table');
    const tbody = createHtmlElement(table, 'TBODY');

    const createTableRow = function (label, info) {
        if (info == null || info === '') {
            return;
        }

        const tr = createHtmlElement(tbody, 'TR');
        createHtmlElement(tr, 'TD').html(label);
        createHtmlElement(tr, 'TD').html(info);
    }
    createTableRow(protocolmodalParams.user, hac['user']);
    createTableRow(protocolmodalParams.action, hac['axn']);
    createTableRow(protocolmodalParams.message, hac['rsn']);

    if (hac['addtnl'] != null && hac['addtnl'].trim() !== '') {
        createHtmlElement(panelBody, 'LABEL').html(protocolmodalParams.additionalInfo);
        createHtmlElement(panelBody, 'PRE', 'bl-pre-ticket').html(hac['addtnl']);
    }

    return panel;
}

function showProtocolModal(selection) {
    let id;
    if (typeof selection === "string"){
        id = selection;
    } else{
        selection = getSelectedNumericIds(protocolmodalParams.checkboxPrefix).split(',');
        if (selection == null || selection.length !== 1) {
            return;
        }
        id = selection[0];
    }

    const protocolModal = $('#protocol_modal');
    if (lastProtocolOrderId === id) {
        protocolModal.modal('show');
        return;
    }

    $('#protocol_modal_title').html(protocolmodalParams.title);

    const protocolModalContent = $('#protocol_modal_content');
    protocolModalContent.html(
        '<span class="fa fa-spinner fa-spin-pulse"></span>&nbsp;' + protocolmodalParams.fetching);
    protocolModal.modal('show');

    $('#protocol_print_button').attr(
        'href', protocolmodalParams.printLink.replace('999', id));
    $.ajax({
        url: protocolmodalParams.protocolLink.replace('999', id),
        success: function (response) {
            /**
             *
             * @type {
             *     {ordertype : string},
             *     {orderid : string},
             *     {ptks : [
             *     {ptk :string}
             *     ]},
             *     {hacs : [
             *         {time : string},
             *         {user : string},
             *         {axn : string},
             *         {rsn : string},
             *         {addtnl : string}
             *     ]},
             *     {error : string}
             * }
             */
            const json = JSON.parse(response);
            if (json.ordertype != null && json.orderid != null) {
                $('#protocol_modal_title').html(
                    protocolmodalParams.order.replace('ORDERTYPE', json.ordertype).replace('ORDERID', json.orderid));
            }
            protocolModalContent.html('');
            if (json.ptks != null) {
                const pre = createHtmlElement(protocolModalContent, 'PRE', 'bl-pre-ticket');
                json.ptks.forEach(function (ptk) {
                    if ($(pre).html().length !== 0) {
                        $(pre).append('<br>');
                    }
                    $(pre).append(ptk.ptk);
                });
            }
            if (json.hacs != null) {
                json.hacs.forEach(function (hac) {
                    createHacPanel(protocolModalContent, hac);
                });
            }
            const printButton = $('#protocol_print_button');
            if (json.error != null && json.error !== '') {
                createHtmlElement(protocolModalContent, 'DIV', 'alert alert-danger').html(json.error);
                printButton.addClass('disabled');
            } else {
                printButton.removeClass('disabled');
            }
            lastProtocolOrderId = id;
        },
        error: function (error) {
            console.log(error);
        }
    })
}
