/**
 * Parameters for the current script
 * @type {
 *     {fetchingMessage : string},
 *     {deleteTitle : {
 *         none : string,
 *         single : string,
 *         multiple : string
 *     }},
 *     {deleteQuestion : {
 *         none : string,
 *         single : string,
 *         multiple : string
 *     }},
 *     {refreshLink : string},
 *     {indexLink : string},
 *     {paymentInfos : [
 *         {id : number},
 *         {amount : String},
 *         {currency : String}
 *     ]},
 *     {addDecimalsUrl : String},
 * }
 */
const desHistoryParams = JSON.parse(atob($('#deshistory_js').data('params')));

function checkboxCallback(itemSelected) {
    let selectedOrderIds = getSelectedIds('des_history_table_select');
    if (itemSelected === 0) {
        $('#menu_delete_button').addClass('disabled disabled-menu-item');
    } else {
        $('#menu_delete_button').removeClass('disabled disabled-menu-item');
    }
    setHiddenFormTextParameter($('#deshistory_delete_modal_form'), selectedOrderIds);

    const saveLink = $('#deshistory_save_button');
    const printLink = $('#deshistory_print_button');
    if (itemSelected === 0) {
        $('#deshistory_delete_title').html(desHistoryParams.deleteTitle.none);
        $('#deshistory_delete_question').html(desHistoryParams.deleteQuestion.none);
        saveLink.addClass("disabled disabled-menu-item");
        saveLink.removeAttr('href');
        printLink.addClass("disabled disabled-menu-item");
        printLink.removeAttr('href');
    } else {
        saveLink.removeClass("disabled disabled-menu-item");
        saveLink.attr('href', saveLink.data('linktemplate').replace('999', selectedOrderIds));
        printLink.removeClass("disabled disabled-menu-item");
        printLink.attr('href', printLink.data('linktemplate').replace('999', selectedOrderIds));
        if (itemSelected === 1) {
            $('#deshistory_delete_title').html(desHistoryParams.deleteTitle.single);
            $('#deshistory_delete_question').html(desHistoryParams.deleteQuestion.single);
        } else {
            $('#deshistory_delete_title').html(desHistoryParams.deleteTitle.multiple.replace('999',
                itemSelected));
            $('#deshistory_delete_question').html(desHistoryParams.deleteQuestion.multiple.replace('999',
                itemSelected));
        }
    }
    updateSelectionInfo();
}


function updateSelectionInfo() {
    let paymentsNumber = 0;
    let id;
    const data = [];
    $('input[id^=des_history_table_select]:not(#des_history_table_select_all):checked').each(function () {
        let almostid=$(this).attr('id').substring("des_history_table_select_".length);
        id = parseInt(almostid);
        paymentsNumber++;
        desHistoryParams.paymentInfos.forEach(function (paymentInfo) {
            if (id === paymentInfo.id) {
                if(paymentInfo.amount){
                    let currency = paymentInfo.currency;
                    if(currency == null){
                        currency='EUR';
                    }
                    let singleData = '' + paymentInfo.amount +'-'+currency;
                    data.push(singleData);
                }else {
                    data.push('');
                }
            }
        });
    });
    if (paymentsNumber > 1) {
        $.ajaxSetup({
            beforeSend: function (xhr) {
                xhr.setRequestHeader('Csrf-Token', $('input[name="csrfToken"]').attr('value'));
            }
        });
        let ajaxUrl = desHistoryParams.addDecimalsUrl;
        $.ajax({
            url: ajaxUrl,
            data: JSON.stringify({data: data}),
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            type: 'POST',
            success: function (result) {
                if ($('input[id^=des_history_table_select]:not(#des_history_table_select_all):checked').length !== paymentsNumber) {
                    return; // this is an outdated ajax result, do not use it! (Bug 7082)
                }
                const resultAmountString = result.sumFiles;
                if (resultAmountString) {
                    const selectionInfo = $('#selection_info');
                    selectionInfo.html(result.sumFiles);
                    selectionInfo.show();
                }
            },
            error: function (result) {
                console.log(result)
            }
        });
    } else {
        $('#selection_info').hide();
    }
}

function refresh() {
    const refreshButton = $('#menu_refresh_button');
    if (!refreshButton.length) {
        return;
    }
    refreshButton.addClass('disabled disabled-menu-item');
    refreshButton.html(
        '<span class="fa fa-spinner fa-spin-pulse bl-action-menu-icon"></span>' + desHistoryParams.fetchingMessage);

    $.ajax({
        url: desHistoryParams.refreshLink,
        cache: false,
        success: function () {
            $(location).attr('href', desHistoryParams.indexLink);
        },
        error: function (message) {
            console.log(message);
            $(location).attr('href', desHistoryParams.indexLink);
        }
    });
}

$(document).ready(function () {
    $('#menu_refresh_button').click(refresh);
    updateSelectionInfo();
});
