function findBankNameFromIban(accountNumberField, bankNameField, searchUrlTemplate) {
    if (accountNumberField == null || accountNumberField.length === 0) {
        bankNameField.html('');
        bankNameField.hide();
        return;
    }

    const iban = accountNumberField.val().replace(/[^A-Za-z0-9]/g, '')
    if (iban == null || iban.length !== 22) {
        bankNameField.html('');
        bankNameField.hide();
        return;
    }

    $.ajax({
        type: 'GET',
        dataType: "text",
        mimeType: 'text/plain',
        url: searchUrlTemplate.replace('SEARCH', encodeURIComponent(iban)),
        success: function (result) {
            if (result != null && result.length > 0) {
                bankNameField.html(result);
                bankNameField.removeClass("hidden");
                bankNameField.show();
            } else {
                bankNameField.html('');
                bankNameField.hide();
            }
        },
        error: function (error) {
            console.log(error);
            bankNameField.html('');
            bankNameField.hide();
        }
    });
}

$(document).ready(function () {
    $('script[id$="_account_number_field_js"]').each(function () {
        const bankNameFromIbanUrl = $(this).data('bank_name_for_iban_url');
        const formFieldHtmlId = $(this).data('form_field_html_id');
        const descriptionHtmlId = $(this).data('description_html_id');
        $('#' + formFieldHtmlId).change(function () {
            findBankNameFromIban($(this), $('#' + descriptionHtmlId), bankNameFromIbanUrl);
        }).change();
    });
})