function handleDBTypeChange(event) {
  const urlField = $('#url');
  if(!urlField.data('changed')) {
    const type = $(event.currentTarget).val();
    const template = $('#databasesettings_js').data('db_type_' + type);
    urlField.val(template);
  }
}

function handleURLChange(event) {
  const urlField = $(event.currentTarget);
  $(event.currentTarget).data('changed', urlField.val().length !== 0);
}

$(document).ready(function () {
  $('#db_type').change(handleDBTypeChange);
  $('#url').change(handleURLChange);
});