const csvimportform_js = $('#csvimportform_js');
let columns;

function _loadColumns() {
    columns = [];
    for (let i = 0; i < csvimportform_js.data('columns'); i++) {
        columns[i] = csvimportform_js.data('column_' + i);
    }
}

let content;

function _loadContent() {
    content = [];
    for (let i = 0; i < csvimportform_js.data('lines'); i++) {
        content[i] = [];
        for (let j = 0; j < csvimportform_js.data('columns'); j++) {
            content[i][j] = csvimportform_js.attr('data-importdata_' + i + '_' + j);
        }
    }
}

function updateColumns() {
    if ($('#hasHeadline').prop('checked')) {
        let text;
        getFieldIds().forEach(function (fieldId) {
            $('#' + fieldId + ' option').each(function () {
                if ($(this).attr('value') !== '') {
                    text = columns[parseInt($(this).attr('value'))] + ' - '
                        + content[0][parseInt($(this).attr('value'))];
                    // Bug 6619: HTML-encode the column header to make sure that <script> tags are not executed
                    text = htmlEncodeAntiXSS(text);
                    if (text.length > 52) {
                        $(this).empty().append(text.substring(0, 50) + '&hellip;');
                        $(this).attr('dataToggle', 'tooltip');
                        $(this).attr('title', text);
                    } else {
                        $(this).empty().append(text);
                    }
                }
            });
        });
    } else {
        getFieldIds().forEach(function (fieldId) {
            $('#' + fieldId + ' option').each(function () {
                if ($(this).attr('value') !== '') {
                    let columnValueSanitized = $("<div/>").text(columns[parseInt($(this).attr('value'))]).html();
                    $(this).empty().append(columnValueSanitized);
                }
            });
        });
    }
    updateTable();
}

function updateTable() {
    const previewTable = $('#csv_import_preview_body');
    previewTable.empty();
    let start = 0;
    if ($('#hasHeadline').prop('checked')) {
        start = 1;
    }

    let tr;
    let td;
    let fieldSelect;
    for (let i = start; i < content.length; i++) {
        tr = createHtmlElement(previewTable, 'TR');

        getFieldIds().forEach(function (fieldId) {
            td = createHtmlElement(tr, 'TD');
            fieldSelect = $('#' + fieldId);
            if (fieldSelect.val() === '') {
                const fixValueField = $('#' + fieldId + '_fix');
                let fixValueSanitized = $("<div/>").text(fixValueField.val()).html();
                if (fixValueField.attr('type') !== 'text') {
                    if (fixValueField.val() === 'true') {
                        $(td).append(csvimportform_js.data('message-yes'));
                    } else if (fixValueField.val() === 'false') {
                        $(td).append(csvimportform_js.data('message-no'));
                    } else {
                        $(td).append(fixValueSanitized);
                    }
                } else {
                    $(td).append(fixValueSanitized);
                }
            } else {
                let columnValueSanitized = $("<div/>").text(content[i][parseInt(fieldSelect.val())]).html();
                $(td).append(columnValueSanitized);
            }
        });
    }
}

function fieldChanged(event) {
    switchFixField(event.target.id, true);
}

function switchFixField(fieldId, refreshTable) {
    if ($('#' + fieldId).val() === '') {
        $('#' + fieldId + '_fix').show();
    } else {
        $('#' + fieldId + '_fix').hide();
    }

    if (refreshTable) {
        updateTable();
    }
}

let fieldIds;

function getFieldIds() {
    if (fieldIds == null) {
        fieldIds = [];
        $('select:not(#numberFormat):not([id$="_fix"])').each(function () {
            fieldIds.push($(this).attr('id'));
        });

    }
    return fieldIds;
}

$(document).ready(function () {
    $('#hasHeadline').change(updateColumns);
    $('select.form-control:not([id$=_fix])').change(fieldChanged);
    $('input,select[id$=_fix]').change(updateTable);

    _loadColumns();
    _loadContent();
    $('[data-toggle="tooltip"]').tooltip();
    $('#csv_import_warning').hide();
    getFieldIds().forEach(function (fieldId) {
        switchFixField(fieldId, false);
    });
    updateColumns();

    const webSocket = new WebSocket(csvimportform_js.data('websocket-url'));
    if (webSocket != null) {
        let connectionOpen = false;
        webSocket.onopen = function () {
            connectionOpen = true;
            webSocket.send(csvimportform_js.data('file-id'));
        }
        webSocket.onerror = function (event) {
            console.log('Error on web socket: ' + event.message);
        };
        webSocket.onmessage = function (event) {
            console.log('Received message: ' + event.data);
        };
        let importing = false;
        $('#csv_import_submit').click(function () {
            // make sure that message-deleted is no longer displayed after submit was clicked
            importing = true;
            webSocket.send('COMMIT');
            $("#csv_import_warning").remove();
        });
        webSocket.onclose = function () {
            if (connectionOpen && !importing) {
                const warningMessage = $('#csv_import_warning');
                warningMessage.html(csvimportform_js.data('message-deleted'));
                warningMessage.show();
            }
        };
    }
});
